/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.linkconnector.IlvShapePath;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import oracle.diagram.core.util.CoreGraphicUtils;
import oracle.diagram.core.util.GraphicIterator;
import oracle.diagram.framework.graphic.IMultipresentationView;
import oracle.diagram.framework.link.LinkUtil;
import oracle.diagram.framework.manager.ManagerUtil;

public final class GraphicUtils
extends CoreGraphicUtils {
    public static final Stroke DOTTED_STROKE = new BasicStroke(0.5f, 0, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private static final float MIN_LABEL_WIDTH = 10.0f;
    private static final float MIN_LABEL_HEIGHT = 10.0f;

    private GraphicUtils() {
    }

    public static boolean isAncestorOf(IlvGraphic ancestor, IlvGraphic g) {
        IlvGraphicBag bag;
        if (ancestor == null) {
            return false;
        }
        if (g == null) {
            return false;
        }
        if (g == ancestor) {
            return true;
        }
        for (bag = g.getGraphicBag(); bag != null && !(bag instanceof IlvGraphic); bag = bag.getGraphicBag()) {
        }
        return GraphicUtils.isAncestorOf(ancestor, (IlvGraphic)bag);
    }

    public static IlvGraphic getObject(IlvPoint p, IlvManager mgr, IlvManagerView view, boolean traverse) {
        IlvGraphic graphic = mgr.getObject(p, view, traverse);
        if (graphic instanceof IlvLabelInterface) {
            return graphic;
        }
        GraphicIterator iterator = new GraphicIterator(mgr.getObjects(traverse));
        LinkedList<IlvGraphic> withinLabelGraphics = new LinkedList<IlvGraphic>();
        for (IlvGraphic g : iterator) {
            if (!mgr.isSelectable(g) || !GraphicUtils.isWithinLabel(g, p, view)) continue;
            withinLabelGraphics.add(g);
        }
        for (IlvGraphic g : withinLabelGraphics) {
            IlvManager sharedManager;
            if (graphic == null) {
                graphic = g;
                continue;
            }
            if (g == graphic || ManagerUtil.getLayerInManager(g, sharedManager = ManagerUtil.getSharedAncestor(graphic, g)) <= ManagerUtil.getLayerInManager(graphic, sharedManager)) continue;
            graphic = g;
        }
        return graphic;
    }

    public static boolean isWithinLabel(IlvGraphic g, IlvPoint p, IlvManagerView view) {
        if (g instanceof IlvLabelInterface && g.isVisible()) {
            IlvManager txMgr = ManagerUtil.getTransformingManager(g);
            if (txMgr == null) {
                return false;
            }
            IlvRect r = ((IlvLabelInterface)g).getLabelBBox(txMgr.getDrawingTransformer(view));
            if (r == null) {
                return false;
            }
            if (r.contains((double)p.x, (double)p.y)) {
                return true;
            }
            if (r.width < 10.0f || r.height < 10.0f) {
                if (r.width < 10.0f) {
                    r.x -= (10.0f - r.width) / 2.0f;
                    r.width = 10.0f;
                }
                if (r.height < 10.0f) {
                    r.y -= (10.0f - r.height) / 2.0f;
                    r.height = 10.0f;
                }
                if (r.contains((double)p.x, (double)p.y)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isParentSelected(IlvGraphic g) {
        IlvGraphic managedParent = GraphicUtils.getManagedParent(g);
        if (managedParent instanceof IMultipresentationView) {
            IlvGrapher view = ((IMultipresentationView)managedParent).getContainer();
            assert (view != null);
            return view.getParent() != null && view.getParent().isSelected((IlvGraphic)view);
        }
        return managedParent != null && ((IlvManager)managedParent.getGraphicBag()).isSelected(managedParent);
    }

    public static boolean isParentNodeSelected(IlvGraphic g) {
        IlvGraphic managedParent = GraphicUtils.getManagedParentNode(g);
        return managedParent != null && ((IlvManager)managedParent.getGraphicBag()).isSelected(managedParent);
    }

    public static AffineTransform createAffineTransform(IlvTransformer t) {
        return new AffineTransform(t.getx11(), t.getx21(), t.getx12(), t.getx22(), t.getx0(), t.gety0());
    }

    public static IlvManager getParentManager(IlvGraphic g) {
        IlvGraphic graphic = GraphicUtils.getManagedParent(g);
        if (graphic != null) {
            return (IlvManager)graphic.getGraphicBag();
        }
        return null;
    }

    public static IlvPoint calcRelativeOffset(IlvGraphic movingGraphic, IlvPoint relativeFromPoint, IlvPoint relativeToPoint, IlvTransformer dstTransformer) {
        IlvPoint targetDropPoint = new IlvPoint(relativeToPoint);
        dstTransformer.inverse(targetDropPoint);
        IlvManager mgr = ManagerUtil.getTransformingManager(movingGraphic);
        IlvTransformer t = mgr.getTopLevelTransformer();
        IlvPoint position = new IlvPoint();
        if (t != null) {
            IlvRect nodeRect = movingGraphic.boundingBox();
            t.apply(nodeRect);
            dstTransformer.inverse(nodeRect);
            position = new IlvPoint(relativeFromPoint.x, relativeFromPoint.y);
            dstTransformer.inverse(position);
            position.x = targetDropPoint.x + nodeRect.x - position.x;
            position.y = targetDropPoint.y + nodeRect.y - position.y;
        }
        return position;
    }

    public static IlvTransformer getTopTransformer(IlvGraphic obj) {
        IlvTransformer t = null;
        IlvManager mgr = null;
        mgr = obj instanceof IlvManager ? (IlvManager)obj : ManagerUtil.getTransformingManager(obj);
        if (mgr != null) {
            t = mgr.getTopLevelTransformer();
        }
        return t;
    }

    public static IlvRect getPathBBox(PathIterator pi) {
        float[] pts = new float[6];
        IlvRect r = new IlvRect();
        float maxX = Float.MIN_VALUE;
        float minX = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        float minY = Float.MAX_VALUE;
        while (!pi.isDone()) {
            int segType = pi.currentSegment(pts);
            switch (segType) {
                case 0: 
                case 1: {
                    maxX = Math.max(pts[0], maxX);
                    minX = Math.min(pts[0], minX);
                    maxY = Math.max(pts[1], maxY);
                    minY = Math.min(pts[1], minY);
                    break;
                }
                case 2: {
                    maxX = Math.max(pts[0], maxX);
                    minX = Math.min(pts[0], minX);
                    maxY = Math.max(pts[1], maxY);
                    minY = Math.min(pts[1], minY);
                    maxX = Math.max(pts[2], maxX);
                    minX = Math.min(pts[2], minX);
                    maxY = Math.max(pts[3], maxY);
                    minY = Math.min(pts[3], minY);
                    break;
                }
                case 3: {
                    maxX = Math.max(pts[0], maxX);
                    minX = Math.min(pts[0], minX);
                    maxY = Math.max(pts[1], maxY);
                    minY = Math.min(pts[1], minY);
                    maxX = Math.max(pts[2], maxX);
                    minX = Math.min(pts[2], minX);
                    maxY = Math.max(pts[3], maxY);
                    minY = Math.min(pts[3], minY);
                    maxX = Math.max(pts[4], maxX);
                    minX = Math.min(pts[4], minX);
                    maxY = Math.max(pts[5], maxY);
                    minY = Math.min(pts[5], minY);
                }
            }
            pi.next();
        }
        r.setRect(minX, minY, maxX - minX, maxY - minY);
        return r;
    }

    public static IlvRect getGraphicOutlineBox(IlvGraphic graphic, IlvTransformer t) {
        if (graphic instanceof IlvShapePath) {
            IlvRect outlineBox = GraphicUtils.getPathBBox(((IlvShapePath)graphic).getShapePath(t));
            return outlineBox;
        }
        return graphic.boundingBox(t);
    }

    public static IlvPoint getCentrePoint(IlvGraphic g, IlvTransformer t) {
        IlvPoint centre = null;
        if (g instanceof IlvLinkImage) {
            centre = LinkUtil.calcLinkMidPoint((IlvLinkImage)g);
        } else {
            IlvRect bbox = g.boundingBox();
            centre = new IlvPoint((float)bbox.getCenterX(), (float)bbox.getCenterY());
        }
        if (t != null) {
            t.apply(centre);
        }
        return centre;
    }

    public static PathIterator getCounterClockwiseRectPathIterator(Rectangle2D rect) {
        if (rect == null) {
            throw new IllegalArgumentException("rect is null");
        }
        return new CounterClockwiseRectPathIterator(rect);
    }

    private static class CounterClockwiseRectPathIterator
    implements PathIterator {
        private double _x1;
        private double _y1;
        private double _x2;
        private double _y2;
        private int _pathCount;

        CounterClockwiseRectPathIterator(Rectangle2D rect) {
            this._x1 = rect.getX();
            this._y1 = rect.getY();
            this._x2 = this._x1 + rect.getWidth();
            this._y2 = this._y1 + rect.getHeight();
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this._pathCount > 4;
        }

        @Override
        public void next() {
            if (this._pathCount <= 4) {
                ++this._pathCount;
            }
        }

        @Override
        public int currentSegment(float[] coords) {
            int code = 0;
            switch (this._pathCount) {
                case 0: {
                    coords[0] = (float)this._x1;
                    coords[1] = (float)this._y1;
                    code = 0;
                    break;
                }
                case 1: {
                    coords[0] = (float)this._x1;
                    coords[1] = (float)this._y2;
                    code = 1;
                    break;
                }
                case 2: {
                    coords[0] = (float)this._x2;
                    coords[1] = (float)this._y2;
                    code = 1;
                    break;
                }
                case 3: {
                    coords[0] = (float)this._x2;
                    coords[1] = (float)this._y1;
                    code = 1;
                    break;
                }
                case 4: {
                    coords[0] = (float)this._x1;
                    coords[1] = (float)this._y1;
                    code = 1;
                    break;
                }
                default: {
                    code = -1;
                }
            }
            return code;
        }

        @Override
        public int currentSegment(double[] coords) {
            int code = 0;
            switch (this._pathCount) {
                case 0: {
                    coords[0] = this._x1;
                    coords[1] = this._y1;
                    code = 0;
                    break;
                }
                case 1: {
                    coords[0] = this._x1;
                    coords[1] = this._y2;
                    code = 1;
                    break;
                }
                case 2: {
                    coords[0] = this._x2;
                    coords[1] = this._y2;
                    code = 1;
                    break;
                }
                case 3: {
                    coords[0] = this._x2;
                    coords[1] = this._y1;
                    code = 1;
                    break;
                }
                case 4: {
                    coords[0] = this._x1;
                    coords[1] = this._y1;
                    code = 1;
                }
            }
            return code;
        }
    }
}

