/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.filter;

import java.util.ArrayList;
import java.util.List;

public interface Filter<T> {
    public static final Filter ALL = new Filter<Object>(){

        @Override
        public boolean accept(Object object) {
            return true;
        }

        public String toString() {
            return "true";
        }
    };
    public static final Filter NONE = new Filter<Object>(){

        @Override
        public boolean accept(Object object) {
            return false;
        }

        public String toString() {
            return "false";
        }
    };

    public boolean accept(T var1);

    public static class NotFilter<T>
    implements Filter<T> {
        private Filter<T> m_1;

        public NotFilter(Filter<T> p1) {
            this.m_1 = p1;
        }

        @Override
        public boolean accept(T object) {
            return !this.m_1.accept(object);
        }

        public String toString() {
            return "NOT ( " + this.m_1 + " )";
        }
    }

    public static class OrFilter<T>
    implements Filter<T> {
        private Filter<T>[] m;

        public OrFilter(Filter<T> ... args) {
            this.m = args;
        }

        @Override
        public boolean accept(T object) {
            for (Filter<T> filter : this.m) {
                if (!filter.accept(object)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (Filter<T> filter : this.m) {
                sb.append(filter);
                sb.append(" OR ");
            }
            sb.append(')');
            return sb.toString();
        }
    }

    public static class AndFilter<T>
    implements Filter<T> {
        private Filter<T>[] m;

        public AndFilter(Filter<T> ... args) {
            this.m = args;
        }

        @Override
        public boolean accept(T object) {
            for (Filter<T> filter : this.m) {
                if (filter.accept(object)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (Filter<T> filter : this.m) {
                sb.append(filter);
                sb.append(" AND ");
            }
            sb.append(')');
            return sb.toString();
        }
    }

    public static class AssignableFrom<T>
    implements Filter<T> {
        private Class m_discrim;

        public AssignableFrom(Class discrim) {
            this.m_discrim = discrim;
        }

        @Override
        public boolean accept(T object) {
            return this.m_discrim.isAssignableFrom(object.getClass());
        }

        public String toString() {
            return this.getShortName() + ".isAssignableFrom(object.getClass())";
        }

        private String getShortName() {
            String shortName = this.m_discrim.getName();
            int lastDot = shortName.lastIndexOf(46);
            if (lastDot != -1) {
                shortName = shortName.substring(lastDot + 1, shortName.length());
            }
            return shortName;
        }
    }

    public static class Util {
        public static <T> List<T> filter(List<T> input, Filter<T> filter) {
            ArrayList<T> output = new ArrayList<T>();
            for (T o : input) {
                if (!filter.accept(o)) continue;
                output.add(o);
            }
            return output;
        }

        private Util() {
        }
    }
}

