/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.execute;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.ide.db.execute.DBRequestProcessor;

public class DBRequestProcessorImpl
extends AbstractExecutorService {
    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        if (runnable instanceof DBRequestProcessor.DBRunnable) {
            return new FutureImpl<T>((DBRequestProcessor.DBRunnable)runnable, value);
        }
        throw new IllegalArgumentException("Expected a DBRequestProcessor.DBRunnable");
    }

    @Override
    public void execute(final Runnable command) {
        DBRequestProcessor.DBRunnable dbRunnable;
        if (command instanceof FutureImpl) {
            dbRunnable = ((FutureImpl)command).m_run;
        } else if (command instanceof DBRequestProcessor.DBRunnable) {
            dbRunnable = (DBRequestProcessor.DBRunnable)command;
        } else {
            throw new IllegalArgumentException("Expected a DBRequestProcessor.DBRunnable");
        }
        RaptorTask task = new RaptorTask(dbRunnable.getName(), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Object doWork() throws TaskException {
                command.run();
                return null;
            }
        };
        task.setMessage(dbRunnable.getName());
        RaptorTaskManager.getInstance().addTask(task);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    private class FutureImpl<V>
    extends FutureTask<V> {
        private final DBRequestProcessor.DBRunnable m_run;

        FutureImpl(DBRequestProcessor.DBRunnable run, V get) {
            super((Runnable)run, get);
            this.m_run = run;
        }
    }
}

