/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.lob;

import oracle.kv.FaultException;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.lob.KVLargeObject;

public class PartialLOBException
extends FaultException {
    private static final long serialVersionUID = 1L;
    private final KVLargeObject.LOBState partialState;

    public PartialLOBException(String msg, KVLargeObject.LOBState partialState, boolean isRemote) {
        super(msg, isRemote);
        ObjectUtil.checkNull("partialState", (Object)partialState);
        if (partialState == KVLargeObject.LOBState.COMPLETE) {
            String emsg = "The value of partialState must denote a partial state not " + (Object)((Object)partialState);
            throw new IllegalArgumentException(emsg);
        }
        this.partialState = partialState;
    }

    public KVLargeObject.LOBState getPartialState() {
        return this.partialState;
    }

    @Deprecated
    public boolean isPartiallyDeleted() {
        return KVLargeObject.LOBState.PARTIAL_DELETE == this.partialState;
    }
}

