/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.lang.reflect.Constructor;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.KVStorePrivilegeLabel;
import oracle.kv.impl.security.SystemPrivilege;

public abstract class TablePrivilege
extends KVStorePrivilege {
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final long tableId;
    private static final EnumMap<KVStorePrivilegeLabel, Class<? extends TablePrivilege>> tablePrivClassMap = new EnumMap(KVStorePrivilegeLabel.class);

    private TablePrivilege(KVStorePrivilegeLabel privLabel, long tableId, String tableName) {
        super(privLabel);
        this.tableId = tableId;
        this.tableName = tableName;
    }

    private TablePrivilege(KVStorePrivilegeLabel privLabel, long tableId) {
        this(privLabel, tableId, (String)null);
    }

    public static TablePrivilege get(KVStorePrivilegeLabel privLabel, long tableId, String tableName) {
        if (privLabel.getType() != KVStorePrivilege.PrivilegeType.TABLE) {
            throw new IllegalArgumentException("Could not obtain a table privilege with a non-table privilege label " + (Object)((Object)privLabel));
        }
        Class<? extends TablePrivilege> tablePrivClass = tablePrivClassMap.get((Object)privLabel);
        if (tablePrivClass == null) {
            throw new IllegalArgumentException("Could not find a table privilege with label of " + (Object)((Object)privLabel));
        }
        try {
            Constructor<? extends TablePrivilege> ctor = tablePrivClass.getConstructor(Long.TYPE, String.class);
            return ctor.newInstance(tableId, tableName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not instantiate a table privilege: " + e.getMessage());
        }
    }

    public static Set<TablePrivilege> getAllTablePrivileges(long tableId, String tableName) {
        HashSet<TablePrivilege> tablePrivs = new HashSet<TablePrivilege>();
        for (KVStorePrivilegeLabel privLabel : tablePrivClassMap.keySet()) {
            tablePrivs.add(TablePrivilege.get(privLabel, tableId, tableName));
        }
        return tablePrivs;
    }

    public long getTableId() {
        return this.tableId;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        TablePrivilege otherTablePriv = (TablePrivilege)other;
        return this.tableId == otherTablePriv.tableId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 527 + super.hashCode();
        result = result * 31 + (int)(this.tableId ^ this.tableId >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return String.format("%s(%s)", new Object[]{this.getLabel(), this.tableName});
    }

    static {
        tablePrivClassMap.put(KVStorePrivilegeLabel.DELETE_TABLE, DeleteTable.class);
        tablePrivClassMap.put(KVStorePrivilegeLabel.READ_TABLE, ReadTable.class);
        tablePrivClassMap.put(KVStorePrivilegeLabel.INSERT_TABLE, InsertTable.class);
        tablePrivClassMap.put(KVStorePrivilegeLabel.EVOLVE_TABLE, EvolveTable.class);
        tablePrivClassMap.put(KVStorePrivilegeLabel.CREATE_INDEX, CreateIndex.class);
        tablePrivClassMap.put(KVStorePrivilegeLabel.DROP_INDEX, DropIndex.class);
    }

    public static final class DropIndex
    extends TablePrivilege {
        private static final long serialVersionUID = 1L;
        private static final KVStorePrivilege[] implyingPrivs = new KVStorePrivilege[]{SystemPrivilege.SYSDBA, SystemPrivilege.DROP_ANY_INDEX};

        public DropIndex(long tableId, String tableName) {
            super(KVStorePrivilegeLabel.DROP_INDEX, tableId, tableName);
        }

        public DropIndex(long tableId) {
            super(KVStorePrivilegeLabel.DROP_INDEX, tableId);
        }

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return implyingPrivs;
        }
    }

    public static final class CreateIndex
    extends TablePrivilege {
        private static final long serialVersionUID = 1L;
        private static final KVStorePrivilege[] implyingPrivs = new KVStorePrivilege[]{SystemPrivilege.SYSDBA, SystemPrivilege.CREATE_ANY_INDEX};

        public CreateIndex(long tableId, String tableName) {
            super(KVStorePrivilegeLabel.CREATE_INDEX, tableId, tableName);
        }

        public CreateIndex(long tableId) {
            super(KVStorePrivilegeLabel.CREATE_INDEX, tableId);
        }

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return implyingPrivs;
        }
    }

    public static final class EvolveTable
    extends TablePrivilege {
        private static final long serialVersionUID = 1L;
        private static final KVStorePrivilege[] implyingPrivs = new KVStorePrivilege[]{SystemPrivilege.SYSDBA, SystemPrivilege.EVOLVE_ANY_TABLE};

        public EvolveTable(long tableId, String tableName) {
            super(KVStorePrivilegeLabel.EVOLVE_TABLE, tableId, tableName);
        }

        public EvolveTable(long tableId) {
            super(KVStorePrivilegeLabel.EVOLVE_TABLE, tableId);
        }

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return implyingPrivs;
        }
    }

    public static final class DeleteTable
    extends TablePrivilege {
        private static final long serialVersionUID = 1L;
        private static final KVStorePrivilege[] implyingPrivs = new KVStorePrivilege[]{SystemPrivilege.WRITE_ANY, SystemPrivilege.DELETE_ANY_TABLE};

        public DeleteTable(long tableId, String tableName) {
            super(KVStorePrivilegeLabel.DELETE_TABLE, tableId, tableName);
        }

        public DeleteTable(long tableId) {
            super(KVStorePrivilegeLabel.DELETE_TABLE, tableId);
        }

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return implyingPrivs;
        }
    }

    public static final class InsertTable
    extends TablePrivilege {
        private static final long serialVersionUID = 1L;
        private static final KVStorePrivilege[] implyingPrivs = new KVStorePrivilege[]{SystemPrivilege.WRITE_ANY, SystemPrivilege.INSERT_ANY_TABLE};

        public InsertTable(long tableId, String tableName) {
            super(KVStorePrivilegeLabel.INSERT_TABLE, tableId, tableName);
        }

        public InsertTable(long tableId) {
            super(KVStorePrivilegeLabel.INSERT_TABLE, tableId);
        }

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return implyingPrivs;
        }
    }

    public static final class ReadTable
    extends TablePrivilege {
        private static final long serialVersionUID = 1L;
        private static final KVStorePrivilege[] implyingPrivs = new KVStorePrivilege[]{SystemPrivilege.READ_ANY, SystemPrivilege.READ_ANY_TABLE};

        public ReadTable(long tableId, String tableName) {
            super(KVStorePrivilegeLabel.READ_TABLE, tableId, tableName);
        }

        public ReadTable(long tableId) {
            super(KVStorePrivilegeLabel.READ_TABLE, tableId);
        }

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return implyingPrivs;
        }
    }
}

