/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.KVStorePrivilegeLabel;

public class SystemPrivilege
extends KVStorePrivilege {
    private static final long serialVersionUID = 1L;
    public static final SystemPrivilege READ_ANY = new SystemPrivilege(KVStorePrivilegeLabel.READ_ANY);
    public static final SystemPrivilege WRITE_ANY = new SystemPrivilege(KVStorePrivilegeLabel.WRITE_ANY);
    public static final SystemPrivilege SYSVIEW = new SystemPrivilege(KVStorePrivilegeLabel.SYSVIEW);
    public static final SystemPrivilege USRVIEW = new SystemPrivilege(KVStorePrivilegeLabel.USRVIEW);
    public static final SystemPrivilege SYSOPER = new SystemPrivilege(KVStorePrivilegeLabel.SYSOPER);
    public static final SystemPrivilege INTLOPER = new SystemPrivilege(KVStorePrivilegeLabel.INTLOPER);
    public static final SystemPrivilege DBVIEW = new SystemPrivilege(KVStorePrivilegeLabel.DBVIEW);
    public static final SystemPrivilege SYSDBA = new SystemPrivilege(KVStorePrivilegeLabel.SYSDBA);
    private static final KVStorePrivilege[] emptyPriv = new KVStorePrivilege[0];
    private static final KVStorePrivilege[] sysdba = new KVStorePrivilege[]{SYSDBA};
    private static final KVStorePrivilege[] dbviewAndSysdba = new KVStorePrivilege[]{DBVIEW, SYSDBA};
    private static final KVStorePrivilege[] readany = new KVStorePrivilege[]{READ_ANY};
    private static final KVStorePrivilege[] writeany = new KVStorePrivilege[]{WRITE_ANY};
    public static final SystemPrivilege READ_ANY_SCHEMA = new SystemPrivilege(KVStorePrivilegeLabel.READ_ANY_SCHEMA){
        private static final long serialVersionUID = 1L;

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return dbviewAndSysdba;
        }
    };
    public static final SystemPrivilege WRITE_ANY_SCHEMA = new SystemPrivilege(KVStorePrivilegeLabel.WRITE_ANY_SCHEMA){
        private static final long serialVersionUID = 1L;

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return sysdba;
        }
    };
    public static final SystemPrivilege READ_ANY_TABLE = new SystemPrivilege(KVStorePrivilegeLabel.READ_ANY_TABLE){
        private static final long serialVersionUID = 1L;

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return readany;
        }
    };
    public static final SystemPrivilege DELETE_ANY_TABLE = new SystemPrivilege(KVStorePrivilegeLabel.DELETE_ANY_TABLE){
        private static final long serialVersionUID = 1L;

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return writeany;
        }
    };
    public static final SystemPrivilege INSERT_ANY_TABLE = new SystemPrivilege(KVStorePrivilegeLabel.INSERT_ANY_TABLE){
        private static final long serialVersionUID = 1L;

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return writeany;
        }
    };
    public static final SystemPrivilege CREATE_ANY_TABLE = new SystemPrivilege(KVStorePrivilegeLabel.CREATE_ANY_TABLE){
        private static final long serialVersionUID = 1L;

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return sysdba;
        }
    };
    public static final SystemPrivilege DROP_ANY_TABLE = new SystemPrivilege(KVStorePrivilegeLabel.DROP_ANY_TABLE){
        private static final long serialVersionUID = 1L;

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return sysdba;
        }
    };
    public static final SystemPrivilege EVOLVE_ANY_TABLE = new SystemPrivilege(KVStorePrivilegeLabel.EVOLVE_ANY_TABLE){
        private static final long serialVersionUID = 1L;

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return sysdba;
        }
    };
    public static final SystemPrivilege CREATE_ANY_INDEX = new SystemPrivilege(KVStorePrivilegeLabel.CREATE_ANY_INDEX){
        private static final long serialVersionUID = 1L;

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return sysdba;
        }
    };
    public static final SystemPrivilege DROP_ANY_INDEX = new SystemPrivilege(KVStorePrivilegeLabel.DROP_ANY_INDEX){
        private static final long serialVersionUID = 1L;

        @Override
        public KVStorePrivilege[] implyingPrivileges() {
            return sysdba;
        }
    };
    private static final EnumMap<KVStorePrivilegeLabel, SystemPrivilege> sysPrivilegeMap = new EnumMap(KVStorePrivilegeLabel.class);
    private static final Set<SystemPrivilege> allSysPrivs;
    public static final List<SystemPrivilege> dbviewPrivList;
    public static final List<SystemPrivilege> sysdbaPrivList;
    public static final List<SystemPrivilege> internalPrivList;
    public static final List<SystemPrivilege> sysviewPrivList;
    public static final List<SystemPrivilege> usrviewPrivList;
    public static final List<SystemPrivilege> sysoperPrivList;
    public static final List<SystemPrivilege> writeOnlyPrivList;
    public static final List<SystemPrivilege> readOnlyPrivList;
    public static final List<SystemPrivilege> schemaReadPrivList;
    public static final List<SystemPrivilege> schemaWritePrivList;
    public static final List<SystemPrivilege> tableCreatePrivList;
    public static final List<SystemPrivilege> tableDropPrivList;

    SystemPrivilege(KVStorePrivilegeLabel privLabel) {
        super(privLabel);
        if (privLabel.getType() != KVStorePrivilege.PrivilegeType.SYSTEM) {
            throw new IllegalArgumentException("Could not create a system privilege using a non-system privilege label " + (Object)((Object)privLabel));
        }
    }

    public static SystemPrivilege get(KVStorePrivilegeLabel privLabel) {
        if (privLabel.getType() != KVStorePrivilege.PrivilegeType.SYSTEM) {
            throw new IllegalArgumentException("Could not obtain a system privilege with a non-system privilege label " + (Object)((Object)privLabel));
        }
        return sysPrivilegeMap.get((Object)privLabel);
    }

    public static Set<SystemPrivilege> getAllSystemPrivileges() {
        return allSysPrivs;
    }

    @Override
    public KVStorePrivilege[] implyingPrivileges() {
        return emptyPriv;
    }

    static {
        sysPrivilegeMap.put(READ_ANY.getLabel(), READ_ANY);
        sysPrivilegeMap.put(WRITE_ANY.getLabel(), WRITE_ANY);
        sysPrivilegeMap.put(SYSDBA.getLabel(), SYSDBA);
        sysPrivilegeMap.put(SYSVIEW.getLabel(), SYSVIEW);
        sysPrivilegeMap.put(DBVIEW.getLabel(), DBVIEW);
        sysPrivilegeMap.put(USRVIEW.getLabel(), USRVIEW);
        sysPrivilegeMap.put(SYSOPER.getLabel(), SYSOPER);
        sysPrivilegeMap.put(INTLOPER.getLabel(), INTLOPER);
        sysPrivilegeMap.put(CREATE_ANY_TABLE.getLabel(), CREATE_ANY_TABLE);
        sysPrivilegeMap.put(READ_ANY_TABLE.getLabel(), READ_ANY_TABLE);
        sysPrivilegeMap.put(INSERT_ANY_TABLE.getLabel(), INSERT_ANY_TABLE);
        sysPrivilegeMap.put(DELETE_ANY_TABLE.getLabel(), DELETE_ANY_TABLE);
        sysPrivilegeMap.put(DROP_ANY_TABLE.getLabel(), DROP_ANY_TABLE);
        sysPrivilegeMap.put(EVOLVE_ANY_TABLE.getLabel(), EVOLVE_ANY_TABLE);
        sysPrivilegeMap.put(CREATE_ANY_INDEX.getLabel(), CREATE_ANY_INDEX);
        sysPrivilegeMap.put(DROP_ANY_INDEX.getLabel(), DROP_ANY_INDEX);
        allSysPrivs = new HashSet<SystemPrivilege>(sysPrivilegeMap.values());
        dbviewPrivList = Collections.singletonList(DBVIEW);
        sysdbaPrivList = Collections.singletonList(SYSDBA);
        internalPrivList = Collections.singletonList(INTLOPER);
        sysviewPrivList = Collections.singletonList(SYSVIEW);
        usrviewPrivList = Collections.singletonList(USRVIEW);
        sysoperPrivList = Collections.singletonList(SYSOPER);
        writeOnlyPrivList = Collections.singletonList(WRITE_ANY);
        readOnlyPrivList = Collections.singletonList(READ_ANY);
        schemaReadPrivList = Collections.singletonList(READ_ANY_SCHEMA);
        schemaWritePrivList = Collections.singletonList(WRITE_ANY_SCHEMA);
        tableCreatePrivList = Collections.singletonList(CREATE_ANY_TABLE);
        tableDropPrivList = Collections.singletonList(DROP_ANY_TABLE);
    }
}

