/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.client.admin;

import oracle.kv.StatementResult;
import oracle.kv.impl.client.admin.ExecutionInfo;

class AdminResult
implements StatementResult {
    private final boolean success;
    private final int planId;
    private final String info;
    private final String jsonInfo;
    private final String errorMessage;
    private final boolean isDone;
    private final boolean isCancelled;
    private final String result;

    AdminResult(int planId, ExecutionInfo executionInfo, boolean isDone, boolean isCancelled) {
        this.planId = planId;
        this.isDone = isDone;
        this.isCancelled = isCancelled;
        if (executionInfo == null) {
            if (planId == 0) {
                this.success = true;
                this.info = "The statement did not require any additional execution";
            } else {
                this.success = false;
                this.info = null;
            }
            this.errorMessage = null;
            this.jsonInfo = null;
            this.result = null;
        } else {
            this.success = executionInfo.isSuccess();
            this.info = executionInfo.getInfo();
            this.jsonInfo = executionInfo.getJSONInfo();
            this.errorMessage = executionInfo.getErrorMessage();
            this.result = executionInfo.getResult();
        }
    }

    @Override
    public boolean isSuccessful() {
        return this.success;
    }

    @Override
    public int getPlanId() {
        return this.planId;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public String getInfoAsJson() {
        return this.jsonInfo;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return "AdminResult [success=" + this.success + ", planId=" + this.planId + ",\ninfo=" + this.info + ", \njsonInfo=" + this.jsonInfo + ",\nerrorMessage=" + this.errorMessage + ", isDone=" + this.isDone + ", isCancelled=" + this.isCancelled + ", result=" + this.result + "]";
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public String getResult() {
        return this.result;
    }
}

