/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.FieldDef;
import oracle.kv.table.LongDef;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
class LongDefImpl
extends FieldDefImpl
implements LongDef {
    private static final long serialVersionUID = 1L;
    private final Long min;
    private final Long max;
    private int encodingLength;

    LongDefImpl(String description, Long min, Long max) {
        super(FieldDef.Type.LONG, description);
        this.min = min;
        this.max = max;
        this.validate();
    }

    LongDefImpl() {
        super(FieldDef.Type.LONG);
        this.min = null;
        this.max = null;
        this.encodingLength = 0;
    }

    private LongDefImpl(LongDefImpl impl) {
        super(impl);
        this.min = impl.min;
        this.max = impl.max;
        this.encodingLength = impl.encodingLength;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public LongDef asLong() {
        return this;
    }

    @Override
    public Long getMin() {
        return this.min;
    }

    @Override
    public Long getMax() {
        return this.max;
    }

    @Override
    public boolean isValidKeyField() {
        return true;
    }

    @Override
    public boolean isValidIndexField() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof LongDefImpl) {
            LongDefImpl otherDef = (LongDefImpl)other;
            return this.compare(this.min, otherDef.min) && this.compare(this.max, otherDef.max);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.min != null ? this.min.hashCode() : 0) + (this.max != null ? this.max.hashCode() : 0);
    }

    @Override
    int getEncodingLength() {
        return this.encodingLength;
    }

    @Override
    void toJson(ObjectNode node) {
        super.toJson(node);
        if (this.min != null) {
            node.put("min", this.min);
        }
        if (this.max != null) {
            node.put("max", this.max);
        }
    }

    @Override
    public LongDefImpl clone() {
        return new LongDefImpl(this);
    }

    @Override
    public LongValueImpl createLong(long value) {
        this.validateRange(value);
        return new LongValueImpl(value);
    }

    private void validate() {
        if (this.min != null && this.max != null && this.min > this.max) {
            throw new IllegalArgumentException("Invalid minimum or maximum value");
        }
        this.encodingLength = SortableString.encodingLength(this.min, this.max);
    }

    private void validateRange(long val) {
        if (this.min != null && val < this.min || this.max != null && val > this.max) {
            StringBuilder sb = new StringBuilder();
            sb.append("Value, ");
            sb.append(val);
            sb.append(", is outside of the allowed range");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isLong()) {
            throw new IllegalArgumentException("Default value for type LONG is not long");
        }
        return this.createLong(node.getLongValue());
    }
}

