/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import oracle.kv.Direction;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiTableOperation;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.TablePrivilege;

abstract class TableIterateOperation
extends MultiTableOperation {
    private final boolean majorComplete;
    private final Direction direction;
    private final int batchSize;
    private final byte[] resumeKey;

    protected TableIterateOperation(InternalOperation.OpCode opCode, StoreIteratorParams sip, TargetTables targetTables, boolean majorComplete, byte[] resumeKey) {
        super(opCode, sip.getParentKeyBytes(), targetTables, sip.getSubRange());
        this.majorComplete = majorComplete;
        this.direction = sip.getDirection();
        this.batchSize = sip.getBatchSize();
        this.resumeKey = resumeKey;
    }

    protected TableIterateOperation(InternalOperation.OpCode opCode, byte[] parentKeyBytes, TargetTables targetTables, boolean majorComplete, int batchSize, byte[] resumeKey) {
        super(opCode, parentKeyBytes, targetTables, null);
        this.majorComplete = majorComplete;
        this.direction = Direction.FORWARD;
        this.batchSize = batchSize;
        this.resumeKey = resumeKey;
    }

    TableIterateOperation(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.majorComplete = in.readBoolean();
        this.direction = Direction.getDirection(in.readUnsignedByte());
        this.batchSize = in.readInt();
        short keyLen = in.readShort();
        if (keyLen < 0) {
            this.resumeKey = null;
        } else {
            this.resumeKey = new byte[keyLen];
            in.readFully(this.resumeKey);
        }
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeBoolean(this.majorComplete);
        out.writeByte(this.direction.ordinal());
        out.writeInt(this.batchSize);
        if (this.resumeKey == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(this.resumeKey.length);
            out.write(this.resumeKey);
        }
    }

    Direction getDirection() {
        return this.direction;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    byte[] getResumeKey() {
        return this.resumeKey;
    }

    boolean getMajorComplete() {
        return this.majorComplete;
    }

    @Override
    public List<? extends KVStorePrivilege> tableAccessPrivileges(long tableId) {
        return Collections.singletonList(new TablePrivilege.ReadTable(tableId));
    }
}

