/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.ArrayList;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyIterate;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.topo.PartitionId;

public class MultiGetKeysIterate
extends MultiKeyIterate {
    public MultiGetKeysIterate(byte[] parentKey, KeyRange subRange, Depth depth, Direction direction, int batchSize, byte[] resumeKey) {
        super(InternalOperation.OpCode.MULTI_GET_KEYS_ITERATE, parentKey, subRange, depth, direction, batchSize, resumeKey);
    }

    MultiGetKeysIterate(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.MULTI_GET_KEYS_ITERATE, in, serialVersion);
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, OperationHandler operationHandler) {
        OperationHandler.KVAuthorizer kvAuth = this.checkPermission(operationHandler);
        ArrayList<byte[]> results = new ArrayList<byte[]>();
        boolean moreElements = operationHandler.iterateKeys(txn, partitionId, this.getParentKey(), true, this.getSubRange(), this.getDepth(), this.getDirection(), this.getBatchSize(), this.getResumeKey(), OperationHandler.CURSOR_READ_COMMITTED, results, kvAuth);
        return new Result.KeysIterateResult(this.getOpCode(), results, moreElements);
    }
}

