/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.SecondaryDatabase;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import oracle.kv.FaultException;
import oracle.kv.UnauthorizedException;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiTableOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IndexRange;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.TablePrivilege;
import oracle.kv.table.Index;

public abstract class IndexOperation
extends InternalOperation
implements InternalOperation.PrivilegedTableAccessor {
    private final String indexName;
    protected final TargetTables targetTables;
    private final IndexRange range;
    private final byte[] resumeSecondaryKey;
    private final byte[] resumePrimaryKey;
    private final int batchSize;
    private String tableName;

    IndexOperation(InternalOperation.OpCode opCode, String indexName, TargetTables targetTables, IndexRange range, byte[] resumeSecondaryKey, byte[] resumePrimaryKey, int batchSize) {
        super(opCode);
        this.indexName = indexName;
        this.targetTables = targetTables;
        this.range = range;
        this.resumeSecondaryKey = resumeSecondaryKey;
        this.resumePrimaryKey = resumePrimaryKey;
        this.batchSize = batchSize;
    }

    IndexOperation(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.indexName = in.readUTF();
        this.targetTables = new TargetTables(in, serialVersion);
        this.range = new IndexRange(in, serialVersion);
        short keyLen = in.readShort();
        if (keyLen < 0) {
            this.resumeSecondaryKey = null;
            this.resumePrimaryKey = null;
        } else {
            this.resumeSecondaryKey = new byte[keyLen];
            in.readFully(this.resumeSecondaryKey);
            keyLen = in.readShort();
            this.resumePrimaryKey = new byte[keyLen];
            in.readFully(this.resumePrimaryKey);
        }
        this.batchSize = in.readInt();
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeUTF(this.indexName);
        this.targetTables.writeFastExternal(out, serialVersion);
        this.range.writeFastExternal(out, serialVersion);
        if (this.resumeSecondaryKey == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(this.resumeSecondaryKey.length);
            out.write(this.resumeSecondaryKey);
            out.writeShort(this.resumePrimaryKey.length);
            out.write(this.resumePrimaryKey);
        }
        out.writeInt(this.batchSize);
    }

    IndexRange getIndexRange() {
        return this.range;
    }

    byte[] getResumeSecondaryKey() {
        return this.resumeSecondaryKey;
    }

    byte[] getResumePrimaryKey() {
        return this.resumePrimaryKey;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    String getIndexName() {
        return this.indexName;
    }

    private String getTableName(OperationHandler operationHandler) {
        if (this.tableName == null) {
            long id = this.targetTables.getTargetTableId();
            TableImpl table = operationHandler.getRepNode().getTable(id);
            if (table == null) {
                throw new FaultException("Cannot access table.  It may not exist, id: " + id, true);
            }
            this.tableName = table.getFullName();
        }
        return this.tableName;
    }

    IndexImpl getIndex(OperationHandler operationHandler) {
        RepNode repNode = operationHandler.getRepNode();
        this.getTableName(operationHandler);
        Index index = repNode.getIndex(this.getIndexName(), this.tableName);
        if (index == null) {
            throw new FaultException("Cannot find index " + this.getIndexName() + " in table " + this.tableName, true);
        }
        return (IndexImpl)index;
    }

    SecondaryDatabase getSecondaryDatabase(OperationHandler operationHandler) {
        RepNode repNode = operationHandler.getRepNode();
        this.getTableName(operationHandler);
        SecondaryDatabase db = repNode.getIndexDB(this.getIndexName(), this.tableName);
        if (db == null) {
            throw new FaultException("Cannot find index database: " + this.getIndexName() + ", " + this.tableName, true);
        }
        return db;
    }

    OperationStatus getNextRecord(SecondaryCursor cursor, DatabaseEntry indexKeyEntry, DatabaseEntry primaryKeyEntry, DatabaseEntry dataEntry) {
        if (this.range.getExactMatch()) {
            return cursor.getNextDup(indexKeyEntry, primaryKeyEntry, dataEntry, LockMode.DEFAULT);
        }
        return cursor.getNext(indexKeyEntry, primaryKeyEntry, dataEntry, LockMode.DEFAULT);
    }

    OperationStatus getPreviousRecord(SecondaryCursor cursor, DatabaseEntry indexKeyEntry, DatabaseEntry primaryKeyEntry, DatabaseEntry dataEntry) {
        if (this.range.getExactMatch()) {
            return cursor.getPrevDup(indexKeyEntry, primaryKeyEntry, dataEntry, LockMode.DEFAULT);
        }
        return cursor.getPrev(indexKeyEntry, primaryKeyEntry, dataEntry, LockMode.DEFAULT);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    boolean inRange(byte[] checkKey) {
        return this.range.inRange(checkKey);
    }

    protected void verifyTableAccess(OperationHandler operationHandler) throws UnauthorizedException, FaultException {
        if (ExecutionContext.getCurrent() == null) {
            return;
        }
        new MultiTableOperation.TargetTableAccessChecker(operationHandler, this, this.targetTables).checkAccess();
    }

    @Override
    public List<? extends KVStorePrivilege> getRequiredPrivileges() {
        return SystemPrivilege.usrviewPrivList;
    }

    @Override
    public List<? extends KVStorePrivilege> tableAccessPrivileges(long tableId1) {
        return Collections.singletonList(new TablePrivilege.ReadTable(tableId1));
    }
}

