/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import oracle.kv.FaultException;
import oracle.kv.Key;
import oracle.kv.KeyRange;

public class KeySerializer {
    public static final String EXCEPTION_MSG = "First component of Key major path must not be empty";
    public static final KeySerializer ALLOW_INTERNAL_KEYSPACE = new KeySerializer();
    public static final KeySerializer PROHIBIT_INTERNAL_KEYSPACE = new KeySerializer(){

        @Override
        public byte[] toByteArray(Key key) {
            if (key.getMajorPath().get(0).isEmpty()) {
                throw new IllegalArgumentException("Invalid Key: " + key + ' ' + KeySerializer.EXCEPTION_MSG);
            }
            return super.toByteArray(key);
        }

        @Override
        public Key fromByteArray(byte[] bytes) {
            Key key = super.fromByteArray(bytes);
            if (key.getMajorPath().get(0).isEmpty()) {
                throw new FaultException("Internal error.  Invalid key returned: " + key + ' ' + KeySerializer.EXCEPTION_MSG, false);
            }
            return key;
        }

        @Override
        public KeyRange restrictRange(Key parentKey, KeyRange subRange) {
            if (parentKey != null) {
                return subRange;
            }
            if (subRange == null) {
                return new KeyRange("", false, null, false);
            }
            if (subRange.getStart() == null || subRange.getStart().isEmpty() && subRange.getStartInclusive()) {
                return new KeyRange("", false, subRange.getEnd(), subRange.getEndInclusive());
            }
            return subRange;
        }
    };

    private KeySerializer() {
    }

    public byte[] toByteArray(Key key) {
        return key.toByteArray();
    }

    public Key fromByteArray(byte[] bytes) {
        return Key.fromByteArray(bytes);
    }

    public KeyRange restrictRange(Key parentKey, KeyRange subRange) {
        return subRange;
    }
}

