/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.kv.hadoop.hive.table.TableFieldTypeEnum;
import oracle.kv.hadoop.hive.table.TableSerDeBase;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.MapDef;
import oracle.kv.table.RecordDef;
import oracle.kv.table.Row;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class TableSerDe
extends TableSerDeBase {
    private static final String thisClassName = TableSerDe.class.getName();
    private static final Log LOG = LogFactory.getLog(thisClassName);

    @Override
    protected void validateParams(Properties tbl) throws SerDeException {
        LOG.debug("KV Store Table Name = " + this.getKvTableName());
        List<String> fieldNames = this.getKvFieldNames();
        if (fieldNames == null || fieldNames.size() == 0) {
            String msg = "No fields defined in KV Store table [name=" + this.getKvTableName() + "]";
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
        LOG.debug("KV Store Field Names = " + fieldNames);
        List<FieldDef.Type> fieldTypes = this.getKvFieldTypes();
        if (fieldTypes == null || fieldTypes.size() == 0) {
            String msg = "No types defined for fields in KV Store table [name=" + this.getKvTableName() + ", fields=" + fieldNames + "]";
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
        LOG.debug("KV Store Field Types = " + fieldTypes);
        LOG.debug("HIVE Table Name = " + this.getHiveTableName());
        LazySimpleSerDe.SerDeParameters params = this.getSerdeParams();
        if (params == null) {
            String msg = "No SerDeParameters specified for Hive table [name=" + this.getHiveTableName() + "]";
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
        List columnNames = params.getColumnNames();
        if (columnNames == null || columnNames.size() == 0) {
            String msg = "No columns defined in Hive table [name=" + this.getHiveTableName() + "]";
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
        LOG.debug("HIVE Column Names = " + columnNames);
        List columnTypes = params.getColumnTypes();
        if (columnTypes == null || columnTypes.size() == 0) {
            String msg = "No types defined for columns in Hive table [name=" + this.getHiveTableName() + ", columns=" + columnNames + "]";
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
        LOG.debug("HIVE Column Types = " + columnTypes);
        if (fieldNames.size() != fieldTypes.size()) {
            String msg = "For the KV Store table [name=" + this.getKvTableName() + "], " + "the number of field names [" + fieldNames.size() + "] != number of field types [" + fieldTypes.size() + "]";
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
        if (columnNames.size() != columnTypes.size()) {
            String msg = "For the created Hive table [name=" + this.getHiveTableName() + "], the number of column names [" + columnNames.size() + "] != number of column types [" + columnTypes.size() + "]";
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
        if (fieldNames.size() != columnNames.size()) {
            String msg = "Number of fields [" + fieldNames.size() + "] in the " + "KV Store table [name=" + this.getKvTableName() + "] != " + "number of columns [" + columnNames.size() + "] specified for the created Hive table [name=" + this.getHiveTableName() + "]";
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
        for (String fieldName : fieldNames) {
            if (columnNames.contains(fieldName.toLowerCase())) continue;
            String msg = "Field names from the KV Store table [name=" + this.getKvTableName() + "] does not match the column names " + "from the created Hive table [name=" + this.getHiveTableName() + "] - " + fieldNames + " != " + columnNames;
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
        for (int i = 0; i < fieldTypes.size(); ++i) {
            if (TableFieldTypeEnum.fromKvType(fieldTypes.get(i)).equals((Object)TableFieldTypeEnum.fromHiveType((TypeInfo)columnTypes.get(i)))) continue;
            String msg = "Field types from the KV Store table [name=" + this.getKvTableName() + "] does not match the column types " + "from the created Hive table [name=" + this.getHiveTableName() + "] - " + fieldTypes + " != " + columnTypes;
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
    }

    @Override
    protected ObjectInspector createObjectInspector() throws SerDeException {
        ArrayList<ObjectInspector> fieldObjInspectors = new ArrayList<ObjectInspector>();
        List hiveColumnNames = this.getSerdeParams().getColumnNames();
        List<FieldDef> fieldDefs = this.getKvFieldDefs();
        for (FieldDef fieldDef : fieldDefs) {
            fieldObjInspectors.add(this.doCreateObjectInspector(fieldDef));
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector((List)hiveColumnNames, fieldObjInspectors);
    }

    @Override
    public Object deserialize(Writable field) throws SerDeException {
        this.hiveRow.clear();
        Row kvRow = this.getKvTable().createRowFromJson(field.toString(), true);
        block13: for (String fieldName : kvRow.getFields()) {
            FieldValue fieldValue = kvRow.get(fieldName);
            TableFieldTypeEnum fieldTypeEnum = fieldValue.isNull() ? TableFieldTypeEnum.TABLE_FIELD_NULL : TableFieldTypeEnum.fromKvType(fieldValue.getType());
            switch (fieldTypeEnum) {
                case TABLE_FIELD_STRING: {
                    this.hiveRow.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector.getPrimitiveJavaObject((Object)fieldValue));
                    continue block13;
                }
                case TABLE_FIELD_BOOLEAN: {
                    this.hiveRow.add(TableFieldTypeEnum.tableBooleanObjectInspector.get(fieldValue));
                    continue block13;
                }
                case TABLE_FIELD_INTEGER: {
                    this.hiveRow.add(TableFieldTypeEnum.tableIntObjectInspector.get(fieldValue));
                    continue block13;
                }
                case TABLE_FIELD_LONG: {
                    this.hiveRow.add(TableFieldTypeEnum.tableLongObjectInspector.get(fieldValue));
                    continue block13;
                }
                case TABLE_FIELD_FLOAT: {
                    this.hiveRow.add(Float.valueOf(TableFieldTypeEnum.tableFloatObjectInspector.get(fieldValue)));
                    continue block13;
                }
                case TABLE_FIELD_DOUBLE: {
                    this.hiveRow.add(TableFieldTypeEnum.tableDoubleObjectInspector.get(fieldValue));
                    continue block13;
                }
                case TABLE_FIELD_ENUM: {
                    this.hiveRow.add(TableFieldTypeEnum.tableEnumObjectInspector.getPrimitiveJavaObject(fieldValue));
                    continue block13;
                }
                case TABLE_FIELD_BINARY: 
                case TABLE_FIELD_FIXED_BINARY: {
                    this.hiveRow.add(TableFieldTypeEnum.tableBinaryObjectInspector.getPrimitiveJavaObject(fieldValue));
                    continue block13;
                }
                case TABLE_FIELD_MAP: 
                case TABLE_FIELD_RECORD: {
                    this.hiveRow.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector.getPrimitiveJavaObject((Object)fieldValue));
                    continue block13;
                }
                case TABLE_FIELD_ARRAY: {
                    this.hiveRow.add(PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector.getPrimitiveJavaObject((Object)fieldValue));
                    continue block13;
                }
                case TABLE_FIELD_NULL: {
                    this.hiveRow.add(null);
                    continue block13;
                }
            }
            this.hiveRow.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector.getPrimitiveJavaObject((Object)fieldValue));
        }
        return this.hiveRow;
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objectInspector) throws SerDeException {
        StructObjectInspector structInspector = (StructObjectInspector)objectInspector;
        List structFields = structInspector.getAllStructFieldRefs();
        List hiveColumnNames = this.getSerdeParams().getColumnNames();
        if (structFields.size() != hiveColumnNames.size()) {
            String msg = "Number of Hive columns to serialize " + structFields.size() + "] does not equal number of columns [" + hiveColumnNames.size() + "] specified in the created Hive " + "table [name=" + this.getHiveTableName() + "]";
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
        this.kvMapWritable.clear();
        for (int i = 0; i < structFields.size(); ++i) {
            Object fieldData;
            StructField structField = (StructField)structFields.get(i);
            String hiveColumnName = (String)hiveColumnNames.get(i);
            if (structField == null) continue;
            AbstractPrimitiveObjectInspector fieldObjInspector = (AbstractPrimitiveObjectInspector)structField.getFieldObjectInspector();
            Object fieldValue = (Writable)fieldObjInspector.getPrimitiveWritableObject(fieldData = structInspector.getStructFieldData(obj, structField));
            if (fieldValue == null) {
                fieldValue = PrimitiveObjectInspector.PrimitiveCategory.STRING.equals((Object)fieldObjInspector.getPrimitiveCategory()) ? NullWritable.get() : new IntWritable(0);
            }
            this.kvMapWritable.put((Writable)new Text(hiveColumnName), fieldValue);
        }
        return this.kvMapWritable;
    }

    private ObjectInspector doCreateObjectInspector(FieldDef fieldDef) {
        TableFieldTypeEnum type = TableFieldTypeEnum.fromKvType(fieldDef.getType());
        switch (type) {
            case TABLE_FIELD_MAP: {
                return this.doCreateMapObjectInspector(fieldDef);
            }
            case TABLE_FIELD_RECORD: {
                break;
            }
            case TABLE_FIELD_ARRAY: {
                return this.doCreateArrayObjectInspector();
            }
            default: {
                return type.getObjectInspector();
            }
        }
        return type.getObjectInspector();
    }

    private ObjectInspector doCreateMapObjectInspector(FieldDef fieldDef) {
        FieldDef elementDef = ((MapDef)fieldDef).getElement();
        TableFieldTypeEnum elementType = TableFieldTypeEnum.fromKvType(elementDef.getType());
        return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)elementType.getObjectInspector());
    }

    private ObjectInspector doCreateRecordObjectInspector(FieldDef tableFieldDef) throws SerDeException {
        List<String> recFieldNames = ((RecordDef)tableFieldDef).getFields();
        ArrayList<ObjectInspector> recObjInspectors = new ArrayList<ObjectInspector>();
        for (String recFieldName : recFieldNames) {
            FieldDef recFieldDef = ((RecordDef)tableFieldDef).getField(recFieldName);
            TableFieldTypeEnum recFieldType = TableFieldTypeEnum.fromKvType(recFieldDef.getType());
            recObjInspectors.add(recFieldType.getObjectInspector());
        }
        return ObjectInspectorFactory.getStandardUnionObjectInspector(recObjInspectors);
    }

    private ObjectInspector doCreateArrayObjectInspector() {
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
    }
}

