/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import oracle.kv.hadoop.hive.table.TableBinaryObjectInspector;
import oracle.kv.hadoop.hive.table.TableBooleanObjectInspector;
import oracle.kv.hadoop.hive.table.TableDoubleObjectInspector;
import oracle.kv.hadoop.hive.table.TableEnumObjectInspector;
import oracle.kv.hadoop.hive.table.TableFloatObjectInspector;
import oracle.kv.hadoop.hive.table.TableIntObjectInspector;
import oracle.kv.hadoop.hive.table.TableLongObjectInspector;
import oracle.kv.table.FieldDef;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public enum TableFieldTypeEnum {
    TABLE_FIELD_STRING{

        @Override
        public ObjectInspector getObjectInspector() {
            return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        }

        public String toString() {
            return FieldDef.Type.STRING.toString();
        }
    }
    ,
    TABLE_FIELD_BOOLEAN{

        @Override
        public ObjectInspector getObjectInspector() {
            return tableBooleanObjectInspector;
        }

        public String toString() {
            return FieldDef.Type.BOOLEAN.toString();
        }
    }
    ,
    TABLE_FIELD_INTEGER{

        @Override
        public ObjectInspector getObjectInspector() {
            return tableIntObjectInspector;
        }

        public String toString() {
            return FieldDef.Type.INTEGER.toString();
        }
    }
    ,
    TABLE_FIELD_LONG{

        @Override
        public ObjectInspector getObjectInspector() {
            return tableLongObjectInspector;
        }

        public String toString() {
            return FieldDef.Type.LONG.toString();
        }
    }
    ,
    TABLE_FIELD_FLOAT{

        @Override
        public ObjectInspector getObjectInspector() {
            return tableFloatObjectInspector;
        }

        public String toString() {
            return FieldDef.Type.FLOAT.toString();
        }
    }
    ,
    TABLE_FIELD_DOUBLE{

        @Override
        public ObjectInspector getObjectInspector() {
            return tableDoubleObjectInspector;
        }

        public String toString() {
            return FieldDef.Type.DOUBLE.toString();
        }
    }
    ,
    TABLE_FIELD_ENUM{

        @Override
        public ObjectInspector getObjectInspector() {
            return tableEnumObjectInspector;
        }

        public String toString() {
            return FieldDef.Type.ENUM.toString();
        }
    }
    ,
    TABLE_FIELD_BINARY{

        @Override
        public ObjectInspector getObjectInspector() {
            return tableBinaryObjectInspector;
        }

        public String toString() {
            return FieldDef.Type.BINARY.toString();
        }
    }
    ,
    TABLE_FIELD_FIXED_BINARY{

        @Override
        public ObjectInspector getObjectInspector() {
            return tableBinaryObjectInspector;
        }

        public String toString() {
            return FieldDef.Type.FIXED_BINARY.toString();
        }
    }
    ,
    TABLE_FIELD_MAP{

        @Override
        public ObjectInspector getObjectInspector() {
            return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        }

        public String toString() {
            return FieldDef.Type.MAP.toString();
        }
    }
    ,
    TABLE_FIELD_RECORD{

        @Override
        public ObjectInspector getObjectInspector() {
            return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        }

        public String toString() {
            return FieldDef.Type.RECORD.toString();
        }
    }
    ,
    TABLE_FIELD_ARRAY{

        @Override
        public ObjectInspector getObjectInspector() {
            return PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
        }

        public String toString() {
            return FieldDef.Type.ARRAY.toString();
        }
    }
    ,
    TABLE_FIELD_NULL{

        @Override
        public ObjectInspector getObjectInspector() {
            return null;
        }

        public String toString() {
            return "NULL kv table field";
        }
    }
    ,
    TABLE_FIELD_UNKNOWN_TYPE{

        @Override
        public ObjectInspector getObjectInspector() {
            return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        }

        public String toString() {
            return "unknown kv table field type";
        }
    };

    public static final TableBooleanObjectInspector tableBooleanObjectInspector;
    public static final TableIntObjectInspector tableIntObjectInspector;
    public static final TableLongObjectInspector tableLongObjectInspector;
    public static final TableFloatObjectInspector tableFloatObjectInspector;
    public static final TableDoubleObjectInspector tableDoubleObjectInspector;
    public static final TableEnumObjectInspector tableEnumObjectInspector;
    public static final TableBinaryObjectInspector tableBinaryObjectInspector;

    abstract ObjectInspector getObjectInspector();

    public static TableFieldTypeEnum fromKvType(FieldDef.Type kvType) {
        return TableFieldTypeEnum.stringToEnumValue(kvType.toString());
    }

    public static TableFieldTypeEnum fromHiveType(TypeInfo hiveType) {
        if ("boolean".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_BOOLEAN;
        }
        if ("int".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_INTEGER;
        }
        if ("bigint".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_LONG;
        }
        if ("float".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_FLOAT;
        }
        if ("decimal".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_FLOAT;
        }
        if ("double".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_DOUBLE;
        }
        if ("string".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_STRING;
        }
        if ("binary".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_BINARY;
        }
        if ("map".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_MAP;
        }
        if ("array".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_ARRAY;
        }
        if ("struct".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_RECORD;
        }
        if ("tinyint".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_UNKNOWN_TYPE;
        }
        if ("smallint".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_UNKNOWN_TYPE;
        }
        if ("date".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_UNKNOWN_TYPE;
        }
        if ("datetime".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_UNKNOWN_TYPE;
        }
        if ("timestamp".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_UNKNOWN_TYPE;
        }
        if ("uniontype".equals(hiveType.getTypeName())) {
            return TABLE_FIELD_UNKNOWN_TYPE;
        }
        return TABLE_FIELD_UNKNOWN_TYPE;
    }

    public static TableFieldTypeEnum stringToEnumValue(String str) {
        for (TableFieldTypeEnum enumVal : TableFieldTypeEnum.values()) {
            if (!enumVal.toString().equals(str)) continue;
            return enumVal;
        }
        String msg = "no enum value " + TableFieldTypeEnum.class + "." + str;
        throw new IllegalArgumentException(msg);
    }

    static {
        tableBooleanObjectInspector = new TableBooleanObjectInspector();
        tableIntObjectInspector = new TableIntObjectInspector();
        tableLongObjectInspector = new TableLongObjectInspector();
        tableFloatObjectInspector = new TableFloatObjectInspector();
        tableDoubleObjectInspector = new TableDoubleObjectInspector();
        tableEnumObjectInspector = new TableEnumObjectInspector();
        tableBinaryObjectInspector = new TableBinaryObjectInspector();
    }
}

