/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import oracle.kv.hadoop.hive.table.TableFieldTypeEnum;
import oracle.kv.table.FieldValue;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableStringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;

public class TableEnumObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableStringObjectInspector {
    TableEnumObjectInspector() {
        super(TypeInfoFactory.stringTypeInfo);
    }

    public Text getPrimitiveWritableObject(Object o) {
        return o == null ? new Text(TableFieldTypeEnum.TABLE_FIELD_UNKNOWN_TYPE.toString()) : new Text(((FieldValue)o).asEnum().get());
    }

    public String getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return TableFieldTypeEnum.TABLE_FIELD_UNKNOWN_TYPE.toString();
        }
        if (o instanceof Enum) {
            return ((Enum)o).toString();
        }
        if (o instanceof FieldValue) {
            return ((FieldValue)o).asEnum().get();
        }
        throw new IllegalArgumentException("object is not of type Enum or type FieldValue");
    }

    public Object create(Text value) {
        return value == null ? TableFieldTypeEnum.TABLE_FIELD_UNKNOWN_TYPE : TableFieldTypeEnum.stringToEnumValue(value.toString());
    }

    public Object set(Object o, Text value) {
        return value == null ? TableFieldTypeEnum.TABLE_FIELD_UNKNOWN_TYPE : TableFieldTypeEnum.stringToEnumValue(value.toString());
    }

    public Object create(String value) {
        return value == null ? TableFieldTypeEnum.TABLE_FIELD_UNKNOWN_TYPE : TableFieldTypeEnum.stringToEnumValue(value);
    }

    public Object set(Object o, String value) {
        return value == null ? TableFieldTypeEnum.TABLE_FIELD_UNKNOWN_TYPE : TableFieldTypeEnum.stringToEnumValue(value);
    }
}

