/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.utilint;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class ActivityCounter {
    private final AtomicInteger activeCount = new AtomicInteger(0);
    private final AtomicBoolean threadDumpInProgress = new AtomicBoolean(false);
    private volatile long lastThreadDumpTime;
    private volatile int numCompletedDumps;
    private final int activeThreshold;
    private final int maxNumDumps;
    private final AtomicInteger maxActivity = new AtomicInteger(0);
    private final long requiredIntervalMillis;
    private final Logger logger;
    private final ExecutorService dumper;

    public ActivityCounter(int activeThreshold, long requiredIntervalMillis, int maxNumDumps, Logger logger) {
        this.activeThreshold = activeThreshold;
        this.requiredIntervalMillis = requiredIntervalMillis;
        this.maxNumDumps = maxNumDumps;
        this.logger = logger;
        this.dumper = Executors.newSingleThreadExecutor();
    }

    public void start() {
        int max;
        int numActive = this.activeCount.incrementAndGet();
        if (numActive > (max = this.maxActivity.get())) {
            this.maxActivity.compareAndSet(max, numActive);
        }
        this.check(numActive);
    }

    public void finish() {
        this.activeCount.decrementAndGet();
    }

    public int getAndClearMaxActivity() {
        return this.maxActivity.getAndSet(0);
    }

    private boolean intervalIsTooShort() {
        long interval = System.currentTimeMillis() - this.lastThreadDumpTime;
        return interval < this.requiredIntervalMillis;
    }

    private void check(int numActive) {
        if (numActive <= this.activeThreshold) {
            return;
        }
        if (this.numCompletedDumps >= this.maxNumDumps) {
            return;
        }
        if (this.intervalIsTooShort()) {
            return;
        }
        if (this.threadDumpInProgress.get()) {
            return;
        }
        this.dumper.execute(new GetStackTraces());
    }

    public int getNumCompletedDumps() {
        return this.numCompletedDumps;
    }

    private class GetStackTraces
    implements Runnable {
        private GetStackTraces() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (ActivityCounter.this.intervalIsTooShort()) {
                return;
            }
            if (!ActivityCounter.this.threadDumpInProgress.compareAndSet(false, true)) {
                ActivityCounter.this.logger.warning("Unexpected: ActivityCounter stack trace dumper saw threadDumpInProgress flag set.");
                return;
            }
            try {
                ActivityCounter.this.lastThreadDumpTime = System.currentTimeMillis();
                this.dumpThreads();
                ActivityCounter.this.numCompletedDumps++;
            }
            finally {
                boolean reset = ActivityCounter.this.threadDumpInProgress.compareAndSet(true, false);
                assert (reset) : "ThreadDump should have been in progress";
            }
        }

        private void dumpThreads() {
            int whichDump = ActivityCounter.this.numCompletedDumps;
            ActivityCounter.this.logger.info("[Dump " + whichDump + " --Dumping stack traces for all threads]");
            Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> stme : stackTraces.entrySet()) {
                if (stme.getKey() == Thread.currentThread()) continue;
                ActivityCounter.this.logger.info(stme.getKey().toString());
                for (StackTraceElement ste : stme.getValue()) {
                    ActivityCounter.this.logger.info("     " + ste);
                }
            }
            ActivityCounter.this.logger.info("[Dump " + whichDump + " --Thread dump completed]");
        }
    }
}

