/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.BlockCipher;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.core.Cipher;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.MAC;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.PBE;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.core.Padding;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.core.RC2AlgorithmIdentifier;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.c;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public final class PKCS5PBE
extends PBE {
    private static final long d = 0x100000001L;
    public static final int MD2_DES = 1;
    public static final int MD2_RC2 = 4;
    public static final int MD5_DES = 3;
    public static final int MD5_RC2 = 6;
    public static final int SHA1_DES = 10;
    public static final int SHA1_RC2 = 11;
    private int e;

    public void initialize(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier instanceof PBEAlgorithmIdentifier) {
            this.a = (PBEAlgorithmIdentifier)algorithmIdentifier;
        } else {
            try {
                this.a = new PBEAlgorithmIdentifier(Utils.toStream(algorithmIdentifier));
            }
            catch (IOException iOException) {
                throw new AlgorithmIdentifierException(iOException.toString());
            }
        }
        ASN1ObjectID aSN1ObjectID = this.a.getOID();
        if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC)) {
            this.b = AlgID.md2;
            this.c = AlgID.desCBC;
            this.e = 1;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithMD2AndRC2_CBC)) {
            this.b = AlgID.md2;
            this.c = AlgID.RC2_CBC;
            this.e = 1;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC)) {
            this.b = AlgID.md5;
            this.c = AlgID.desCBC;
            this.e = 1;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithMD5AndRC2_CBC)) {
            this.b = AlgID.md5;
            this.c = AlgID.RC2_CBC;
            this.e = 1;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHA1AndDES_CBC)) {
            this.b = AlgID.sha_1;
            this.c = AlgID.desCBC;
            this.e = 1;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHA1AndRC2_CBC)) {
            this.b = AlgID.sha_1;
            this.c = AlgID.RC2_CBC;
            this.e = 1;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.id_PBES2)) {
            if (this.a.getPseudorandomFunc().getOID().equals(AlgID.hmacWithSHA1.getOID()) || this.a.getPseudorandomFunc().getOID().equals(AlgID.hmacSHA.getOID())) {
                this.b = AlgID.sha_1;
            } else if (this.a.getPseudorandomFunc().getOID().equals(AlgID.hmacMD5.getOID())) {
                this.b = AlgID.md5;
            } else {
                throw new AlgorithmIdentifierException("Unknown key derivation algorithm identifier");
            }
            this.c = this.a.getEncryptionScheme();
            this.e = 2;
        } else {
            throw new AlgorithmIdentifierException("Unknown algorithm identifier: " + algorithmIdentifier);
        }
    }

    public void initialize(int n, byte[] byArray, int n2) throws AlgorithmIdentifierException {
        this.initialize(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs5, n), byArray, n2));
    }

    public void initialize(int n) throws AlgorithmIdentifierException {
        this.initialize(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs5, n)));
    }

    public byte[] encrypt(String string, byte[] byArray) throws CipherException {
        byte[] byArray2;
        FIPS_140_2.assertReadyState();
        try {
            byArray2 = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray2 = string.getBytes();
        }
        byte[] byArray3 = this.e == 1 ? this.a(byArray2, byArray, true) : this.b(byArray2, byArray, true);
        Utils.setArray(byArray2, (byte)0);
        return byArray3;
    }

    public byte[] decrypt(String string, byte[] byArray) throws CipherException {
        byte[] byArray2;
        byte[] byArray3;
        FIPS_140_2.assertReadyState();
        boolean bl = false;
        try {
            byArray3 = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray3 = string.getBytes();
            bl = true;
        }
        try {
            byArray2 = this.e == 1 ? this.a(byArray3, byArray, false) : this.b(byArray3, byArray, false);
        }
        catch (Exception exception) {
            if (!bl) {
                Utils.setArray(byArray3, (byte)0);
                byArray3 = string.getBytes();
                byArray2 = this.e == 1 ? this.a(byArray3, byArray, false) : this.b(byArray3, byArray, false);
            }
            if (exception instanceof CipherException) {
                throw (CipherException)exception;
            }
            throw new CipherException(exception.toString());
        }
        Utils.setArray(byArray3, (byte)0);
        return byArray2;
    }

    public byte[] encryptPrivateKey(String string, PrivateKey privateKey) throws CipherException {
        if (privateKey instanceof PrivateKeyPKCS8) {
            throw new CipherException("Cannot encrypt encrypted key");
        }
        return this.encrypt(string, oracle.security.crypto.core.c.a(privateKey));
    }

    public PrivateKey decryptPrivateKey(String string, byte[] byArray) throws CipherException, IOException {
        PrivateKey privateKey;
        byte[] byArray2 = null;
        try {
            byArray2 = this.decrypt(string, byArray);
            privateKey = CryptoUtils.inputPrivateKey(new UnsyncByteArrayInputStream(byArray2));
        }
        catch (Exception exception) {
            if (byArray2 != null) {
                Utils.setArray(byArray2, (byte)0);
            }
            byte[] byArray3 = string.getBytes();
            byArray2 = this.e == 1 ? this.a(byArray3, byArray, false) : this.b(byArray3, byArray, false);
            Utils.setArray(byArray3, (byte)0);
            privateKey = CryptoUtils.inputPrivateKey(new UnsyncByteArrayInputStream(byArray2));
        }
        Utils.setArray(byArray2, (byte)0);
        return privateKey;
    }

    public byte[] encryptSymmetricKey(String string, SymmetricKey symmetricKey) throws CipherException {
        return this.encrypt(string, symmetricKey.e());
    }

    public SymmetricKey decryptSymmetricKey(String string, byte[] byArray) throws CipherException {
        byte[] byArray2 = this.decrypt(string, byArray);
        SymmetricKey symmetricKey = new SymmetricKey(byArray2);
        Utils.setArray(byArray2, (byte)0);
        return symmetricKey;
    }

    private byte[] a(byte[] byArray, byte[] byArray2, boolean bl) throws CipherException {
        byte[] byArray3;
        SymmetricKey symmetricKey = this.a(byArray);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(symmetricKey.getAlgID(), symmetricKey, Padding.PKCS5);
            byArray3 = bl ? ((BlockCipher)cipher).encrypt(byArray2, 0, byArray2.length, true) : ((BlockCipher)cipher).decrypt(byArray2, 0, byArray2.length, true);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
        finally {
            if (cipher != null) {
                cipher.erase();
            }
            if (symmetricKey != null) {
                symmetricKey.erase();
            }
        }
        return byArray3;
    }

    private byte[] b(byte[] byArray, byte[] byArray2, boolean bl) throws CipherException {
        byte[] byArray3;
        SymmetricKey symmetricKey = this.b(byArray);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.c, symmetricKey, Padding.PKCS5);
            byArray3 = bl ? ((BlockCipher)cipher).encrypt(byArray2, 0, byArray2.length, true) : ((BlockCipher)cipher).decrypt(byArray2, 0, byArray2.length, true);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
        finally {
            if (cipher != null) {
                cipher.erase();
            }
            if (symmetricKey != null) {
                symmetricKey.erase();
            }
        }
        return byArray3;
    }

    private SymmetricKey a(byte[] byArray) throws CipherException {
        try {
            byte[] byArray2 = PKCS5PBE.a(this.b, byArray, this.a.getSalt(), this.a.getIterationCount(), 16);
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray2, 0, byArray3, 0, 8);
            byte[] byArray4 = new byte[8];
            System.arraycopy(byArray2, 8, byArray4, 0, 8);
            Utils.setArray(byArray2, (byte)0);
            AlgorithmIdentifier algorithmIdentifier = this.c.getOID().equals(AlgID.RC2_CBC.getOID()) ? new RC2AlgorithmIdentifier(byArray4, 64) : (!this.c.getOID().equals(AlgID.RC4.getOID()) ? new CBCAlgorithmIdentifier(this.c.getOID(), byArray4) : AlgID.RC4);
            SymmetricKey symmetricKey = new SymmetricKey(byArray3, algorithmIdentifier);
            Utils.setArray(byArray3, (byte)0);
            return symmetricKey;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
    }

    private SymmetricKey b(byte[] byArray) throws CipherException {
        try {
            byte[] byArray2 = PKCS5PBE.b(this.b, byArray, this.a.getSalt(), this.a.getIterationCount(), this.a.getKeyLength());
            SymmetricKey symmetricKey = new SymmetricKey(byArray2, this.c);
            Utils.setArray(byArray2, (byte)0);
            return symmetricKey;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
    }

    private static byte[] a(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, int n, int n2) throws InvalidKeyException {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(algorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidKeyException(algorithmIdentifierException.toString());
        }
        if (n2 > messageDigest.getDigestLength()) {
            throw new InvalidKeyException("Derived key too long");
        }
        messageDigest.init();
        messageDigest.update(byArray);
        messageDigest.update(byArray2);
        messageDigest.computeCurrent();
        byte[] byArray3 = messageDigest.a();
        for (int i2 = 1; i2 < n; ++i2) {
            messageDigest.init();
            messageDigest.update(byArray3);
            messageDigest.computeCurrent();
            byArray3 = messageDigest.a();
        }
        if (byArray3.length == n2) {
            return byArray3;
        }
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray3, 0, byArray4, 0, n2);
        Utils.setArray(byArray3, (byte)0);
        return byArray4;
    }

    private static byte[] b(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, int n, int n2) throws InvalidKeyException {
        byte[] byArray3;
        MAC mAC;
        SymmetricKey symmetricKey = new SymmetricKey(byArray);
        try {
            mAC = MAC.getInstance(algorithmIdentifier, symmetricKey);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidKeyException(algorithmIdentifierException.toString());
        }
        finally {
            if (symmetricKey != null) {
                symmetricKey.erase();
            }
        }
        int n3 = mAC.getDigestLength();
        if (((long)n2 & 0xFFFFL) > 0x100000001L * (long)n3) {
            throw new InvalidKeyException("Derived key too long");
        }
        int n4 = n2 / n3;
        byte[] byArray4 = new byte[n2];
        for (int i2 = 1; i2 < n4 + 1; ++i2) {
            byArray3 = PKCS5PBE.a(mAC, byArray2, n, i2);
            System.arraycopy(byArray3, 0, byArray4, (i2 - 1) * n3, n3);
            Utils.setArray(byArray3, (byte)0);
        }
        if (n2 > n4 * n3) {
            byArray3 = PKCS5PBE.a(mAC, byArray2, n, n4 + 1);
            System.arraycopy(byArray3, 0, byArray4, n4 * n3, n2 - n4 * n3);
            Utils.setArray(byArray3, (byte)0);
        }
        mAC.erase();
        return byArray4;
    }

    private static byte[] a(MAC mAC, byte[] byArray, int n, int n2) {
        byte[] byArray2;
        mAC.init();
        mAC.update(byArray);
        mAC.update(Utils.wordToBytes(n2));
        mAC.computeCurrent();
        byte[] byArray3 = byArray2 = mAC.getDigestBits();
        for (int i2 = 1; i2 < n; ++i2) {
            mAC.init();
            mAC.update(byArray3);
            mAC.computeCurrent();
            byArray3 = mAC.getDigestBits();
            for (int i3 = 0; i3 < byArray2.length; ++i3) {
                byArray2[i3] = (byte)((byArray2[i3] & 0xFF ^ byArray3[i3] & 0xFF) & 0xFF);
            }
            Utils.setArray(byArray3, (byte)0);
            Utils.setArray(mAC.a(), (byte)0);
        }
        return byArray2;
    }
}

