/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.ObjectOutputStream;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.BlockCipher;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.Padding;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.k;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.Utils;

public final class AES
extends BlockCipher {
    private AlgorithmIdentifier g = null;
    private int h;
    private int i;
    private int j;
    private int[] k;
    private int[] l;
    private byte[] m;
    private byte[] n;
    private int o;
    private int p;
    private int q;
    private int r;
    private int s;
    private int t;
    private int u;
    private int v;
    private int w;
    private int x;
    private int y;
    private int z;
    private int A;
    private int B;
    private int C;
    private int D;
    private int[] E;
    private int[] F;
    private static int[][] G = new int[256][8];
    private static final int[] H = new int[30];
    private static final int[] I = new int[256];
    private static final int[] J = new int[256];
    private static final int[] K = new int[256];
    private static final int[] L = new int[256];
    private static final int[] M = new int[256];
    private static final int[] N = new int[256];
    private static final int[] O = new int[256];
    private static final int[] P = new int[256];
    private static final int[] Q = new int[256];
    private static final int[] R = new int[256];
    private static final int[] S = new int[256];
    private static final int[] T = new int[256];
    private static final int[] U = new int[256];
    private static final int[] V = new int[256];
    private ObjectOutputStream W = null;

    private static void h() {
        AES.i();
        AES.j();
        AES.k();
        AES.l();
        AES.m();
        AES.n();
    }

    private static void i() {
        for (int i2 = 0; i2 < 256; ++i2) {
            AES.G[i2][0] = i2;
            for (int i3 = 1; i3 < 8; ++i3) {
                int n = G[i2][i3 - 1];
                AES.G[i2][i3] = (n >> 7 & 1) == 0 ? n << 1 : (n << 1 ^ 0x1B) & 0xFF;
            }
        }
    }

    private static void j() {
        int n = 1;
        for (int i2 = 2; i2 <= 30; ++i2) {
            AES.H[i2 - 1] = Utils.bytesToWord((byte)n, 0, 0, 0);
            n = AES.b(2, n & 0xFF);
        }
    }

    private static void k() {
        for (int i2 = 0; i2 < 256; ++i2) {
            int n = AES.b(i2);
            AES.I[i2] = (n & 1) * 31 ^ (n >> 1 & 1) * 62 ^ (n >> 2 & 1) * 124 ^ (n >> 3 & 1) * 248 ^ (n >> 4 & 1) * 241 ^ (n >> 5 & 1) * 227 ^ (n >> 6 & 1) * 199 ^ (n >> 7 & 1) * 143 ^ 0x63;
            AES.J[AES.I[i2]] = i2;
        }
    }

    private static void l() {
        for (int i2 = 0; i2 < 256; ++i2) {
            byte by = (byte)I[i2];
            byte by2 = (byte)AES.b(I[i2], 2);
            byte by3 = (byte)AES.b(I[i2], 3);
            AES.K[i2] = Utils.bytesToWord(by2, by, by, by3);
            AES.L[i2] = Utils.bytesToWord(by3, by2, by, by);
            AES.M[i2] = Utils.bytesToWord(by, by3, by2, by);
            AES.N[i2] = Utils.bytesToWord(by, by, by3, by2);
        }
    }

    private static void m() {
        for (int i2 = 0; i2 < 256; ++i2) {
            byte by = (byte)AES.b(J[i2], 14);
            byte by2 = (byte)AES.b(J[i2], 9);
            byte by3 = (byte)AES.b(J[i2], 13);
            byte by4 = (byte)AES.b(J[i2], 11);
            AES.O[i2] = Utils.bytesToWord(by, by2, by3, by4);
            AES.P[i2] = Utils.bytesToWord(by4, by, by2, by3);
            AES.Q[i2] = Utils.bytesToWord(by3, by4, by, by2);
            AES.R[i2] = Utils.bytesToWord(by2, by3, by4, by);
        }
    }

    private static void n() {
        for (int i2 = 0; i2 < 256; ++i2) {
            byte by = (byte)AES.b(i2, 14);
            byte by2 = (byte)AES.b(i2, 9);
            byte by3 = (byte)AES.b(i2, 13);
            byte by4 = (byte)AES.b(i2, 11);
            AES.S[i2] = Utils.bytesToWord(by, by2, by3, by4);
            AES.T[i2] = Utils.bytesToWord(by4, by, by2, by3);
            AES.U[i2] = Utils.bytesToWord(by3, by4, by, by2);
            AES.V[i2] = Utils.bytesToWord(by2, by3, by4, by);
        }
    }

    public AES() {
        this.d = 0;
        this.a(4, 4);
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        FIPS_140_2.assertReadyState();
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        oracle.security.crypto.core.k.a(symmetricKey, 256);
        if (iD == null) {
            throw new CipherException("The paddingID parameter cannot be null");
        }
        this.a(algorithmIdentifier, symmetricKey);
        this.f = randomBitsSource;
        this.a = null;
        this.a(algorithmIdentifier);
        this.e = symmetricKey;
        this.a((SymmetricKey)this.e);
        this.c();
        this.c = iD;
    }

    private void a(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey) throws InvalidKeyException {
        byte[] byArray = symmetricKey.d();
        if (algorithmIdentifier.getOID().equals(AlgID.aes128_ECB.getOID()) && byArray.length == 16 || algorithmIdentifier.getOID().equals(AlgID.aes128_CBC.getOID()) && byArray.length == 16 || algorithmIdentifier.getOID().equals(AlgID.aes192_ECB.getOID()) && byArray.length == 24 || algorithmIdentifier.getOID().equals(AlgID.aes192_CBC.getOID()) && byArray.length == 24 || algorithmIdentifier.getOID().equals(AlgID.aes256_ECB.getOID()) && byArray.length == 32 || algorithmIdentifier.getOID().equals(AlgID.aes256_CBC.getOID()) && byArray.length == 32) {
            return;
        }
        throw new InvalidKeyException("Key size did not match size specified in the AlgorithmIdentifier");
    }

    private void a(int n, int n2) {
        if (n != 4 && n != 6 && n != 8) {
            throw new IllegalArgumentException("invalid Nb value " + n);
        }
        if (n2 != 4 && n2 != 6 && n2 != 8) {
            throw new IllegalArgumentException("invalid Nk value " + n2);
        }
        this.h = n;
        this.b = 4 * n;
        this.i = n2;
        int n3 = n == 8 || n2 == 8 ? 14 : (this.j = n == 4 && n2 == 4 ? 10 : 12);
        if (this.k != null) {
            Utils.setArray(this.k, 0);
        }
        if (this.l != null) {
            Utils.setArray(this.l, 0);
        }
        if (this.m != null) {
            Utils.setArray(this.m, (byte)0);
        }
        if (this.n != null) {
            Utils.setArray(this.n, (byte)0);
        }
        this.k = new int[(this.j + 1) * n];
        this.l = new int[(this.j + 1) * n];
        this.m = new byte[4 * n];
        this.n = new byte[4 * n];
    }

    private void a(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.aes128_ECB.getOID())) {
            this.d = 0;
            this.a(4, 4);
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes192_ECB.getOID())) {
            this.d = 0;
            this.a(4, 6);
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes256_ECB.getOID())) {
            this.d = 0;
            this.a(4, 8);
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes128_CBC.getOID())) {
            this.d = 1;
            this.a(4, 4);
            this.b(CryptoUtils.getIV(algorithmIdentifier));
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes192_CBC.getOID())) {
            this.d = 1;
            this.a(4, 6);
            this.b(CryptoUtils.getIV(algorithmIdentifier));
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes256_CBC.getOID())) {
            this.d = 1;
            this.a(4, 8);
            this.b(CryptoUtils.getIV(algorithmIdentifier));
        } else {
            throw new AlgorithmIdentifierException("Unknown (or unsupported) AES algorithm identifier " + algorithmIdentifier);
        }
    }

    private void b(byte[] byArray) throws AlgorithmIdentifierException {
        try {
            if (byArray != null) {
                this.a(byArray);
            } else if (this.a == null) {
                this.a(this.b().randomBytes(new byte[this.getBlockSize()]));
            } else {
                this.a(this.a);
            }
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.toString());
        }
    }

    private void a(SymmetricKey symmetricKey) throws InvalidKeyException {
        int n;
        byte[] byArray = symmetricKey.d();
        int n2 = byArray.length * 8;
        int n3 = n2 == 128 ? 4 : (n2 == 192 ? 6 : (n = n2 == 256 ? 8 : -1));
        if (n < 0) {
            throw new InvalidKeyException("Invalid keysize " + n2);
        }
        if (n != this.i) {
            this.a(this.h, n);
        }
        for (int i2 = 0; i2 < this.h * (this.j + 1); ++i2) {
            if (i2 < this.i) {
                this.k[i2] = Utils.bytesToWord(byArray[4 * i2], byArray[4 * i2 + 1], byArray[4 * i2 + 2], byArray[4 * i2 + 3]);
            } else {
                int n4 = this.k[i2 - 1];
                if (i2 % this.i == 0) {
                    byte by = (byte)(n4 >> 24);
                    byte by2 = (byte)(n4 >> 16);
                    byte by3 = (byte)(n4 >> 8);
                    byte by4 = (byte)n4;
                    n4 = AES.c(by & 0xFF | (by4 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by2 & 0xFF) << 24) ^ H[i2 / this.i];
                } else if (this.i > 6 && i2 % this.i == 4) {
                    n4 = AES.c(n4);
                }
                this.k[i2] = this.k[i2 - this.i] ^ n4;
            }
            if (i2 < this.h || i2 >= this.h * this.j) {
                this.l[i2] = this.k[i2];
                continue;
            }
            byte[] byArray2 = Utils.wordToBytes(this.k[i2]);
            this.l[i2] = S[byArray2[0] & 0xFF] ^ T[byArray2[1] & 0xFF] ^ U[byArray2[2] & 0xFF] ^ V[byArray2[3] & 0xFF];
        }
        Utils.wordsToBytes(this.k, this.j * this.h, this.m, 0, this.h);
        Utils.wordsToBytes(this.l, 0, this.n, 0, this.h);
    }

    protected void a(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        if (this.h != 4) {
            if (this.h == 6) {
                throw new CipherException("not implemented for blocksize 192");
            }
            if (this.h == 8) {
                throw new CipherException("not implemented for blocksize 256");
            }
            throw new CipherException("Invalid blocksize " + this.h);
        }
        this.d(byArray, n, byArray2, n2);
    }

    protected void b(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        if (this.h != 4) {
            if (this.h == 6) {
                throw new CipherException("not implemented for blocksize 192");
            }
            if (this.h == 8) {
                throw new CipherException("not implemented for blocksize 256");
            }
            throw new CipherException("Invalid blocking parameter " + this.h);
        }
        this.c(byArray, n, byArray2, n2);
    }

    public String algName() {
        return "AES-" + this.i * 32;
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        AlgorithmIdentifier algorithmIdentifier = this.h == 4 ? (this.d == 0 ? (this.i == 4 ? AlgID.aes128_ECB : (this.i == 6 ? AlgID.aes192_ECB : (this.i == 8 ? AlgID.aes256_ECB : null))) : (this.d == 1 ? (this.i == 4 ? new CBCAlgorithmIdentifier(AlgID.aes128_CBC, this.getIV()) : (this.i == 6 ? new CBCAlgorithmIdentifier(AlgID.aes192_CBC, this.getIV()) : (this.i == 8 ? new CBCAlgorithmIdentifier(AlgID.aes256_CBC, this.getIV()) : null))) : null)) : null;
        return algorithmIdentifier;
    }

    public int getKeySize() {
        return 4 * this.i;
    }

    public void erase() {
        super.erase();
        this.j = 0;
        this.i = 0;
        this.h = 0;
        this.b = 0;
        Utils.setArray(this.k, 0);
        Utils.setArray(this.l, 0);
        Utils.setArray(this.m, (byte)0);
        Utils.setArray(this.n, (byte)0);
        this.v = 0;
        this.u = 0;
        this.t = 0;
        this.s = 0;
        this.r = 0;
        this.q = 0;
        this.p = 0;
        this.o = 0;
        this.D = 0;
        this.C = 0;
        this.B = 0;
        this.A = 0;
        this.z = 0;
        this.y = 0;
        this.x = 0;
        this.w = 0;
        if (this.W != null) {
            this.W = null;
        }
    }

    public String toString() {
        return this.algName();
    }

    private void c(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.o = Utils.bytesToWord(byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3]) ^ this.k[0];
        this.p = Utils.bytesToWord(byArray[n + 4], byArray[n + 5], byArray[n + 6], byArray[n + 7]) ^ this.k[1];
        this.q = Utils.bytesToWord(byArray[n + 8], byArray[n + 9], byArray[n + 10], byArray[n + 11]) ^ this.k[2];
        this.r = Utils.bytesToWord(byArray[n + 12], byArray[n + 13], byArray[n + 14], byArray[n + 15]) ^ this.k[3];
        for (int i2 = 1; i2 < this.j; ++i2) {
            int n3 = this.o;
            int n4 = this.p;
            int n5 = this.q;
            int n6 = this.r;
            this.o = K[n3 >>> 24 & 0xFF] ^ L[n4 >>> 16 & 0xFF] ^ M[n5 >>> 8 & 0xFF] ^ N[n6 & 0xFF] ^ this.k[i2 * 4];
            this.p = K[n4 >>> 24 & 0xFF] ^ L[n5 >>> 16 & 0xFF] ^ M[n6 >>> 8 & 0xFF] ^ N[n3 & 0xFF] ^ this.k[i2 * 4 + 1];
            this.q = K[n5 >>> 24 & 0xFF] ^ L[n6 >>> 16 & 0xFF] ^ M[n3 >>> 8 & 0xFF] ^ N[n4 & 0xFF] ^ this.k[i2 * 4 + 2];
            this.r = K[n6 >>> 24 & 0xFF] ^ L[n3 >>> 16 & 0xFF] ^ M[n4 >>> 8 & 0xFF] ^ N[n5 & 0xFF] ^ this.k[i2 * 4 + 3];
            if (this.W == null) continue;
            try {
                this.W.writeObject(new int[]{this.o, this.p, this.q, this.r});
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException("iv trace mode broken:  " + iOException);
            }
        }
        byArray2[n2] = (byte)(I[this.o >>> 24 & 0xFF] ^ this.m[0]);
        byArray2[n2 + 1] = (byte)(I[this.p >>> 16 & 0xFF] ^ this.m[1]);
        byArray2[n2 + 2] = (byte)(I[this.q >>> 8 & 0xFF] ^ this.m[2]);
        byArray2[n2 + 3] = (byte)(I[this.r & 0xFF] ^ this.m[3]);
        byArray2[n2 + 4] = (byte)(I[this.p >>> 24 & 0xFF] ^ this.m[4]);
        byArray2[n2 + 5] = (byte)(I[this.q >>> 16 & 0xFF] ^ this.m[5]);
        byArray2[n2 + 6] = (byte)(I[this.r >>> 8 & 0xFF] ^ this.m[6]);
        byArray2[n2 + 7] = (byte)(I[this.o & 0xFF] ^ this.m[7]);
        byArray2[n2 + 8] = (byte)(I[this.q >>> 24 & 0xFF] ^ this.m[8]);
        byArray2[n2 + 9] = (byte)(I[this.r >>> 16 & 0xFF] ^ this.m[9]);
        byArray2[n2 + 10] = (byte)(I[this.o >>> 8 & 0xFF] ^ this.m[10]);
        byArray2[n2 + 11] = (byte)(I[this.p & 0xFF] ^ this.m[11]);
        byArray2[n2 + 12] = (byte)(I[this.r >>> 24 & 0xFF] ^ this.m[12]);
        byArray2[n2 + 13] = (byte)(I[this.o >>> 16 & 0xFF] ^ this.m[13]);
        byArray2[n2 + 14] = (byte)(I[this.p >>> 8 & 0xFF] ^ this.m[14]);
        byArray2[n2 + 15] = (byte)(I[this.q & 0xFF] ^ this.m[15]);
    }

    private void d(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.o = Utils.bytesToWord(byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3]) ^ this.l[4 * this.j];
        this.p = Utils.bytesToWord(byArray[n + 4], byArray[n + 5], byArray[n + 6], byArray[n + 7]) ^ this.l[4 * this.j + 1];
        this.q = Utils.bytesToWord(byArray[n + 8], byArray[n + 9], byArray[n + 10], byArray[n + 11]) ^ this.l[4 * this.j + 2];
        this.r = Utils.bytesToWord(byArray[n + 12], byArray[n + 13], byArray[n + 14], byArray[n + 15]) ^ this.l[4 * this.j + 3];
        for (int i2 = this.j - 1; i2 > 0; --i2) {
            this.w = this.o;
            this.x = this.p;
            this.y = this.q;
            this.z = this.r;
            this.o = O[this.w >>> 24 & 0xFF] ^ P[this.z >>> 16 & 0xFF] ^ Q[this.y >>> 8 & 0xFF] ^ R[this.x & 0xFF] ^ this.l[i2 * 4];
            this.p = O[this.x >>> 24 & 0xFF] ^ P[this.w >>> 16 & 0xFF] ^ Q[this.z >>> 8 & 0xFF] ^ R[this.y & 0xFF] ^ this.l[i2 * 4 + 1];
            this.q = O[this.y >>> 24 & 0xFF] ^ P[this.x >>> 16 & 0xFF] ^ Q[this.w >>> 8 & 0xFF] ^ R[this.z & 0xFF] ^ this.l[i2 * 4 + 2];
            this.r = O[this.z >>> 24 & 0xFF] ^ P[this.y >>> 16 & 0xFF] ^ Q[this.x >>> 8 & 0xFF] ^ R[this.w & 0xFF] ^ this.l[i2 * 4 + 3];
            if (this.W == null) continue;
            try {
                this.W.writeObject(new int[]{this.o, this.p, this.q, this.r});
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException("iv trace mode broken:  " + iOException);
            }
        }
        byArray2[n2] = (byte)(J[this.o >>> 24 & 0xFF] ^ this.n[0]);
        byArray2[n2 + 1] = (byte)(J[this.r >>> 16 & 0xFF] ^ this.n[1]);
        byArray2[n2 + 2] = (byte)(J[this.q >>> 8 & 0xFF] ^ this.n[2]);
        byArray2[n2 + 3] = (byte)(J[this.p & 0xFF] ^ this.n[3]);
        byArray2[n2 + 4] = (byte)(J[this.p >>> 24 & 0xFF] ^ this.n[4]);
        byArray2[n2 + 5] = (byte)(J[this.o >>> 16 & 0xFF] ^ this.n[5]);
        byArray2[n2 + 6] = (byte)(J[this.r >>> 8 & 0xFF] ^ this.n[6]);
        byArray2[n2 + 7] = (byte)(J[this.q & 0xFF] ^ this.n[7]);
        byArray2[n2 + 8] = (byte)(J[this.q >>> 24 & 0xFF] ^ this.n[8]);
        byArray2[n2 + 9] = (byte)(J[this.p >>> 16 & 0xFF] ^ this.n[9]);
        byArray2[n2 + 10] = (byte)(J[this.o >>> 8 & 0xFF] ^ this.n[10]);
        byArray2[n2 + 11] = (byte)(J[this.r & 0xFF] ^ this.n[11]);
        byArray2[n2 + 12] = (byte)(J[this.r >>> 24 & 0xFF] ^ this.n[12]);
        byArray2[n2 + 13] = (byte)(J[this.q >>> 16 & 0xFF] ^ this.n[13]);
        byArray2[n2 + 14] = (byte)(J[this.p >>> 8 & 0xFF] ^ this.n[14]);
        byArray2[n2 + 15] = (byte)(J[this.o & 0xFF] ^ this.n[15]);
    }

    private static int b(int n, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            if ((n2 >> i2 & 1) == 0) continue;
            n3 ^= G[n][i2];
        }
        return n3;
    }

    private static int a(int n) {
        int n2 = 0;
        while (n >> n2 != 0) {
            ++n2;
        }
        return n2 - 1;
    }

    private static int c(int n, int n2) {
        int n3;
        int n4 = 0;
        while ((n3 = AES.a(n) - AES.a(n2)) >= 0) {
            n ^= n2 << n3;
            n4 ^= 1 << n3;
        }
        return n4;
    }

    private static int d(int n, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 <= AES.a(n2); ++i2) {
            if ((n2 >> i2 & 1) == 0) continue;
            n3 ^= n << i2;
        }
        return n3;
    }

    private static int b(int n) {
        int n2 = 283;
        if (n == 0) {
            return 0;
        }
        int n3 = 1;
        int n4 = 0;
        while (n != 0) {
            int n5 = AES.c(n2, n);
            int n6 = n2 ^ AES.d(n, n5);
            int n7 = n4 ^ AES.d(n3, n5);
            n2 = n;
            n = n6;
            n4 = n3;
            n3 = n7;
        }
        return n4;
    }

    private static int c(int n) {
        byte by = (byte)(n >> 24);
        byte by2 = (byte)(n >> 16);
        byte by3 = (byte)(n >> 8);
        byte by4 = (byte)n;
        by = (byte)I[by & 0xFF];
        by2 = (byte)I[by2 & 0xFF];
        by3 = (byte)I[by3 & 0xFF];
        by4 = (byte)I[by4 & 0xFF];
        return by4 & 0xFF | (by3 & 0xFF) << 8 | (by2 & 0xFF) << 16 | (by & 0xFF) << 24;
    }

    private static int d(int n) {
        byte[] byArray = Utils.wordToBytes(n);
        return Utils.bytesToWord(byArray[1], byArray[2], byArray[3], byArray[0]);
    }

    private void a(ObjectOutputStream objectOutputStream) {
        this.W = objectOutputStream;
    }

    static {
        AES.h();
    }
}

