/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;

public class ASN1Header
implements Streamable,
ASN1 {
    private int a;
    private int b;
    private int c;
    private int d;

    public ASN1Header() {
    }

    public ASN1Header(int n, int n2) {
        this(n, n2, 2, -1);
    }

    public ASN1Header(int n, int n2, int n3, int n4) {
        this.a = n;
        this.b = n2;
        this.c = n3;
        this.d = n4;
    }

    public ASN1Header(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public int getTag() {
        return this.a;
    }

    public int getTagClass() {
        return this.b;
    }

    public int getEncodingMethod() {
        return this.c;
    }

    public int getBodyLength() {
        return this.d;
    }

    public int length() {
        return this.a() + this.b();
    }

    int a() {
        return 1 + (this.a < 31 ? 0 : ASN1Utils.lengthBase128(this.a));
    }

    int b() {
        return 1 + (this.d < 128 ? 0 : ASN1Utils.lengthBase256(this.d));
    }

    public int totalLength() {
        return this.length() + this.d;
    }

    public String toString() {
        return this.tagClassToString(this.b) + " " + (this.b == 0 ? this.tagToString(this.a) : Integer.toString(this.a)) + " " + this.encodingMethodToString(this.c) + " length=" + (this.c == 2 ? "unknown" : Integer.toString(this.d));
    }

    public String tagClassToString(int n) {
        String[] stringArray = new String[]{"universal", "application", "context-specific", "private"};
        return stringArray[n >> 6];
    }

    public String tagToString(int n) {
        String[] stringArray = new String[]{"END OF CONTENTS", "BOOLEAN", "INTEGER", "BIT STRING", "OCTET STRING", "NULL", "OBJECT IDENTIFIER", "ObjectDescriptor", "EXTERNAL", "REAL", "ENUMERATED", "11", "12", "13", "14", "15", "SEQUENCE", "SET", "NumericString", "PrintableString", "T61String", "VideotexString", "IA5String", "UTCTime", "GeneralizedTime", "GraphicString", "VisibleString", "GeneralString", "UniversalString", "29", "BMPString"};
        return n < stringArray.length ? stringArray[n] : Integer.toString(n);
    }

    public String encodingMethodToString(int n) {
        String[] stringArray = new String[]{"primitive", "constructed", "constructed"};
        return stringArray[n];
    }

    public void checkTagClass(int n) throws ASN1FormatException {
        if (this.b != n) {
            throw new ASN1FormatException("Got tag class " + this.tagClassToString(this.b) + " instead of " + this.tagClassToString(n) + ".");
        }
    }

    public void checkTag(int n) throws ASN1FormatException {
        if (this.a != n) {
            throw new ASN1FormatException("Got tag " + this.a + " instead of " + n + ".");
        }
    }

    public void checkEncodingMethod(int n) throws ASN1FormatException {
        if (this.c != n) {
            throw new ASN1FormatException("Got encoding method " + this.encodingMethodToString(this.c) + " instead of " + this.encodingMethodToString(n) + ".");
        }
    }

    void a(OutputStream outputStream) throws IOException {
        int n = this.a < 31 ? this.a : 31;
        int n2 = this.b | n;
        if (this.c != 0) {
            n2 |= 0x20;
        }
        outputStream.write(n2);
        if (this.a >= 31) {
            ASN1Utils.outputBase128(this.a, outputStream);
        }
    }

    void b(OutputStream outputStream) throws IOException {
        if (this.c == 2) {
            outputStream.write(128);
        } else {
            ASN1Utils.outputLengthBytes(outputStream, this.d);
        }
    }

    public void output(OutputStream outputStream) throws IOException {
        this.a(outputStream);
        this.b(outputStream);
    }

    public void input(InputStream inputStream) throws IOException {
        this.a(inputStream);
        this.b(inputStream);
    }

    void a(InputStream inputStream) throws IOException {
        int n = Utils.inputByte(inputStream) & 0xFF;
        this.b = n & 0xC0;
        this.c = (n & 0x20) == 0 ? 0 : 1;
        this.a = n & 0x1F;
        if (this.a == 31) {
            this.a = ASN1Utils.inputBase128(inputStream);
        }
    }

    void b(InputStream inputStream) throws IOException {
        int n = Utils.inputByte(inputStream) & 0xFF;
        if (n < 128) {
            this.d = n;
        } else if (n == 128) {
            this.c = 2;
            this.d = -1;
        } else {
            int n2 = n & 0x7F;
            if (n2 > 4) {
                throw new ASN1FormatException("Length is too big: takes " + n2 + " bytes");
            }
            this.d = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.d <<= 8;
                this.d |= Utils.inputByte(inputStream) & 0xFF;
            }
        }
    }

    public void skipBody(InputStream inputStream) throws IOException {
        if (this.c != 2) {
            for (int i2 = 0; i2 < this.d; ++i2) {
                Utils.inputByte(inputStream);
            }
        } else {
            while (true) {
                ASN1Header aSN1Header = new ASN1Header();
                aSN1Header.input(inputStream);
                if (aSN1Header.b == 0 && aSN1Header.a == 0 && aSN1Header.d == 0) break;
                aSN1Header.skipBody(inputStream);
            }
        }
    }

    public byte[] readBody(InputStream inputStream) throws IOException {
        if (this.c != 2) {
            byte[] byArray = new byte[this.d];
            Utils.inputByteArray(byArray, inputStream);
            return byArray;
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        while (true) {
            ASN1Header aSN1Header = new ASN1Header();
            aSN1Header.input(inputStream);
            if (aSN1Header.b == 0 && aSN1Header.a == 0 && aSN1Header.d == 0) break;
            aSN1Header.output(unsyncByteArrayOutputStream);
            unsyncByteArrayOutputStream.write(aSN1Header.readBody(inputStream));
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public byte[] headerAndBody(InputStream inputStream) throws IOException {
        byte[] byArray = this.readBody(inputStream);
        FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(this.length() + byArray.length);
        this.output(fixedByteArrayOutputStream);
        fixedByteArrayOutputStream.write(byArray);
        return fixedByteArrayOutputStream.toByteArray();
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

