/*
 * Decompiled with CFR 0.152.
 */
package oracle.viz.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.viz.util.DFTreeIterator;

public class Tree
implements Collection {
    public static final int DEPTH_MAX = Integer.MAX_VALUE;
    public static final int DEPTH_CURRENT = -1;
    protected List internalList = null;
    protected int viewDepth = Integer.MAX_VALUE;
    protected Tree parent = null;

    public Tree() {
        this.internalList = Collections.synchronizedList(new LinkedList());
    }

    protected Tree(Tree parent) {
        this();
        this.parent = parent;
    }

    public Tree(Collection c) {
        this.internalList = Collections.synchronizedList(new LinkedList());
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Node n = new Node(iter.next());
            this.internalList.add(n);
            this.addNotify(n);
        }
    }

    protected Tree(Tree parent, Collection c) {
        this(c);
        this.parent = parent;
    }

    public Tree(Object[] array) {
        this.internalList = Collections.synchronizedList(new LinkedList());
        int i = 0;
        while (i < array.length) {
            Node n = new Node(array[i]);
            this.internalList.add(n);
            this.addNotify(n);
            ++i;
        }
    }

    protected Tree(Tree parent, Object[] array) {
        this(array);
        this.parent = parent;
    }

    public boolean add(Object o) {
        Node n = new Node(o);
        this.internalList.add(n);
        this.addNotify(n);
        return true;
    }

    public boolean addAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Node n = new Node(iter.next());
            this.internalList.add(n);
            this.addNotify(n);
        }
        return true;
    }

    public void clear() {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            this.removeNotify(iter.next());
        }
        this.internalList.clear();
    }

    public boolean contains(Object o) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(o)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Tree)) {
            return false;
        }
        Iterator otherIter = ((Tree)o).iterator();
        Iterator iter = this.iterator();
        while (iter.hasNext() && otherIter.hasNext()) {
            if (iter.next().equals(otherIter.next())) continue;
            return false;
        }
        return !iter.hasNext() && !otherIter.hasNext();
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public boolean isEmpty() {
        return this.internalList.isEmpty();
    }

    public Iterator iterator() {
        return this.viewIterator(Integer.MAX_VALUE);
    }

    public boolean remove(Object o) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(o)) continue;
            this.removeNotify(o);
            iter.remove();
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!c.contains(o)) continue;
            this.removeNotify(o);
            iter.remove();
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.size(Integer.MAX_VALUE);
    }

    public Object[] toArray() {
        return this.toArray(Integer.MAX_VALUE);
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator iter = this.iterator();
        int i = 0;
        while (i < size) {
            a[i] = iter.next();
            ++i;
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public void setViewDepth(int depth) {
        this.viewDepth = depth;
    }

    public int getViewDepth() {
        return this.viewDepth;
    }

    public void add(int index, Object o) {
        this.internalList.add(index, new Node(o));
    }

    public DFTreeIterator viewIterator() {
        return this.viewIterator(this.viewDepth);
    }

    public DFTreeIterator viewIterator(int depth) {
        return new DFTreeIterator(this, depth == -1 ? this.viewDepth : depth);
    }

    public Iterator iterator(int depth) {
        return this.viewIterator(depth);
    }

    public int size(int depth) {
        int length = 0;
        DFTreeIterator iter = this.viewIterator(depth);
        while (iter.hasNext()) {
            ++length;
            iter.next();
        }
        return length;
    }

    public Object[] toArray(int depth) {
        Object[] result = new Object[this.size()];
        Iterator iter = this.iterator(depth);
        int i = 0;
        while (iter.hasNext()) {
            result[i] = iter.next();
            ++i;
        }
        return result;
    }

    public String toString() {
        String result = "";
        String item = null;
        String spacer = "  ";
        int depth = 0;
        try {
            DFTreeIterator iter = this.viewIterator();
            while (iter.hasNext()) {
                item = iter.next().toString();
                depth = iter.depth();
                int i = 0;
                while (i < depth) {
                    result = result + spacer;
                    ++i;
                }
                result = result + item.toString() + "\n";
            }
        }
        catch (Exception e) {
            System.out.println("Result so far:");
            System.out.println(result);
            e.printStackTrace(System.out);
        }
        return result;
    }

    protected static Node newNode(Object o) {
        return new Node(o);
    }

    protected void addNotify(Node n) {
        if (null != this.parent) {
            this.parent.addNotify(n);
        }
    }

    protected void removeNotify(Object o) {
        if (null != this.parent) {
            this.parent.removeNotify(o);
        }
    }

    protected static final class Node {
        public Object item = null;
        public Tree subTree = null;

        public Node(Object o) {
            this.item = o;
        }
    }
}

