/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.awt.Rectangle;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.ide.model.Project;
import oracle.ide.peek.Peek;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDILocation;
import oracle.jdevimpl.debugger.jdi.DebugJDIPlsqlTableElement;
import oracle.jdevimpl.debugger.jdi.DebugJDIStoppedListener;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIVariableInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugEvaluator;
import oracle.jdevimpl.debugger.support.DebugHasAnnotations;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.debug.DebuggerHelperHook;
import oracle.jdevimpl.runner.debug.DebuggerLanguageHelper;
import oracle.jdevimpl.runner.debug.JDebugger;

final class DebugJDIStackFrameInfo
extends JDIInformationProvider
implements DebugStackFrameInfo,
DebugJDIStoppedListener {
    DebugJDI dj;
    ThreadReference tr;
    DebugJDIThreadInfo threadInfo;
    int frameNumber;
    StackFrame sf;
    int stoppedCount;
    boolean popped;
    private DebugJDILocation location;
    private boolean stoppedListener;
    private SoftReference sfThisObject;
    private SoftReference sfMethodVariables;
    private SoftReference sfArguments;
    private SoftReference sfLocals;
    private Icon icon = null;
    private int hashCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DebugJDIStackFrameInfo makeStackFrameInfo(DebugJDI dj, DebugJDIThreadInfo threadInfo, int frameNumber, StackFrame sf) {
        DebugJDI debugJDI = dj;
        synchronized (debugJDI) {
            try {
                DebugJDIStackFrameInfo stackFrameInfo;
                SoftReference<DebugJDIStackFrameInfo> soft = dj.stackFrameInfos.get(sf);
                if (soft != null && (stackFrameInfo = soft.get()) != null) {
                    return stackFrameInfo;
                }
            }
            catch (Exception e) {
                DebugJDIStackFrameInfo.clearCache(dj);
            }
            DebugJDIStackFrameInfo stackFrameInfo = new DebugJDIStackFrameInfo(dj, threadInfo, frameNumber, sf);
            dj.stackFrameInfos.put(sf, new SoftReference<DebugJDIStackFrameInfo>(stackFrameInfo));
            return stackFrameInfo;
        }
    }

    private DebugJDIStackFrameInfo(DebugJDI dj, DebugJDIThreadInfo threadInfo, int frameNumber, StackFrame sf) {
        this.dj = dj;
        this.threadInfo = threadInfo;
        this.tr = threadInfo.tr;
        this.frameNumber = frameNumber;
        this.sf = sf;
        this.stoppedCount = dj.stoppedCount;
        this.location = dj.makeLocation(sf.location());
    }

    @Override
    public void stopped(boolean stopped) {
        this.clearSoftReferences();
        this.stoppedListener = false;
        this.dj.removeStoppedListener(this);
    }

    private void clearSoftReferences() {
        this.sfThisObject = null;
        this.sfMethodVariables = null;
        this.sfArguments = null;
        this.sfLocals = null;
    }

    public boolean hasExpired() {
        return this.stoppedCount != this.dj.stoppedCount || this.popped;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new DataExpiredException();
        }
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public DebugLocation getLocation() {
        Location jdiLocation;
        if (this.location == null && (jdiLocation = this.getJDILocation()) != null) {
            this.location = this.dj.makeLocation(jdiLocation);
        }
        return this.location;
    }

    private ObjectReference getThisObject(boolean considerFastSwap) {
        try {
            Method method;
            Object o;
            if (this.sfThisObject != null && (o = this.sfThisObject.get()) != null) {
                return (ObjectReference)o;
            }
            Location jdiLocation = this.getJDILocation();
            Method method2 = method = jdiLocation == null ? null : jdiLocation.method();
            if (method == null || this.dj.isMethodObsolete(method)) {
                return null;
            }
            ObjectReference thisObject = null;
            try {
                thisObject = this.sf.thisObject();
            }
            catch (InvalidStackFrameException e) {
                System.out.println("InvalidStackFrameException in DebugJDIStackFrameInfo.thisObject, returning null");
                return null;
            }
            if (thisObject == null && considerFastSwap && method.isStatic() && JDebugger.isFastSwapEnabledDebuggingProcess((DebugVirtualMachine)this.dj)) {
                thisObject = this.getFastSwapThisObject(method);
            }
            if (thisObject != null) {
                this.sfThisObject = new SoftReference<ObjectReference>(thisObject);
                if (!this.stoppedListener) {
                    this.stoppedListener = true;
                    this.dj.addStoppedListener(this);
                }
            }
            return thisObject;
        }
        catch (VMDisconnectedException jdiLocation) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private ObjectReference getFastSwapThisObject(Method method) {
        ReferenceType enclosingType = method.declaringType();
        if (enclosingType == null) {
            return null;
        }
        String enclosingTypeName = enclosingType.name();
        if (enclosingTypeName == null || enclosingTypeName.indexOf("$beaVersion") <= 0) {
            return null;
        }
        if (this.frameNumber >= this.threadInfo.getStackFrameCount() - 1) {
            return null;
        }
        DebugJDIStackFrameInfo otherFrame = (DebugJDIStackFrameInfo)this.threadInfo.getStackFrame(this.frameNumber + 1);
        if (otherFrame == null) {
            return null;
        }
        Location otherLocation = otherFrame.getJDILocation();
        if (otherLocation == null) {
            return null;
        }
        Method otherMethod = otherLocation.method();
        if (otherMethod == null || otherMethod.isStatic()) {
            return null;
        }
        String methodName = method.name();
        String otherMethodName = otherMethod.name();
        if (methodName == null || otherMethodName == null || !methodName.equals(otherMethodName)) {
            return null;
        }
        ReferenceType otherEnclosingType = otherMethod.declaringType();
        if (otherEnclosingType == null) {
            return null;
        }
        String otherEnclosingTypeName = otherEnclosingType.name();
        if (otherEnclosingTypeName == null) {
            return null;
        }
        if (!enclosingType.name().startsWith(otherEnclosingType.name() + "$beaVersion")) {
            return null;
        }
        return otherFrame.getThisObject(false);
    }

    private List getVariables() {
        try {
            ArrayList<LocalVariable> variables;
            Object o;
            if (this.sfMethodVariables != null && (o = this.sfMethodVariables.get()) != null) {
                return (List)o;
            }
            Location jdiLocation = this.getJDILocation();
            if (jdiLocation == null) {
                return null;
            }
            Method method = jdiLocation.method();
            if (method.isNative()) {
                variables = new ArrayList(0);
            } else {
                variables = new ArrayList<LocalVariable>();
                for (LocalVariable var : method.variables()) {
                    if (var.isArgument()) continue;
                    variables.add(var);
                }
                Collections.sort(variables, new Comparator<LocalVariable>(){

                    @Override
                    public int compare(LocalVariable lv1, LocalVariable lv2) {
                        return lv1.compareTo(lv2);
                    }
                });
                int argumentPosition = 0;
                for (LocalVariable var : method.arguments()) {
                    variables.add(argumentPosition, var);
                    ++argumentPosition;
                }
            }
            if (variables != null) {
                this.sfMethodVariables = new SoftReference(variables);
                if (!this.stoppedListener) {
                    this.stoppedListener = true;
                    this.dj.addStoppedListener(this);
                }
            }
            return variables;
        }
        catch (VMDisconnectedException jdiLocation) {
        }
        catch (AbsentInformationException jdiLocation) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private DebugVariableInfo findVariableByName(DebugVariableInfo[] vars, String name) {
        int varsLength = vars.length;
        for (int i = 0; i < varsLength; ++i) {
            if (!name.equals(vars[i].getName())) continue;
            return vars[i];
        }
        return null;
    }

    public DebugVariableInfo[] listArguments() {
        List<Value> args;
        List variables;
        Object o;
        this.throwIfExpired();
        if (this.sfArguments != null && (o = this.sfArguments.get()) != null) {
            return (DebugVariableInfo[])o;
        }
        ArrayList<DebugJDIVariableInfo> v = new ArrayList<DebugJDIVariableInfo>();
        ObjectReference thisObject = this.getThisObject(true);
        if (thisObject != null) {
            v.add(new DebugJDIVariableInfo(this.dj, this, thisObject));
        }
        if ((variables = this.getVariables()) != null) {
            for (int i = 0; i < variables.size(); ++i) {
                LocalVariable lv = (LocalVariable)variables.get(i);
                if (!lv.isArgument()) continue;
                v.add(new DebugJDIVariableInfo(this.dj, this, lv, i));
            }
        } else if (this.sf != null && (args = this.sf.getArgumentValues()) != null) {
            int i = 0;
            for (Value value : args) {
                v.add(new DebugJDIVariableInfo(this.dj, this, value, i));
                ++i;
            }
        }
        DebugVariableInfo[] arguments = v.toArray(new DebugVariableInfo[v.size()]);
        this.sfArguments = new SoftReference<DebugVariableInfo[]>(arguments);
        if (!this.stoppedListener) {
            this.stoppedListener = true;
            this.dj.addStoppedListener(this);
        }
        return arguments;
    }

    public DebugVariableInfo[] listLocals() {
        Object o;
        this.throwIfExpired();
        if (this.sfLocals != null && (o = this.sfLocals.get()) != null) {
            return (DebugVariableInfo[])o;
        }
        ArrayList<DebugJDIVariableInfo> v = new ArrayList<DebugJDIVariableInfo>();
        List variables = this.getVariables();
        if (variables != null) {
            for (int i = 0; i < variables.size(); ++i) {
                LocalVariable lv = (LocalVariable)variables.get(i);
                if (lv.isArgument()) continue;
                v.add(new DebugJDIVariableInfo(this.dj, this, lv));
            }
        }
        DebugVariableInfo[] locals = v.toArray(new DebugVariableInfo[v.size()]);
        this.sfLocals = new SoftReference<DebugVariableInfo[]>(locals);
        if (!this.stoppedListener) {
            this.stoppedListener = true;
            this.dj.addStoppedListener(this);
        }
        return locals;
    }

    public DebugVariableInfo getVariable(String name) {
        block6: {
            this.throwIfExpired();
            try {
                if (this.getLanguage() == 2) {
                    ArrayList keys = new ArrayList();
                    String tableName = DebugJDIPlsqlTableElement.parseTableElement(name, keys);
                    if (tableName != null) {
                        DebugVariableInfo var = DebugJDIPlsqlTableElement.getTableElementVariable(this.listArguments(), tableName, keys, this.dj, name, true, false);
                        if (var == null) {
                            var = DebugJDIPlsqlTableElement.getTableElementVariable(this.listLocals(), tableName, keys, this.dj, name, false, true);
                        }
                        return var;
                    }
                    break block6;
                }
                DebugVariableInfo var = this.findVariableByName(this.listArguments(), name);
                if (var == null) {
                    var = this.findVariableByName(this.listLocals(), name);
                }
                return var;
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block6;
                throw (ThreadDeath)e;
            }
        }
        return null;
    }

    public DebugStackSlotInfo[] listSlots() {
        this.throwIfExpired();
        return new DebugStackSlotInfo[0];
    }

    public int getLanguage() {
        DebugClassInfo classInfo;
        DebugLocation currentLocation = this.getLocation();
        if (currentLocation != null && (classInfo = currentLocation.getClassInfo()) != null) {
            return classInfo.getLanguage();
        }
        return 0;
    }

    public boolean popBackToHere() {
        int popFrameNumber;
        this.throwIfExpired();
        if (this.dj.canPopFrames() && (popFrameNumber = this.frameNumber - 1) >= 0) {
            try {
                DebugJDIStackFrameInfo.clearCache(this.dj);
                this.tr.popFrames(this.tr.frame(popFrameNumber));
                this.dj.incrementStoppedCount(false);
                return true;
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.tr.hashCode() + this.frameNumber;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DebugJDIStackFrameInfo) {
            DebugJDIStackFrameInfo other = (DebugJDIStackFrameInfo)o;
            DebugLocation currentLocation = this.getLocation();
            return this.dj.equals(other.dj) && this.tr.equals(other.tr) && this.frameNumber == other.frameNumber && (currentLocation == null ? other.getLocation() == null : currentLocation.equals(other.getLocation()));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache(DebugJDI dj) {
        DebugJDI debugJDI = dj;
        synchronized (debugJDI) {
            dj.stackFrameInfos.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rebuildCache(DebugJDI dj) {
        DebugJDI debugJDI = dj;
        synchronized (debugJDI) {
            ArrayList<DebugJDIStackFrameInfo> list = new ArrayList<DebugJDIStackFrameInfo>();
            for (SoftReference<DebugJDIStackFrameInfo> soft : dj.stackFrameInfos.values()) {
                DebugJDIStackFrameInfo stackFrameInfo;
                if (soft == null || (stackFrameInfo = soft.get()) == null) continue;
                list.add(stackFrameInfo);
                boolean invalid = false;
                try {
                    stackFrameInfo.sf.equals(stackFrameInfo.sf);
                }
                catch (Exception e) {
                    invalid = true;
                }
                try {
                    if (!invalid) continue;
                    stackFrameInfo.sf = stackFrameInfo.tr.frame(stackFrameInfo.frameNumber);
                    stackFrameInfo.clearSoftReferences();
                    stackFrameInfo.location = null;
                }
                catch (VMDisconnectedException e) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dj.stackFrameInfos.clear();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                DebugJDIStackFrameInfo stackFrame = (DebugJDIStackFrameInfo)list.get(i);
                try {
                    dj.stackFrameInfos.put(stackFrame.sf, new SoftReference<DebugJDIStackFrameInfo>(stackFrame));
                    continue;
                }
                catch (InvalidStackFrameException e) {
                    System.out.println("DebugJDIStackFrameInfo.rebuildCache failure; caller may retry");
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getJDILocation() {
        DebugJDI debugJDI = this.dj;
        synchronized (debugJDI) {
            try {
                return this.sf.location();
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
            }
            catch (VMDisconnectedException e) {
                return null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.refreshStackFrame();
            try {
                return this.sf.location();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public Method getJDIMethod() {
        try {
            Location jdiLocation = this.getJDILocation();
            if (jdiLocation != null) {
                return jdiLocation.method();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackFrame getJDIStackFrame() {
        DebugJDI debugJDI = this.dj;
        synchronized (debugJDI) {
            try {
                if (this.sf.equals(this.sf)) {
                    return this.sf;
                }
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
            }
            catch (VMDisconnectedException e) {
                return null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.refreshStackFrame();
            return this.sf;
        }
    }

    private void refreshStackFrame() {
        try {
            this.dj.stackFrameInfos.remove(this.sf);
            this.sf = this.tr.frame(this.frameNumber);
            this.clearSoftReferences();
            this.location = null;
            this.dj.stackFrameInfos.put(this.sf, new SoftReference<DebugJDIStackFrameInfo>(this));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DebugEvaluator getEvaluator() {
        return null;
    }

    public String getStackWindowColumnValue(int zeroBasedColumnIndex, boolean showFullyQualifiedNames) {
        switch (zeroBasedColumnIndex) {
            case 0: {
                return DebugShared.getLocationClassName((DebugLocation)this.getLocation(), (boolean)showFullyQualifiedNames);
            }
            case 1: {
                return DebugShared.getLocationMethodName((DebugStackFrameInfo)this, (DebugLocation)this.getLocation(), (boolean)false, (boolean)showFullyQualifiedNames);
            }
            case 2: {
                return DebugShared.getLocationFileName((DebugLocation)this.getLocation());
            }
            case 3: {
                return DebugShared.getLocationLine((DebugLocation)this.getLocation());
            }
            case 4: {
                return DebugShared.getLocationByteOffset((DebugLocation)this.getLocation());
            }
        }
        return "";
    }

    public String getStackWindowColumnTooltip(int zeroBasedColumnIndex) {
        return this.getStackWindowColumnValue(zeroBasedColumnIndex, true);
    }

    public boolean hasAnnotations() {
        Method method = this.getJDIMethod();
        return method instanceof DebugHasAnnotations && ((DebugHasAnnotations)method).countAnnotations() > 0;
    }

    public DebugAnnotationInfo[] getAnnotations() {
        Method method = this.getJDIMethod();
        if (method instanceof DebugHasAnnotations) {
            return ((DebugHasAnnotations)method).getAnnotations();
        }
        return null;
    }

    public Peek getCodePeek(JComponent owner, Rectangle rect, Project project) {
        int line;
        DebugLocation location = this.getLocation();
        int n = line = location != null ? location.getLine() : -1;
        if (line > 0 && location.getClassInfo() != null) {
            String fqName = location.getClassInfo().getName();
            List helpers = DebuggerHelperHook.getLanguageSpecificHelpers((Project)project);
            for (DebuggerLanguageHelper helper : helpers) {
                if (!helper.canGetURLForSourceClass()) continue;
                URL url = helper.getURLForSourceClass(project, fqName);
                if (url == null) {
                    return null;
                }
                if (!helper.canProvideCodePeek(project, url)) continue;
                return helper.createCodePeek(project, url, line, this.getLabel(), owner, rect, "execution-point");
            }
        }
        return null;
    }

    public String getLabel() {
        return DebugShared.getLocationMethodName((DebugStackFrameInfo)this, (DebugLocation)this.getLocation(), (boolean)true, (boolean)true);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setICon(Icon icon) {
        this.icon = icon;
    }
}

