/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.hook;

import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeployerFactory;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.meta.CustomMetaClass;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdevimpl.deploy.hook.BaseElementVisitor;
import oracle.jdevimpl.deploy.res.FwkArb;

public class DeployerFactoriesHandler
extends BaseElementVisitor
implements ElementVisitorFactory {
    static final ElementName EN_DEPLOYER_FACTORIES = DeployerFactoriesHandler.e("deployer-factories");
    static final ElementName EN_UPGRADED_DEPLOYER_FACTORIES = DeployerFactoriesHandler.e("upgraded-deployer-factories");
    static final ElementName EN_DEPLOYER_FACTORY = DeployerFactoriesHandler.e("deployer-factory");
    static final ElementName EN_DEPLOYABLE_CLASS = DeployerFactoriesHandler.e("deployable-class");
    static final ElementName EN_PARENT_DEPLOYABLE_CLASS = DeployerFactoriesHandler.e("parent-deployable-class");
    static final ElementName EN_RULE = DeployerFactoriesHandler.e("rule");
    static final ElementName EN_DEPLOYER_FACTORY_CLASS = DeployerFactoriesHandler.e("factory-class");
    static final String UPGRADE_ACTION = "upgradeAction";

    public void start(ElementStartContext context) {
        ElementName name = context.getElementName();
        if (EN_DEPLOYER_FACTORIES.equals((Object)name)) {
            this.setUpgradeAction((ElementContext)context, false);
            context.registerChildVisitor(EN_DEPLOYER_FACTORY, (ElementVisitor)this);
        } else if (EN_UPGRADED_DEPLOYER_FACTORIES.equals((Object)name)) {
            this.setUpgradeAction((ElementContext)context, true);
            context.registerChildVisitor(EN_DEPLOYER_FACTORY, (ElementVisitor)this);
        } else if (EN_DEPLOYER_FACTORY.equals((Object)name)) {
            FactoryData data = new FactoryData();
            data.logger = context.getLogger();
            context.getScopeData().put(FactoryData.class, data);
            context.registerVisitorFactory((ElementVisitorFactory)this);
        }
    }

    boolean getUpgradeAction(ElementContext context) {
        return (Boolean)context.getScopeData().get(UPGRADE_ACTION);
    }

    void setUpgradeAction(ElementContext context, boolean value) {
        context.getScopeData().put(UPGRADE_ACTION, value);
    }

    public void end(ElementEndContext context) {
        ElementName en = context.getElementName();
        FactoryData data = (FactoryData)context.getScopeData().get(FactoryData.class);
        if (EN_DEPLOYABLE_CLASS.equals((Object)en)) {
            data.deployable = DeployerFactoriesHandler.makeMetaClass(context);
        } else if (EN_PARENT_DEPLOYABLE_CLASS.equals((Object)en)) {
            assert (!this.getUpgradeAction((ElementContext)context));
            data.parent = DeployerFactoriesHandler.makeMetaClass(context);
        } else if (EN_DEPLOYER_FACTORY_CLASS.equals((Object)en)) {
            data.factory = DeployerFactoriesHandler.makeMetaClass(context);
        } else if (EN_RULE.equals((Object)en)) {
            assert (context.getText().trim().length() > 0);
            data.rule = context.getText().trim();
        } else if (EN_DEPLOYER_FACTORY.equals((Object)en)) {
            try {
                boolean upgrade = this.getUpgradeAction((ElementContext)context);
                CustomMetaClass factoryClass = null;
                if (data.factory != null) {
                    factoryClass = new CustomMetaClass(HookDeployerFactory.class, new Object[]{data});
                }
                if (upgrade) {
                    assert (factoryClass != null);
                    DeploymentManager.upgradeDeployerFactory(data.deployable, factoryClass);
                } else {
                    DeploymentManager.registerDeployerFactory(data.deployable, data.parent, factoryClass);
                }
            }
            catch (MetadataException e) {
                e.printStackTrace();
            }
        }
    }

    public ElementVisitor getVisitor(ElementName name) {
        return this;
    }

    public static class HookDeployerFactory
    implements DeployerFactory {
        FactoryData factoryData;
        WeakReference<DeployerFactory> deployerFactoryRef;
        boolean error = false;

        public HookDeployerFactory(FactoryData factoryData) {
            this.factoryData = factoryData;
        }

        private synchronized DeployerFactory getFactory() {
            DeployerFactory factory = null;
            if (this.deployerFactoryRef != null) {
                factory = (DeployerFactory)this.deployerFactoryRef.get();
            }
            if (factory == null && !this.error) {
                try {
                    factory = (DeployerFactory)this.factoryData.factory.newInstance();
                    this.deployerFactoryRef = new WeakReference<DeployerFactory>(factory);
                }
                catch (InstantiationException e) {
                    this.reportException(e);
                }
                catch (IllegalAccessException e) {
                    this.reportException(e);
                }
                catch (ClassNotFoundException e) {
                    this.reportException(e);
                }
            }
            return factory;
        }

        private void reportException(Exception e) {
            String msg = FwkArb.getString(47);
            this.factoryData.logger.log(Level.SEVERE, msg, e);
            this.error = true;
        }

        @Override
        public Deployer newDeployer(int deploymentSequenceId, DeployShell shell) {
            if (this.factoryData.rule != null) {
                Context context = shell.getContext();
                RuleEngine ruleEngine = RuleEngine.getInstance();
                try {
                    if (!ruleEngine.evaluateRuleOrThrow(this.factoryData.rule, context)) {
                        return null;
                    }
                }
                catch (RuleEvaluationException e) {
                    String msg = FwkArb.format(48, this.factoryData.factory.getClassName());
                    this.factoryData.logger.log(Level.SEVERE, msg);
                }
            }
            return this.getFactory().newDeployer(deploymentSequenceId, shell);
        }
    }

    private static class FactoryData {
        Logger logger;
        MetaClass deployable;
        MetaClass parent;
        MetaClass<DeployerFactory> factory;
        String rule;

        private FactoryData() {
        }
    }
}

