/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.lang.reflect.Constructor;
import java.net.URL;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class DeploymentOptions
extends HashStructureAdapter {
    public static final String DATA_KEY = "deploymentOptions";
    protected static final String OPTIONS_COMPILE_BEFORE_DEPLOY = "isCompileBeforeDeploy";
    protected static final String OPTIONS_CLEAN_BEFORE_COMPILE = "isCleanBeforeCompile";
    protected static final String OPTIONS_IGNORE_DEPENDENCIES = "ignoreDependencies";
    protected static final String OPTIONS_APPLEVEL_RELATIVE_OUTPUT_PATH = "applevelRelativeOutputPath";
    protected static final String OPTIONS_PROJECTLEVEL_RELATIVE_OUTPUT_PATH = "projectLevelRelativeOutputPath";
    protected static final String OPTIONS_APPLEVEL_ABSOLUTE_OUTPUT_URL = "applevelAbsoluteOutputUrl";
    protected static final String OPTIONS_PROJECTLEVEL_ABSOLUTE_OUTPUT_URL = "projectLevelAbsoluteOutputUrl";
    protected static final String OPTIONS_LOG_INFO_LEVEL = "logInfoLevel";

    public DeploymentOptions(HashStructure hash) {
        super(hash);
    }

    public HashStructure getHashStructure() {
        return super.getHashStructure();
    }

    public static <T extends DeploymentOptions> T find(HashStructure hash, Class<T> optionsClass) {
        HashStructure optionsHash = hash.getHashStructure(DATA_KEY);
        return DeploymentOptions.create(optionsHash, optionsClass);
    }

    public static <T extends DeploymentOptions> T findOrCreate(HashStructure hash, Class<T> optionsClass) {
        hash.getOrCreateHashStructure(DATA_KEY);
        return DeploymentOptions.find(hash, optionsClass);
    }

    public static <T extends DeploymentOptions> T getDefault(Class<T> optionsClass) {
        Preferences preferences = Preferences.getPreferences();
        T options = DeploymentOptions.find(preferences.getProperties(), optionsClass);
        if (options == null) {
            options = DeploymentOptions.create(HashStructure.newInstance(), optionsClass);
        }
        return options;
    }

    public static <T extends DeploymentOptions> T create(HashStructure hash, Class<T> optionsClass) {
        DeploymentOptions ret = null;
        if (hash != null) {
            try {
                Constructor<T> ctor = optionsClass.getConstructor(HashStructure.class);
                ctor.setAccessible(true);
                ret = (DeploymentOptions)((Object)ctor.newInstance(hash));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (T)((Object)ret);
    }

    public boolean isCompileBeforeDeploy() {
        return this._hash.getBoolean(OPTIONS_COMPILE_BEFORE_DEPLOY, true);
    }

    public void setCompileBeforeDeploy(boolean compile) {
        this._hash.putBoolean(OPTIONS_COMPILE_BEFORE_DEPLOY, compile);
    }

    public boolean isCleanBeforeCompile() {
        return this._hash.getBoolean(OPTIONS_CLEAN_BEFORE_COMPILE, false);
    }

    public void setCleanBeforeCompile(boolean clean) {
        this._hash.putBoolean(OPTIONS_CLEAN_BEFORE_COMPILE, clean);
    }

    public void setIgnoreDependencies(boolean ignore) {
        this._hash.putBoolean(OPTIONS_IGNORE_DEPENDENCIES, ignore);
    }

    public boolean isIgnoreDependencies() {
        return this._hash.getBoolean(OPTIONS_IGNORE_DEPENDENCIES, false);
    }

    public String getApplicationRelativeOutputFolder() {
        return this._hash.getString(OPTIONS_APPLEVEL_RELATIVE_OUTPUT_PATH, "deploy");
    }

    public void setApplicationRelativeOutputFolder(String path) {
        if (path == null) {
            this._hash.remove(OPTIONS_APPLEVEL_RELATIVE_OUTPUT_PATH);
            return;
        }
        this._hash.putString(OPTIONS_APPLEVEL_RELATIVE_OUTPUT_PATH, path);
    }

    public String getProjectRelativeOutputFolder() {
        return this._hash.getString(OPTIONS_PROJECTLEVEL_RELATIVE_OUTPUT_PATH, "deploy");
    }

    public void setProjectRelativeOutputFolder(String path) {
        if (path == null) {
            this._hash.remove(OPTIONS_PROJECTLEVEL_RELATIVE_OUTPUT_PATH);
            return;
        }
        this._hash.putString(OPTIONS_PROJECTLEVEL_RELATIVE_OUTPUT_PATH, path);
    }

    public URL getApplicationAbsoluteOutputURL() {
        return this._hash.getURL(OPTIONS_APPLEVEL_ABSOLUTE_OUTPUT_URL);
    }

    public void setApplicationAbsoluteOutputURL(URL path) {
        this._hash.putURL(OPTIONS_APPLEVEL_ABSOLUTE_OUTPUT_URL, path);
    }

    public URL getProjectAbsoluteOutputURL() {
        return this._hash.getURL(OPTIONS_PROJECTLEVEL_ABSOLUTE_OUTPUT_URL);
    }

    public void setProjectAbsoluteOutputURL(URL path) {
        this._hash.putURL(OPTIONS_PROJECTLEVEL_ABSOLUTE_OUTPUT_URL, path);
    }

    public void setInfoLogLevel(InfoLogLevel level) {
        if (level == null || level == InfoLogLevel.NORMAL) {
            this._hash.remove(OPTIONS_LOG_INFO_LEVEL);
        }
        this._hash.putString(OPTIONS_LOG_INFO_LEVEL, level.toString());
    }

    public InfoLogLevel getInfoLogLevel() {
        String level = this._hash.getString(OPTIONS_LOG_INFO_LEVEL);
        try {
            return level == null ? InfoLogLevel.NORMAL : InfoLogLevel.valueOf(level);
        }
        catch (IllegalArgumentException e) {
            return InfoLogLevel.NORMAL;
        }
    }

    public boolean isVerbose() {
        return InfoLogLevel.VERBOSE == this.getInfoLogLevel();
    }

    public boolean isQuiet() {
        return InfoLogLevel.QUIET == this.getInfoLogLevel();
    }

    public static enum InfoLogLevel {
        VERBOSE,
        NORMAL,
        QUIET;

    }
}

