/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline.handlers;

import oracle.dbtools.raptor.console.clone.DbtoolsConsoleReader;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedConnectFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class SQLCliPromptedConnectFieldsProvider
implements IGetPromptedConnectFieldsProvider {
    boolean ctrld = false;

    @Override
    public String[] get3Fields(ScriptRunnerContext scriptRunnerContext, String connectName, String connectPassword, String connectDB, boolean retry) {
        if (scriptRunnerContext.getProperty("script.runner.jline") == null) {
            return null;
        }
        this.ctrld = false;
        if (!(retry || connectName == null || connectName.equals("") || connectPassword == null || connectPassword.equals("") || connectDB == null || connectDB.equals(""))) {
            return new String[]{connectName, connectPassword, connectDB};
        }
        String retrying = "";
        if (retry) {
            retrying = ScriptRunnerDbArb.getString("CONNECT_RETRYING") + " ";
        }
        String namePlus = this.getOneField(scriptRunnerContext, ScriptRunnerDbArb.getString("CONNECT_USERNAME") + " " + retrying, connectName, false, retry);
        String[] retString = null;
        if (!(namePlus == null || namePlus.equals("") || namePlus.indexOf("/") == -1 && namePlus.indexOf("@") == -1)) {
            ConnectionDetails cd = ScriptUtils.getConnectionDetails("connect " + namePlus);
            connectName = cd.getConnectName();
            if (cd.getConnectPassword() != null && !cd.getConnectPassword().equals("")) {
                connectPassword = cd.getConnectPassword();
                connectDB = cd.getConnectDB();
            } else {
                connectPassword = this.getOneField(scriptRunnerContext, ScriptRunnerDbArb.getString("CONNECT_PASSWORD") + " " + retrying, connectPassword, true, retry);
                connectDB = namePlus.indexOf("@") != -1 ? cd.getConnectDB() : this.getOneField(scriptRunnerContext, ScriptRunnerDbArb.getString("CONNECT_DATABASE") + " " + retrying, connectDB, false, retry);
            }
            retString = new String[]{connectName, connectPassword, connectDB};
        } else {
            retString = new String[]{namePlus, this.getOneField(scriptRunnerContext, ScriptRunnerDbArb.getString("CONNECT_PASSWORD") + " " + retrying, connectPassword, true, retry), this.getOneField(scriptRunnerContext, ScriptRunnerDbArb.getString("CONNECT_DATABASE") + " " + retrying, connectDB, false, retry)};
        }
        if (this.ctrld) {
            return null;
        }
        return retString;
    }

    String getOneField(ScriptRunnerContext ctx, String prompt, String existing, boolean hide, boolean retry) {
        DbtoolsConsoleReader reader;
        if (this.ctrld) {
            return "";
        }
        if ((retry || existing == null || existing.equals("")) && (reader = (DbtoolsConsoleReader)ctx.getProperty("script.runner.jline")) != null) {
            String haveASpace = "";
            haveASpace = hide ? prompt + "(**********?) " : prompt + "('" + existing + "'?) ";
            String fromConsole = null;
            try {
                fromConsole = hide ? reader.readLineSimple(haveASpace, Character.valueOf('*')) : reader.readLineSimple(haveASpace);
                if (retry && fromConsole != null && fromConsole.equals("")) {
                    fromConsole = existing;
                }
                if (fromConsole == null) {
                    this.ctrld = true;
                    fromConsole = "";
                }
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e);
            }
            return fromConsole;
        }
        return existing;
    }
}

