/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.util.StringTokenizer;
import oracle.dbtools.plusplus.IBuffer;
import oracle.dbtools.raptor.console.SQLPlusConsoleReader;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;

public class EditCommand
extends CommandListener
implements IHelp {
    private static final String AFIEDT = "afiedt.buf";
    private static final String EDITOR = "_EDITOR";
    private static final String DOT = ".";
    private ScriptRunnerContext ctx;

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        this.ctx = ctx;
        StringTokenizer st = new StringTokenizer(cmd.getSql());
        String filename = AFIEDT;
        if (st.countTokens() == 2) {
            st.nextToken();
            String token2 = st.nextToken();
            filename = token2.lastIndexOf(DOT) == -1 ? token2 + DOT + ctx.getProperty("script.runner.file.suffix") : token2;
        } else if (st.countTokens() > 3) {
            ctx.write("SP0556:Invalid file name\n");
            ctx.write("Unable to complete EDIT command\n");
            return true;
        }
        return this.processFile(ctx.prependCD(filename));
    }

    private boolean processFile(String filename) {
        IBuffer buf = this.ctx.getSQLPlusBuffer().getBufferSafe();
        try {
            File file = new File(filename);
            if (filename.toLowerCase().equals(AFIEDT)) {
                if (file.exists()) {
                    file.delete();
                }
                FileWriter f = new FileWriter(filename);
                f.write(buf.getBuffer());
                f.flush();
                f.close();
            }
            if (this.ctx.getMap().get(EDITOR).toLowerCase().equals("inline")) {
                this.processInternalEditor();
            } else {
                this.processExternalEditor(filename);
                if (file.exists() && filename.toLowerCase().equals(AFIEDT)) {
                    String line;
                    FileReader fr = new FileReader(filename);
                    BufferedReader br = new BufferedReader(fr);
                    buf.clear();
                    while ((line = br.readLine()) != null) {
                        buf.add(line);
                    }
                    buf.getBufferSafe().setBufferSafe(buf.getBufferList());
                    br.close();
                }
                this.ctx.write(buf.getBufferSafe().list());
            }
        }
        catch (IOException e) {
            this.ctx.write(e.getMessage() + "\n");
        }
        return true;
    }

    private void processInternalEditor() {
        SQLPlusConsoleReader reader = (SQLPlusConsoleReader)this.ctx.getSQLPlusConsoleReader();
        reader.setRedit(true);
    }

    private void processExternalEditor(String filename) {
        String editor = this.ctx.getMap().get(EDITOR);
        ProcessBuilder builder = new ProcessBuilder(editor, filename);
        builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        try {
            Process process = builder.start();
            process.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.isCommandLine()) {
            ctx.getSQLPlusConsoleReader().pauseReader(true);
        }
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.isCommandLine()) {
            ctx.getSQLPlusConsoleReader().pauseReader(false);
        }
    }

    @Override
    public String getCommand() {
        return "EDIT";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }
}

