/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class SQLCliOptions {
    public static String commandlineArg = "";
    public static ArrayList<String> options = new ArrayList();
    public static Properties properties = new Properties();
    public static final String LOGGING = "-verbose";
    public static final String H = "-h";
    public static final String HELP = "-help";
    public static final String L = "-l";
    public static final String LOGON = "-logon";
    public static final String R = "-r";
    public static final String RESTRICT = "-restrict";
    public static final String R1 = "1";
    public static final String R2 = "2";
    public static final String R3 = "3";
    public static final String R4 = "4";
    public static final String S = "-s";
    public static final String SILENT = "-silent";
    public static final String V = "-v";
    public static final String VERSION = "-version";
    public static final String NOLOG = "/nolog";
    public static final String OCI = "-oci";
    public static final String NOLOGINFILE = "-nologinfile";
    private static final String AT = "@";
    private static final Object AS = "as";
    private static final String[] ASROLES = new String[]{"sysdba", "sysbackup", "sysdg", "syskm", "sysasm", "sysoper"};
    private static final CharSequence SYSBACKUP = "sysbackup";
    private static int atcount = 0;
    private static String connectString;
    private static String filename;
    private static ArrayList<String> variables;
    private static String asRole;
    private static boolean assysbackup;
    public static final String SSHHOST = "-sshhost";
    public static final String SSHKEY = "-sshkey";
    static String[] realOption;
    private static String badOption;

    public static void setArgs(String[] cmdLineArgs) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < cmdLineArgs.length; ++index) {
            String arg = cmdLineArgs[index] + " ";
            sb.append(arg);
        }
        commandlineArg = sb.toString();
    }

    public static String getArgsString() {
        return commandlineArg;
    }

    public static String[] getArgsArray() {
        StringTokenizer st = new StringTokenizer(commandlineArg);
        String[] args = new String[st.countTokens()];
        int index = 0;
        while (st.hasMoreElements()) {
            args[index] = st.nextToken();
        }
        return args;
    }

    public static void setAtCount(int i) {
        atcount = i;
    }

    public static int getAtCount() {
        return atcount;
    }

    public static void setConnectString(String connect) {
        connectString = connect != null && connect.startsWith("\"") && !connect.endsWith("\"") && connect.length() > 1 ? connect.substring(1) : connect;
    }

    public static String getConnectString() {
        return connectString;
    }

    public static String getFileName() {
        return filename;
    }

    public static void setFileArguments(ArrayList<String> args) {
        variables = args;
    }

    public static ArrayList<String> getFileArguments() {
        return variables;
    }

    public static void setFileName(String arg) {
        String aFileName = "";
        if (arg != null) {
            aFileName = arg.indexOf(AT) == 0 ? arg.substring(1) : arg;
            File f = new File(aFileName);
            if (!f.exists() && aFileName.indexOf(".") == -1) {
                aFileName = aFileName + ".sql";
            }
            if (!f.exists() && aFileName.indexOf(".") == -1) {
                aFileName = aFileName + ".sql";
            }
        }
        filename = aFileName;
    }

    private static int processOption(String[] arguments, int index) {
        String currArg;
        String arg = currArg = arguments[index];
        int skip = 0;
        if (currArg != null) {
            block19 : switch (arg.toLowerCase()) {
                case "-l": {
                    if (!options.contains(LOGON)) {
                        options.add(LOGON);
                    }
                    skip = 1;
                    break;
                }
                case "-logon": {
                    if (!options.contains(LOGON)) {
                        options.add(LOGON);
                    }
                    skip = 1;
                    break;
                }
                case "-h": {
                    if (!options.contains(HELP)) {
                        options.add(HELP);
                    }
                    skip = 1;
                    break;
                }
                case "-help": {
                    if (!options.contains(HELP)) {
                        options.add(HELP);
                    }
                    skip = 1;
                    break;
                }
                case "-v": {
                    if (!options.contains(VERSION)) {
                        options.add(VERSION);
                    }
                    skip = 1;
                    break;
                }
                case "-version": {
                    if (!options.contains(VERSION)) {
                        options.add(VERSION);
                    }
                    skip = 1;
                    break;
                }
                case "-s": {
                    if (!options.contains(SILENT)) {
                        options.add(SILENT);
                    }
                    skip = 1;
                    break;
                }
                case "-silent": {
                    if (!options.contains(SILENT)) {
                        options.add(SILENT);
                    }
                    skip = 1;
                    break;
                }
                case "-r": 
                case "-restrict": {
                    if (!options.contains(RESTRICT)) {
                        options.add(RESTRICT);
                    }
                    skip = 1;
                    if (index >= arguments.length - 1) break;
                    try {
                        int rlevel = Integer.parseInt(arguments[index + 1]);
                        skip = 2;
                        switch (rlevel) {
                            case 1: {
                                if (options.contains(R1)) break block19;
                                options.add(R1);
                                break;
                            }
                            case 2: {
                                if (options.contains(R2)) break block19;
                                options.add(R2);
                                break;
                            }
                            case 3: {
                                if (options.contains(R3)) break block19;
                                options.add(R3);
                                break;
                            }
                            case 4: {
                                if (options.contains(R4)) break block19;
                                options.add(R4);
                                break;
                            }
                            default: {
                                skip = -1;
                                break;
                            }
                        }
                    }
                    catch (NumberFormatException e) {}
                    break;
                }
                case "-oci": {
                    if (!options.contains(OCI)) {
                        options.add(OCI);
                    }
                    skip = 1;
                    break;
                }
                case "-nologinfile": {
                    if (!options.contains(NOLOGINFILE)) {
                        options.add(NOLOGINFILE);
                    }
                    skip = 1;
                    break;
                }
                case "/nolog": {
                    if (!options.contains(NOLOG)) {
                        options.add(NOLOG);
                    }
                    skip = 1;
                    break;
                }
                case "-verbose": {
                    if (!options.contains(LOGGING)) {
                        options.add(LOGGING);
                    }
                    skip = 1;
                    break;
                }
                case "-sshhost": {
                    if (options.contains(SSHHOST)) break;
                    if (arguments.length > index) {
                        options.add(SSHHOST);
                        SQLCliOptions.getProperties().put(SSHHOST, arguments[index + 1]);
                    }
                    skip = 2;
                    break;
                }
                case "-sshkey": {
                    if (options.contains(SSHKEY)) break;
                    if (arguments.length > index) {
                        options.add(SSHKEY);
                        SQLCliOptions.getProperties().put(SSHKEY, arguments[index + 1]);
                    }
                    skip = 2;
                    break;
                }
                default: {
                    skip = -1;
                }
            }
        }
        return skip;
    }

    public static boolean processOptions(String[] arguments) {
        String msg = "Bad Option: {0}\n";
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(arguments));
        for (int index = 0; index < arguments.length; ++index) {
            int skip = SQLCliOptions.processOption(arguments, index);
            if (!(skip != -1 || !arguments[index].startsWith("-") && (!arguments[index].startsWith("/") || arguments[index].trim().equals("/") || arguments[index].trim().startsWith("/") && arguments[index].trim().contains(AT)))) {
                SQLCliOptions.setBadOption(MessageFormat.format(msg, arguments[index]));
            }
            for (int i = 0; i < skip; ++i) {
                list.remove(0);
            }
        }
        if (!list.isEmpty() && !list.get(0).startsWith(AT)) {
            SQLCliOptions.setConnectString(list.get(0));
            if (list.size() >= 3) {
                if (list.get(1).toLowerCase().equals(AS)) {
                    if (list.get(2) != null) {
                        for (String role : ASROLES) {
                            if (!list.get(2).equalsIgnoreCase(role)) continue;
                            SQLCliOptions.setAsRole(list.get(2));
                        }
                    }
                } else if (list.get(1).toLowerCase().equals(AS) && list.get(2).toLowerCase().contains(SYSBACKUP)) {
                    SQLCliOptions.setAsSysBackup(true);
                }
            }
            list.remove(0);
            if (SQLCliOptions.getAsRole() != null && !SQLCliOptions.getAsRole().equals("")) {
                list.remove(0);
                list.remove(0);
            }
        }
        if (!list.isEmpty()) {
            if (list.get(0).startsWith(AT) && list.get(0).length() > 1) {
                SQLCliOptions.setFileName(list.get(0));
                list.remove(0);
            } else if (list.get(0).startsWith(AT) && list.get(0).length() == 1) {
                list.remove(0);
                if (!list.isEmpty()) {
                    SQLCliOptions.setFileName(list.get(0));
                    list.remove(0);
                }
            }
        }
        if (!list.isEmpty()) {
            SQLCliOptions.setFileArguments(list);
        }
        return true;
    }

    public static void main(String[] args) {
        String argsString = "-V -SILENT -oci -nologinfile \"repo/repo@orcl as sysdba\"";
        String[] arg = SQLCliOptions.argsProcess(argsString);
        if (!SQLCliOptions.processOptions(arg)) {
            // empty if block
        }
        SQLCliOptions.printStuff();
        options.removeAll(options);
        SQLCliOptions.setFileName(null);
        SQLCliOptions.getFileArguments().removeAll(SQLCliOptions.getFileArguments());
        SQLCliOptions.setAsRole("");
        argsString = "-oci -nologinfile repo@orcl @file one two three";
        arg = SQLCliOptions.argsProcess(argsString);
        SQLCliOptions.processOptions(arg);
        SQLCliOptions.printStuff();
        options.removeAll(options);
        SQLCliOptions.setFileName(null);
        SQLCliOptions.getFileArguments().removeAll(SQLCliOptions.getFileArguments());
        SQLCliOptions.setAsRole("");
        argsString = "repo/repo@localhost:1521/orcl @t.sql";
        arg = SQLCliOptions.argsProcess(argsString);
        SQLCliOptions.processOptions(arg);
        SQLCliOptions.printStuff();
    }

    public static void printStuff() {
        Iterator<String> it = options.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
        System.out.println("ConnectString:" + SQLCliOptions.getConnectString());
        System.out.println("sysdba:" + (SQLCliOptions.getAsRole() != null && SQLCliOptions.getAsRole().equalsIgnoreCase("sysdba") ? "true" : "false"));
        System.out.println("Filename:" + SQLCliOptions.getFileName());
        System.out.println("Filename args:");
        it = SQLCliOptions.getFileArguments().iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    private static String[] argsProcess(String stringArray) {
        StringTokenizer st = new StringTokenizer(stringArray);
        String[] array = new String[st.countTokens()];
        int index = 0;
        while (st.hasMoreElements()) {
            array[index] = st.nextToken();
            ++index;
        }
        return array;
    }

    public static String getAsRole() {
        return asRole;
    }

    public static boolean isAsSysBackup() {
        return assysbackup;
    }

    public static void setAsRole(String role) {
        asRole = role;
    }

    public static void setAsSysBackup(boolean amISysBackup) {
        assysbackup = amISysBackup;
    }

    public static ScriptRunnerContext populateContextWithOptions(ScriptRunnerContext context) {
        if (options.contains(OCI)) {
            context.putProperty("DBConfig.USE_THICK_DRIVER", true);
        }
        if (options.contains(NOLOGINFILE)) {
            context.putProperty("DBConfig.GLOGIN", false);
        }
        if (options.contains(LOGGING)) {
            context.putProperty("SqlCli.optlflag", true);
        }
        if (options.contains(NOLOG)) {
            context.putProperty("script.runner.sqlplus.nolog", true);
        }
        if (options.contains(R1)) {
            context.putProperty("script.runner.restrict_level", R1);
        }
        if (options.contains(R2)) {
            context.putProperty("script.runner.restrict_level", R2);
        }
        if (options.contains(R3)) {
            context.putProperty("script.runner.restrict_level", R3);
        }
        if (options.contains(R4)) {
            context.putProperty("script.runner.restrict_level", R4);
        }
        if (options.contains(SILENT) || options.contains(S)) {
            context.putProperty("script.runner.sqlplus.silent", true);
        }
        return context;
    }

    public static boolean isOptionUsed(String option) {
        return options.contains(option);
    }

    public static Properties getProperties() {
        return properties;
    }

    public static boolean isBadOption() {
        return badOption != null;
    }

    public static String getBadOption() {
        return badOption;
    }

    public static void setBadOption(String badOption) {
        SQLCliOptions.badOption = badOption;
    }

    static {
        variables = new ArrayList();
        asRole = "";
        assysbackup = false;
        realOption = new String[]{SSHHOST, SSHKEY, OCI, NOLOGINFILE, NOLOG, VERSION, V, SILENT, S, RESTRICT, R, LOGGING, LOGON, L, HELP, H};
    }
}

