/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FCLSupport;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbCollections;
import org.openide.util.io.NbMarshalledObject;

public class Repository
implements Serializable {
    private static Repository repository;
    static final long serialVersionUID = -6344768369160069704L;
    private ArrayList<FileSystem> fileSystems;
    private transient List<FileSystem> fileSystemsClone = Collections.emptyList();
    private FileSystem system;
    private Hashtable<String, FileSystem> names;
    private transient FCLSupport fclSupport;
    private Hashtable<RepositoryListener, RepositoryListener> listeners = new Hashtable();
    private VetoableChangeListener vetoListener = new VetoableChangeListener(){

        @Override
        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            if (ev.getPropertyName().equals("systemName")) {
                String ov = (String)ev.getOldValue();
                String nv = (String)ev.getNewValue();
                if (Repository.this.names.get(nv) != null) {
                    throw new PropertyVetoException("system name already exists: " + ov + " -> " + nv, ev);
                }
            }
        }
    };
    private PropertyChangeListener propListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (ev.getPropertyName().equals("systemName")) {
                String ov = (String)ev.getOldValue();
                String nv = (String)ev.getNewValue();
                FileSystem fs = (FileSystem)ev.getSource();
                if (fs.isValid()) {
                    Repository.this.names.remove(ov);
                }
                Repository.this.names.put(nv, fs);
                fs.setValid(true);
            }
        }
    };
    private static final ThreadLocal<FileSystem[]> ADD_FS;

    protected void refreshAdditionalLayers() {
        if (this.getDefaultFileSystem() instanceof MainFS) {
            ((MainFS)this.getDefaultFileSystem()).refreshLayers();
        }
    }

    protected final List<? extends URL> findLayers(LayerProvider p) {
        if (this != Repository.getDefault()) {
            return Collections.emptyList();
        }
        ArrayList urls = new ArrayList();
        p.registerLayers(urls);
        return urls;
    }

    public Repository(FileSystem def) {
        this.system = def;
        this.init();
    }

    private void init() {
        this.fileSystems = new ArrayList();
        this.names = new Hashtable();
        if (Repository.addFileSystemDelayed(this.system)) {
            this.addFileSystem(this.system);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Repository getDefault() {
        Lookup lkp = Lookup.getDefault();
        Class<Repository> clazz = Repository.class;
        synchronized (Repository.class) {
            if (repository != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return repository;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            FileSystem[] previous = ADD_FS.get();
            try {
                FileSystem[] addLater = new FileSystem[1];
                ADD_FS.set(addLater);
                Repository newRepo = (Repository)lkp.lookup(Repository.class);
                if (newRepo == null) {
                    newRepo = new Repository(new MainFS());
                }
                Object object = newRepo;
                synchronized (object) {
                    if (addLater[0] instanceof FileSystem) {
                        newRepo.addFileSystemImpl(addLater[0]);
                    }
                }
                object = Repository.class;
                synchronized (Repository.class) {
                    if (repository == null) {
                        repository = newRepo;
                    }
                    Repository repository = Repository.repository;
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                    return repository;
                }
            }
            finally {
                ADD_FS.set(previous);
            }
        }
    }

    static synchronized void reset() {
        repository = null;
    }

    private static boolean addFileSystemDelayed(FileSystem fs) {
        FileSystem[] store = ADD_FS.get();
        if (store != null) {
            assert (store[0] == null);
            store[0] = fs;
            return false;
        }
        return true;
    }

    private boolean addFileSystemImpl(FileSystem fs) {
        Thread.holdsLock(this);
        if (!fs.assigned && !this.fileSystems.contains(fs)) {
            boolean isReg;
            fs.setRepository(this);
            this.fileSystems.add(fs);
            this.fileSystemsClone = new ArrayList<FileSystem>(this.fileSystems);
            String systemName = fs.getSystemName();
            boolean bl = isReg = this.names.get(systemName) == null;
            if (isReg && !systemName.equals("")) {
                this.names.put(systemName, fs);
                fs.setValid(true);
            } else {
                fs.setValid(false);
            }
            fs.assigned = true;
            fs.addPropertyChangeListener(this.propListener);
            fs.addVetoableChangeListener(this.vetoListener);
            fs.addNotify();
            return true;
        }
        return false;
    }

    @Deprecated
    public final FileSystem getDefaultFileSystem() {
        return this.system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void addFileSystem(FileSystem fs) {
        boolean fireIt;
        Repository repository = this;
        synchronized (repository) {
            fireIt = this.addFileSystemImpl(fs);
        }
        if (fireIt) {
            this.fireFileSystem(fs, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void removeFileSystem(FileSystem fs) {
        boolean fireIt = false;
        Repository repository = this;
        synchronized (repository) {
            if (fs.isDefault()) {
                return;
            }
            fireIt = this.fileSystems.remove(fs);
            if (fireIt) {
                fs.setRepository(null);
                this.fileSystemsClone = new ArrayList<FileSystem>(this.fileSystems);
                if (fs.isValid()) {
                    this.names.remove(fs.getSystemName());
                    fs.setValid(false);
                }
                fs.removePropertyChangeListener(this.propListener);
                fs.removeVetoableChangeListener(this.vetoListener);
                fs.removeNotify();
            }
            fs.assigned = false;
        }
        if (fireIt) {
            this.fireFileSystem(fs, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void reorder(int[] perm) {
        Repository repository = this;
        synchronized (repository) {
            if (perm == null) {
                throw new IllegalArgumentException("null permutation");
            }
            if (perm.length != this.fileSystems.size()) {
                throw new IllegalArgumentException("permutation is wrong size: " + perm.length + " elements but should be " + this.fileSystems.size());
            }
            if (!Repository.isPermutation(perm)) {
                StringBuffer message = new StringBuffer("permutation is not really a permutation:");
                for (int i = 0; i < perm.length; ++i) {
                    message.append(' ');
                    message.append(perm[i]);
                }
                throw new IllegalArgumentException(message.toString());
            }
            ArrayList<FileSystem> newList = new ArrayList<FileSystem>(this.fileSystems.size());
            int len = perm.length;
            for (int i = 0; i < len; ++i) {
                newList.add(this.fileSystems.get(perm[i]));
            }
            this.fileSystems = newList;
            this.fileSystemsClone = new ArrayList<FileSystem>(this.fileSystems);
        }
        this.fireFileSystemReordered(perm);
    }

    private static boolean isPermutation(int[] perm) {
        int len = perm.length;
        boolean[] bool = new boolean[len];
        try {
            for (int i = 0; i < len; ++i) {
                if (bool[perm[i]]) {
                    return false;
                }
                bool[perm[i]] = true;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    @Deprecated
    public final Enumeration<? extends FileSystem> getFileSystems() {
        return Collections.enumeration(this.fileSystemsClone);
    }

    @Deprecated
    public final Enumeration<? extends FileSystem> fileSystems() {
        return this.getFileSystems();
    }

    @Deprecated
    public final FileSystem[] toArray() {
        List<FileSystem> tempFileSystems = this.fileSystemsClone;
        FileSystem[] fss = new FileSystem[tempFileSystems.size()];
        tempFileSystems.toArray(fss);
        return fss;
    }

    @Deprecated
    public final FileSystem findFileSystem(String systemName) {
        FileSystem fs = this.names.get(systemName);
        return fs;
    }

    @Deprecated
    public final synchronized void writeExternal(ObjectOutput oos) throws IOException {
        for (FileSystem fs : this.fileSystems) {
            if (fs.isDefault()) continue;
            oos.writeObject(new NbMarshalledObject((Object)fs));
        }
        oos.writeObject(null);
    }

    @Deprecated
    public final synchronized void readExternal(ObjectInput ois) throws IOException, ClassNotFoundException {
        FileSystem fs;
        Object obj;
        ArrayList<FileSystem> temp = new ArrayList<FileSystem>(10);
        while ((obj = ois.readObject()) != null) {
            if (obj instanceof FileSystem) {
                fs = (FileSystem)obj;
            } else {
                try {
                    NbMarshalledObject mar = (NbMarshalledObject)obj;
                    fs = (FileSystem)mar.get();
                }
                catch (IOException ex) {
                    ExternalUtil.exception(ex);
                    fs = null;
                }
                catch (ClassNotFoundException ex) {
                    ExternalUtil.exception(ex);
                    fs = null;
                }
            }
            if (fs == null) continue;
            temp.add(fs);
        }
        Enumeration<? extends FileSystem> ee = this.getFileSystems();
        while (ee.hasMoreElements()) {
            fs = ee.nextElement();
            if (fs.isDefault()) continue;
            this.removeFileSystem(fs);
        }
        this.system.assigned = false;
        this.init();
        Iterator iter = temp.iterator();
        while (iter.hasNext()) {
            this.addFileSystem((FileSystem)iter.next());
        }
    }

    @Deprecated
    public final FileObject find(String aPackage, String name, String ext) {
        assert (false) : "Deprecated.";
        Enumeration<? extends FileSystem> en = this.getFileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = en.nextElement();
            FileObject fo = fs.find(aPackage, name, ext);
            if (fo == null) continue;
            return fo;
        }
        return null;
    }

    @Deprecated
    public final FileObject findResource(String name) {
        assert (false) : "Deprecated.";
        Enumeration<? extends FileSystem> en = this.getFileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = en.nextElement();
            FileObject fo = fs.findResource(name);
            if (fo == null) continue;
            return fo;
        }
        return null;
    }

    @Deprecated
    public final Enumeration<? extends FileObject> findAllResources(String name) {
        assert (false) : "Deprecated.";
        Vector<FileObject> v = new Vector<FileObject>(8);
        Enumeration<? extends FileSystem> en = this.getFileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = en.nextElement();
            FileObject fo = fs.findResource(name);
            if (fo == null) continue;
            v.addElement(fo);
        }
        return v.elements();
    }

    @Deprecated
    public final Enumeration<? extends FileObject> findAll(String aPackage, String name, String ext) {
        assert (false) : "Deprecated.";
        Enumeration<? extends FileSystem> en = this.getFileSystems();
        Vector<FileObject> ret = new Vector<FileObject>();
        while (en.hasMoreElements()) {
            FileSystem fs = en.nextElement();
            FileObject fo = fs.find(aPackage, name, ext);
            if (fo == null) continue;
            ret.addElement(fo);
        }
        return ret.elements();
    }

    private void fireFileSystem(FileSystem fs, boolean add) {
        RepositoryEvent ev = new RepositoryEvent(this, fs, add);
        for (RepositoryListener list : new HashSet<RepositoryListener>(this.listeners.values())) {
            if (add) {
                list.fileSystemAdded(ev);
                continue;
            }
            list.fileSystemRemoved(ev);
        }
    }

    private void fireFileSystemReordered(int[] perm) {
        RepositoryReorderedEvent ev = new RepositoryReorderedEvent(this, perm);
        for (RepositoryListener list : new HashSet<RepositoryListener>(this.listeners.values())) {
            list.fileSystemPoolReordered(ev);
        }
    }

    @Deprecated
    public final void addRepositoryListener(RepositoryListener list) {
        this.listeners.put(list, list);
    }

    @Deprecated
    public final void removeRepositoryListener(RepositoryListener list) {
        this.listeners.remove(list);
    }

    private Object writeReplace() {
        return new Replacer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FCLSupport getFCLSupport() {
        Class<FCLSupport> clazz = FCLSupport.class;
        synchronized (FCLSupport.class) {
            if (this.fclSupport == null) {
                this.fclSupport = new FCLSupport();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fclSupport;
        }
    }

    @Deprecated
    public final void addFileChangeListener(FileChangeListener fcl) {
        this.getFCLSupport().addFileChangeListener(fcl);
    }

    @Deprecated
    public final void removeFileChangeListener(FileChangeListener fcl) {
        this.getFCLSupport().removeFileChangeListener(fcl);
    }

    static {
        ADD_FS = new ThreadLocal();
    }

    public static abstract class LayerProvider {
        protected abstract void registerLayers(Collection<? super URL> var1);

        protected final void refresh() {
            Repository.getDefault().refreshAdditionalLayers();
        }
    }

    private static final class MainFS
    extends MultiFileSystem
    implements LookupListener {
        private static final Lookup.Result<FileSystem> ALL = Lookup.getDefault().lookupResult(FileSystem.class);
        private static final FileSystem MEMORY = FileUtil.createMemoryFileSystem();
        private static final XMLFileSystem layers = new XMLFileSystem();

        public MainFS() {
            ALL.addLookupListener((LookupListener)this);
            this.refreshLayers();
        }

        final void refreshLayers() {
            ArrayList<URL> layerUrls = new ArrayList<URL>();
            try {
                this.provideLayer(layerUrls);
                layers.setXmlUrls(layerUrls.toArray(new URL[layerUrls.size()]));
                LOG.log(Level.FINE, "Loading classpath layers: {0}", layerUrls);
            }
            catch (Exception x) {
                LOG.log(Level.WARNING, "Setting layer URLs: " + layerUrls, x);
            }
            this.resultChanged(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void provideLayer(List<URL> layerUrls) throws IOException {
            ClassLoader l = Thread.currentThread().getContextClassLoader();
            if (l == null) {
                l = Repository.class.getClassLoader();
            }
            for (URL manifest : NbCollections.iterable(l.getResources("META-INF/MANIFEST.MF"))) {
                try (InputStream is = manifest.openStream();){
                    Manifest mani = new Manifest(is);
                    String layerLoc = mani.getMainAttributes().getValue("OpenIDE-Module-Layer");
                    if (layerLoc == null) continue;
                    URL layer = l.getResource(layerLoc);
                    if (layer != null) {
                        layerUrls.add(layer);
                        continue;
                    }
                    LOG.warning("No such layer: " + layerLoc);
                }
            }
            for (URL generatedLayer : NbCollections.iterable(l.getResources("META-INF/generated-layer.xml"))) {
                layerUrls.add(generatedLayer);
            }
            for (LayerProvider p : Lookup.getDefault().lookupAll(LayerProvider.class)) {
                ArrayList newURLs = new ArrayList();
                p.registerLayers(newURLs);
                layerUrls.addAll(newURLs);
            }
        }

        private static FileSystem[] computeDelegates() {
            ArrayList<FileSystem> arr = new ArrayList<FileSystem>();
            arr.add(MEMORY);
            for (FileSystem f : ALL.allInstances()) {
                if (Boolean.TRUE.equals(f.getRoot().getAttribute("fallback"))) continue;
                arr.add(f);
            }
            arr.add(layers);
            for (FileSystem f : ALL.allInstances()) {
                if (!Boolean.TRUE.equals(f.getRoot().getAttribute("fallback"))) continue;
                arr.add(f);
            }
            return arr.toArray(new FileSystem[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            Class<Repository> clazz = Repository.class;
            synchronized (Repository.class) {
                this.setDelegates(MainFS.computeDelegates());
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    private static class Replacer
    implements Serializable {
        static final long serialVersionUID = -3814531276726840241L;

        Replacer() {
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            Repository.getDefault().writeExternal(oos);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            Repository.getDefault().readExternal(ois);
        }

        public Object readResolve() {
            return Repository.getDefault();
        }
    }
}

