/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.report;

import oracle.dbtools.raptor.migration.applications.report.Summary;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorAppEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorArtifactEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorFileEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorListener;

public abstract class ReportEngine
implements FileProcessorListener {
    protected int m_fileId;
    private int m_currentApp;

    public abstract void generateReport(Summary var1);

    @Override
    public void raiseEvent(FileProcessorEvent fileProcessorEvent) {
        if (fileProcessorEvent instanceof FileProcessorAppEvent) {
            if (fileProcessorEvent.getState().equals("START")) {
                this.m_currentApp = this.createApplication((FileProcessorAppEvent)fileProcessorEvent);
            }
            if (fileProcessorEvent.getState().equals("FINISH")) {
                this.finishApplication((FileProcessorAppEvent)fileProcessorEvent);
            }
        } else if (fileProcessorEvent instanceof FileProcessorFileEvent) {
            if (fileProcessorEvent.getState().equals("START")) {
                this.m_fileId = this.createFile((FileProcessorFileEvent)fileProcessorEvent, this.m_currentApp);
            }
            if (fileProcessorEvent.getState().equals("FINISH")) {
                this.finishFile((FileProcessorFileEvent)fileProcessorEvent, this.m_fileId);
            }
        } else if (fileProcessorEvent instanceof FileProcessorArtifactEvent) {
            this.createArtifact((FileProcessorArtifactEvent)fileProcessorEvent, this.m_fileId);
        }
    }

    protected abstract void finishApplication(FileProcessorAppEvent var1);

    protected abstract void finishFile(FileProcessorFileEvent var1, int var2);

    protected abstract void createArtifact(FileProcessorArtifactEvent var1, int var2);

    protected abstract int createFile(FileProcessorFileEvent var1, int var2);

    protected abstract int createApplication(FileProcessorAppEvent var1);
}

