/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.AWXML.AW;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.AWObject;
import oracle.AWXML.Attribute;
import oracle.AWXML.AttributeProjection;
import oracle.AWXML.AttributeSourceExpression;
import oracle.AWXML.BaseObject;
import oracle.AWXML.DerivedMeasureInput;
import oracle.AWXML.Dimension;
import oracle.AWXML.DimensionMapGroup;
import oracle.AWXML.ExtendedProperty;
import oracle.AWXML.ExternalSourceExpression;
import oracle.AWXML.HierarchyLevelAssociation;
import oracle.AWXML.Level;
import oracle.AWXML.RestrictedSourceExpression;
import oracle.AWXML.SourceColumn;
import oracle.AWXML.WhereClause;

public class Hierarchy
extends AWObject
implements DerivedMeasureInput {
    private Vector m_hierarchyLevels = new Vector(0);
    private Attribute m_defaultOrder = null;
    private boolean m_isDefault = false;
    private String m_type = "LEVEL";

    protected Hierarchy() {
    }

    public Hierarchy(BaseObject baseObject) {
        super(baseObject);
        Vector vector = AW.getCurAW().getExtendedProperties();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            ExtendedProperty extendedProperty = (ExtendedProperty)iterator.next();
            if (!extendedProperty.getCreator().equalsIgnoreCase("SYSTEM") || !extendedProperty.getExtensionName().equalsIgnoreCase("GLOBALATTRIBUTE") || !(string2 = (string = extendedProperty.getReferencedObjectId()).substring(string.lastIndexOf(".") + 1)).equalsIgnoreCase("ATTRIBUTE")) continue;
            String string3 = this.getNamePart(1, extendedProperty.getReferencedObjectId());
            Dimension dimension = AW.getCurAW().findDimension(string3);
            Attribute attribute = dimension.FindAttribute(this.getLogicalNamePart(extendedProperty.getReferencedObjectId()));
            if (attribute == null || attribute.getOwner() != baseObject) continue;
            AttributeProjection attributeProjection = this.createAttributeProjection();
            attributeProjection.setAttribute(attribute);
        }
    }

    public String WriteToXML() {
        String string = null;
        string = Hierarchy.TAB() + this.WriteElementStart("Hierarchy");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + Hierarchy.TAB() + this.WriteElementEndTag("Hierarchy") + s_NEWLINE;
        }
        return string;
    }

    public String WriteAttributesToXML() {
        String string = super.WriteAttributesToXML();
        string = string == null ? this.WriteAsAttribute("isDefault", new Boolean(this.m_isDefault).toString()) : string + this.WriteAsAttribute("isDefault", new Boolean(this.m_isDefault).toString());
        string = string == null ? this.WriteAsAttribute("Type", this.m_type) : string + this.WriteAsAttribute("Type", this.m_type);
        return string;
    }

    public String WriteContentsToXML() {
        String string = super.WriteContentsToXML();
        Iterator iterator = this.m_hierarchyLevels.iterator();
        while (iterator.hasNext()) {
            HierarchyLevelAssociation hierarchyLevelAssociation = (HierarchyLevelAssociation)iterator.next();
            if (string == null) {
                string = hierarchyLevelAssociation.WriteToXML();
                continue;
            }
            string = string + hierarchyLevelAssociation.WriteToXML();
        }
        if (this.m_defaultOrder != null) {
            string = string == null ? this.WriteAsIDRef("DefaultOrder", this.m_defaultOrder) : string + this.WriteAsIDRef("DefaultOrder", this.m_defaultOrder);
        }
        return string;
    }

    public void setDefaultOrder(Attribute attribute) {
        this.m_defaultOrder = attribute;
    }

    public Attribute getDefaultOrder() {
        return this.m_defaultOrder;
    }

    public void setIsDefault(Boolean bl) {
        if (this.m_owner != null && bl.booleanValue()) {
            Iterator iterator = ((Dimension)this.m_owner).getHierarchies().iterator();
            while (iterator.hasNext()) {
                Hierarchy hierarchy = (Hierarchy)iterator.next();
                hierarchy.setIsDefaultFalse();
            }
        }
        this.m_isDefault = bl;
    }

    public void setIsDefault(boolean bl) {
        if (this.m_owner != null && bl) {
            Iterator iterator = ((Dimension)this.m_owner).getHierarchies().iterator();
            while (iterator.hasNext()) {
                Hierarchy hierarchy = (Hierarchy)iterator.next();
                hierarchy.setIsDefaultFalse();
            }
        }
        this.m_isDefault = bl;
    }

    private void setIsDefaultFalse() {
        this.m_isDefault = false;
    }

    public boolean getIsDefault() {
        return this.m_isDefault;
    }

    public void addHierarchyLevelAssociation(HierarchyLevelAssociation hierarchyLevelAssociation) {
        this.m_hierarchyLevels.add(hierarchyLevelAssociation);
        hierarchyLevelAssociation.setOwner(this);
    }

    public void addHierarchyLevelAssociationAfter(HierarchyLevelAssociation hierarchyLevelAssociation, BaseObject baseObject) {
        int n;
        if (baseObject instanceof HierarchyLevelAssociation) {
            n = this.m_hierarchyLevels.indexOf(baseObject);
            if (n <= -1) {
                throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "Hierarchy Levels"});
            }
        } else {
            throw new AWException("AWXML-ERR-NUM-900001", new Object[]{baseObject.getId(), "Hierarchy Levels"});
        }
        this.m_hierarchyLevels.add(n + 1, hierarchyLevelAssociation);
        hierarchyLevelAssociation.setOwner(this);
    }

    public void addHierarchyLevelAssociationBefore(HierarchyLevelAssociation hierarchyLevelAssociation, BaseObject baseObject) {
        int n;
        if (baseObject instanceof HierarchyLevelAssociation) {
            n = this.m_hierarchyLevels.indexOf(baseObject);
            if (n <= -1) {
                throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "Hierarchy Levels"});
            }
        } else {
            throw new AWException("AWXML-ERR-NUM-900001", new Object[]{baseObject.getId(), "Hierarchy Levels"});
        }
        this.m_hierarchyLevels.add(n, hierarchyLevelAssociation);
        hierarchyLevelAssociation.setOwner(this);
    }

    public void addHierarchyLevelAssociationFirst(HierarchyLevelAssociation hierarchyLevelAssociation) {
        this.m_hierarchyLevels.add(0, hierarchyLevelAssociation);
        hierarchyLevelAssociation.setOwner(this);
    }

    public void removeHierarchyLevelAssociation(HierarchyLevelAssociation hierarchyLevelAssociation) {
        this.m_hierarchyLevels.remove(hierarchyLevelAssociation);
    }

    public Vector getHierarchyLevels() {
        return this.m_hierarchyLevels;
    }

    public HierarchyLevelAssociation createHierarchyLevelAssociation() {
        HierarchyLevelAssociation hierarchyLevelAssociation = new HierarchyLevelAssociation(this);
        this.addHierarchyLevelAssociation(hierarchyLevelAssociation);
        hierarchyLevelAssociation.setName("HLA" + this.m_hierarchyLevels.size());
        Vector vector = AW.getCurAW().getExtendedProperties();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            ExtendedProperty extendedProperty = (ExtendedProperty)iterator.next();
            if (!extendedProperty.getCreator().equalsIgnoreCase("SYSTEM") || !extendedProperty.getExtensionName().equalsIgnoreCase("GLOBALATTRIBUTE") || !(string2 = (string = extendedProperty.getReferencedObjectId()).substring(string.lastIndexOf(".") + 1)).equalsIgnoreCase("ATTRIBUTE")) continue;
            String string3 = this.getNamePart(1, extendedProperty.getReferencedObjectId());
            Dimension dimension = AW.getCurAW().findDimension(string3);
            Attribute attribute = dimension.FindAttribute(this.getLogicalNamePart(extendedProperty.getReferencedObjectId()));
            if (attribute == null || this.getOwner() == null || attribute.getOwner() != this.getOwner()) continue;
            AttributeProjection attributeProjection = hierarchyLevelAssociation.createAttributeProjection();
            attributeProjection.setAttribute(attribute);
        }
        return hierarchyLevelAssociation;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String string) {
        if ((string = string.toUpperCase()).equals("VALUE") || string.equals("LEVEL")) {
            this.m_type = string;
        }
    }

    public HierarchyLevelAssociation createHierarchyLevelAssociationAfter(HierarchyLevelAssociation hierarchyLevelAssociation) {
        HierarchyLevelAssociation hierarchyLevelAssociation2 = new HierarchyLevelAssociation(this);
        this.addHierarchyLevelAssociationAfter(hierarchyLevelAssociation2, hierarchyLevelAssociation);
        hierarchyLevelAssociation2.setName("HLA" + this.m_hierarchyLevels.size());
        Vector vector = AW.getCurAW().getExtendedProperties();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            ExtendedProperty extendedProperty = (ExtendedProperty)iterator.next();
            if (!extendedProperty.getCreator().equalsIgnoreCase("SYSTEM") || !extendedProperty.getExtensionName().equalsIgnoreCase("GLOBALATTRIBUTE") || !(string2 = (string = extendedProperty.getReferencedObjectId()).substring(string.lastIndexOf(".") + 1)).equalsIgnoreCase("ATTRIBUTE")) continue;
            String string3 = this.getNamePart(1, extendedProperty.getReferencedObjectId());
            Dimension dimension = AW.getCurAW().findDimension(string3);
            Attribute attribute = dimension.FindAttribute(this.getLogicalNamePart(extendedProperty.getReferencedObjectId()));
            if (attribute == null || this.getOwner() == null || attribute.getOwner() != this.getOwner()) continue;
            AttributeProjection attributeProjection = hierarchyLevelAssociation2.createAttributeProjection();
            attributeProjection.setAttribute(attribute);
        }
        return hierarchyLevelAssociation2;
    }

    public HierarchyLevelAssociation createHierarchyLevelAssociationBefore(HierarchyLevelAssociation hierarchyLevelAssociation) {
        HierarchyLevelAssociation hierarchyLevelAssociation2 = new HierarchyLevelAssociation(this);
        this.addHierarchyLevelAssociationBefore(hierarchyLevelAssociation2, hierarchyLevelAssociation);
        hierarchyLevelAssociation2.setName("HLA" + this.m_hierarchyLevels.size());
        Vector vector = AW.getCurAW().getExtendedProperties();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            ExtendedProperty extendedProperty = (ExtendedProperty)iterator.next();
            if (!extendedProperty.getCreator().equalsIgnoreCase("SYSTEM") || !extendedProperty.getExtensionName().equalsIgnoreCase("GLOBALATTRIBUTE") || !(string2 = (string = extendedProperty.getReferencedObjectId()).substring(string.lastIndexOf(".") + 1)).equalsIgnoreCase("ATTRIBUTE")) continue;
            String string3 = this.getNamePart(1, extendedProperty.getReferencedObjectId());
            Dimension dimension = AW.getCurAW().findDimension(string3);
            Attribute attribute = dimension.FindAttribute(this.getLogicalNamePart(extendedProperty.getReferencedObjectId()));
            if (attribute == null || this.getOwner() == null || attribute.getOwner() != this.getOwner()) continue;
            AttributeProjection attributeProjection = hierarchyLevelAssociation2.createAttributeProjection();
            attributeProjection.setAttribute(attribute);
        }
        return hierarchyLevelAssociation2;
    }

    public HierarchyLevelAssociation createHierarchyLevelAssociationFirst() {
        HierarchyLevelAssociation hierarchyLevelAssociation = new HierarchyLevelAssociation(this);
        this.addHierarchyLevelAssociationFirst(hierarchyLevelAssociation);
        hierarchyLevelAssociation.setName("HLA" + this.m_hierarchyLevels.size());
        Vector vector = AW.getCurAW().getExtendedProperties();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            ExtendedProperty extendedProperty = (ExtendedProperty)iterator.next();
            if (!extendedProperty.getCreator().equalsIgnoreCase("SYSTEM") || !extendedProperty.getExtensionName().equalsIgnoreCase("GLOBALATTRIBUTE") || !(string2 = (string = extendedProperty.getReferencedObjectId()).substring(string.lastIndexOf(".") + 1)).equalsIgnoreCase("ATTRIBUTE")) continue;
            String string3 = this.getNamePart(1, extendedProperty.getReferencedObjectId());
            Dimension dimension = AW.getCurAW().findDimension(string3);
            Attribute attribute = dimension.FindAttribute(this.getLogicalNamePart(extendedProperty.getReferencedObjectId()));
            if (attribute == null || this.getOwner() == null || attribute.getOwner() != this.getOwner()) continue;
            AttributeProjection attributeProjection = hierarchyLevelAssociation.createAttributeProjection();
            attributeProjection.setAttribute(attribute);
        }
        return hierarchyLevelAssociation;
    }

    public String Create(AWConnection aWConnection) {
        BaseObject baseObject;
        Object var2_2 = null;
        Vector vector = new Vector(0);
        Object var4_4 = null;
        String string = "NA";
        if (this.m_defaultOrder != null) {
            string = this.quoteValue(this.m_defaultOrder.getId());
        }
        String string2 = "'NO'";
        if (this.m_isDefault) {
            string2 = "'YES'";
        }
        String string3 = "'NO'";
        if (this.m_type.equals("VALUE")) {
            string3 = "'YES'";
        }
        String string4 = aWConnection.executeCommand("call create_hierarchy(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + string2 + "," + string + "," + string3 + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-230000", new Object[]{this.getId(), this.m_commandResultText});
        }
        Iterator iterator = this.m_attributes.iterator();
        while (iterator.hasNext()) {
            baseObject = (AttributeProjection)iterator.next();
            ((AttributeProjection)baseObject).Create(aWConnection);
        }
        iterator = this.m_hierarchyLevels.iterator();
        while (iterator.hasNext()) {
            baseObject = (HierarchyLevelAssociation)iterator.next();
            ((HierarchyLevelAssociation)baseObject).Create(aWConnection);
        }
        iterator = this.getSourceMapGroup().iterator();
        while (iterator.hasNext()) {
            baseObject = (DimensionMapGroup)iterator.next();
            ((DimensionMapGroup)baseObject).Create(aWConnection);
        }
        return "success";
    }

    public String Alter(AWConnection aWConnection) {
        Object var2_2 = null;
        Vector vector = new Vector(0);
        Object var4_4 = null;
        String string = "NA";
        if (this.m_defaultOrder != null) {
            string = this.quoteValue(this.m_defaultOrder.getId());
        }
        String string2 = "'NO'";
        if (this.m_isDefault) {
            string2 = "'YES'";
        }
        String string3 = "'NO'";
        if (this.m_type.equals("VALUE")) {
            string3 = "'YES'";
        }
        String string4 = aWConnection.executeCommand("call alter_hierarchy(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + string2 + "," + string + "," + string3 + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-230002", new Object[]{this.getId(), this.m_commandResultText});
        }
        return "success";
    }

    public String Delete(AWConnection aWConnection) {
        String string = "success";
        string = aWConnection.executeCommand("call delete_hierarchy(" + this.quoteValue(this.getId()) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-230001", new Object[]{this.getId(), this.m_commandResultText});
        }
        return string;
    }

    public String Rename(AWConnection aWConnection, String string) {
        try {
            String string2 = this.getParentName();
            String string3 = aWConnection.getRoleBasedObjectName("HIERLIST", string2);
            aWConnection.renameDimensionValue(string3, this.getName(), string);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return "success";
    }

    public AttributeProjection findAttributeProjection(Attribute attribute) {
        AttributeProjection attributeProjection = null;
        for (int i = 0; i < this.m_attributes.size(); ++i) {
            AttributeProjection attributeProjection2 = (AttributeProjection)this.m_attributes.elementAt(i);
            if (attributeProjection2.getAttribute() != attribute) continue;
            attributeProjection = attributeProjection2;
            break;
        }
        return attributeProjection;
    }

    public boolean validateName(String string, String string2) {
        boolean bl = true;
        Iterator iterator = null;
        if (string2.toUpperCase().equals("ATTRIBUTE")) {
            iterator = this.m_attributes.iterator();
        }
        if (string2.toUpperCase().equals("HIERARCHYLEVELASSOCIATION")) {
            iterator = this.m_hierarchyLevels.iterator();
        }
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            BaseObject baseObject = (BaseObject)iterator2.next();
            if (!baseObject.getName().equalsIgnoreCase(string)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void readAWDefinitions(AWConnection aWConnection, boolean bl) {
        if (!this.m_dataRead) {
            Object object;
            Object object2;
            this.m_dataRead = true;
            aWConnection.limitDimension(AW.s_allLevelsObject, "TO", this.m_owner.getName() + ".AW$NONE.LEVEL");
            String string = aWConnection.getPhysicalObjectName("HIERDEF", this.getName(), this.m_owner.getName());
            String string2 = aWConnection.executeCommand("show obj(PROPERTY 'SORT_ATTRIBUTE' '" + string + "')");
            if (!string2.equalsIgnoreCase("NA")) {
                object2 = ((Dimension)this.m_owner).FindAttribute(string2);
                this.setDefaultOrder((Attribute)object2);
            }
            aWConnection.limitDimension(((Dimension)this.m_owner).getHierListObj(), "TO", this.getName());
            aWConnection.limitDimension(AW.s_allHierarchiesObject, "TO", this.getId());
            object2 = "NA";
            object2 = aWConnection.getValue(AW.getCurAW().getName() + "!" + ((Dimension)this.m_owner).getHierIsValueObj());
            if (((String)object2).equalsIgnoreCase("NA")) {
                this.setType("LEVEL");
            } else {
                this.setType("VALUE");
            }
            Vector vector = new Vector(0);
            if (AW.s_attrVisibleObject != null) {
                aWConnection.executeCommand("limit " + AW.getCurAW().getName() + "!" + AW.s_allAttributesObject + " TO " + AW.getCurAW().getName() + "!" + AW.s_attrVisibleObject + " EQ true");
                vector = aWConnection.getDimensionValues(AW.s_allAttributesObject);
            }
            Object object3 = vector.iterator();
            while (object3.hasNext()) {
                String string3 = (String)object3.next();
                string3 = string3.substring(0, string3.lastIndexOf("."));
                string3 = string3.substring(string3.lastIndexOf(".") + 1);
                object = this.createAttributeProjection();
                ((BaseObject)object).setName(string3);
                ((AttributeProjection)object).setAttribute(((Dimension)this.m_owner).findAttribute(string3));
            }
            this.readSourceMappings(aWConnection, this);
            object3 = aWConnection.getDimensionValues(((Dimension)this.m_owner).getHierLevelObj());
            for (int i = ((Vector)object3).size() - 1; i >= 0; --i) {
                object = (String)((Vector)object3).elementAt(i);
                Level level = ((Dimension)this.m_owner).FindLevel((String)object);
                HierarchyLevelAssociation hierarchyLevelAssociation = this.createHierarchyLevelAssociation();
                hierarchyLevelAssociation.setLevel(level);
                aWConnection.limitDimension(AW.s_allLevelsObject, "TO", level.getId());
                Vector vector2 = new Vector(0);
                if (AW.s_attrVisibleObject != null) {
                    aWConnection.executeCommand("limit " + AW.getCurAW().getName() + "!" + AW.s_allAttributesObject + " TO " + AW.getCurAW().getName() + "!" + AW.s_attrVisibleObject + " EQ true");
                    vector2 = aWConnection.getDimensionValues(AW.s_allAttributesObject);
                }
                Iterator iterator = vector2.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    string4 = string4.substring(0, string4.lastIndexOf("."));
                    string4 = string4.substring(string4.lastIndexOf(".") + 1);
                    AttributeProjection attributeProjection = hierarchyLevelAssociation.createAttributeProjection();
                    attributeProjection.setName(string4);
                    attributeProjection.setAttribute(((Dimension)this.m_owner).findAttribute(string4));
                }
                this.readSourceMappings(aWConnection, hierarchyLevelAssociation);
            }
        }
    }

    private void readSourceMappings(AWConnection aWConnection, AWObject aWObject) {
        Date date = new Date();
        Vector vector = new Vector(0);
        if (AW.s_mapGroupListObject != null) {
            aWConnection.limitDimensionBasedOnData(AW.s_mapGroupListObject, "TO", AW.s_mapKeyObject, "NE", "NA");
            vector = aWConnection.getDimensionValues(AW.s_mapGroupListObject);
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            BaseObject baseObject;
            Object object;
            Object object2;
            Object object3;
            DimensionMapGroup dimensionMapGroup = aWObject.createSourceDimensionMapGroup();
            String string = (String)iterator.next();
            aWConnection.limitDimension(AW.s_mapGroupListObject, "TO", string);
            String string2 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_mapKeyObject);
            dimensionMapGroup.setName(dimensionMapGroup.getLogicalNamePart(string));
            if (!string2.toUpperCase().equals("NA")) {
                object3 = dimensionMapGroup.CreateKeyMap();
                if (string2.indexOf("?") > 0) {
                    object2 = string2.substring(string2.indexOf("?") + 1);
                    string2 = string2.substring(0, string2.indexOf("?"));
                    object = ((RestrictedSourceExpression)object3).createRestriction();
                    ((WhereClause)object).setWhereClause((String)object2);
                }
                if (string2.indexOf(",") > 0) {
                    object2 = new StringTokenizer(string2, ",");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken();
                        baseObject = ((ExternalSourceExpression)object3).CreateSourceColumn();
                        ((SourceColumn)baseObject).setColumn((String)object);
                    }
                } else {
                    object2 = ((ExternalSourceExpression)object3).CreateSourceColumn();
                    ((SourceColumn)object2).setColumn(string2);
                }
            }
            if (!(aWObject instanceof Dimension)) {
                try {
                    string2 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_mapParentObject);
                    if (!string2.equals("NA")) {
                        object3 = dimensionMapGroup.CreateParentMap();
                        if (string2.indexOf(",") > 0) {
                            object2 = new StringTokenizer(string2, ",");
                            while (((StringTokenizer)object2).hasMoreTokens()) {
                                object = ((StringTokenizer)object2).nextToken();
                                baseObject = ((ExternalSourceExpression)object3).CreateSourceColumn();
                                ((SourceColumn)baseObject).setColumn((String)object);
                            }
                        } else {
                            object2 = ((ExternalSourceExpression)object3).CreateSourceColumn();
                            ((SourceColumn)object2).setColumn(string2);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                aWConnection.limitDimensionBasedOnData(AW.s_allAttributesObject, "TO", AW.s_mapAttrObject, "NE", "NA");
                object3 = aWConnection.getDimensionValues(AW.s_allAttributesObject);
                object2 = ((Vector)object3).iterator();
                while (object2.hasNext()) {
                    Object object4;
                    Object object5;
                    object = (String)object2.next();
                    object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                    object = ((String)object).substring(((String)object).lastIndexOf(".") + 1);
                    baseObject = ((Dimension)this.m_owner).findAttribute((String)object);
                    string2 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_mapAttrObject + "(" + AW.getCurAW().getName() + "!" + AW.s_allAttributesObject + " '" + baseObject.getId() + "')");
                    if (string2.indexOf(":") < 0) {
                        object5 = dimensionMapGroup.CreateAttributeMap();
                        if (aWObject instanceof Dimension) {
                            ((AttributeSourceExpression)object5).setTargetObject(baseObject);
                        } else {
                            object4 = null;
                            if (aWObject instanceof Level) {
                                object4 = ((Level)aWObject).findAttributeProjection((Attribute)baseObject);
                            }
                            if (aWObject instanceof Hierarchy) {
                                object4 = ((Hierarchy)aWObject).findAttributeProjection((Attribute)baseObject);
                            }
                            if (aWObject instanceof HierarchyLevelAssociation) {
                                object4 = ((HierarchyLevelAssociation)aWObject).findAttributeProjection((Attribute)baseObject);
                            }
                            ((AttributeSourceExpression)object5).setTargetObject((BaseObject)object4);
                        }
                        object4 = ((ExternalSourceExpression)object5).CreateSourceColumn();
                        ((SourceColumn)object4).setColumn(string2);
                        continue;
                    }
                    object5 = new StringTokenizer(string2, "\n");
                    while (((StringTokenizer)object5).hasMoreTokens()) {
                        BaseObject baseObject2;
                        object4 = ((StringTokenizer)object5).nextToken();
                        String string3 = ((String)object4).substring(0, ((String)object4).indexOf(":"));
                        String string4 = ((String)object4).substring(((String)object4).lastIndexOf(":") + 1);
                        AttributeSourceExpression attributeSourceExpression = dimensionMapGroup.CreateAttributeMap(string3);
                        if (aWObject instanceof Dimension) {
                            attributeSourceExpression.setTargetObject(baseObject);
                        } else {
                            baseObject2 = null;
                            if (aWObject instanceof Level) {
                                baseObject2 = ((Level)aWObject).findAttributeProjection((Attribute)baseObject);
                            }
                            if (aWObject instanceof Hierarchy) {
                                baseObject2 = ((Hierarchy)aWObject).findAttributeProjection((Attribute)baseObject);
                            }
                            if (aWObject instanceof HierarchyLevelAssociation) {
                                baseObject2 = ((HierarchyLevelAssociation)aWObject).findAttributeProjection((Attribute)baseObject);
                            }
                            attributeSourceExpression.setTargetObject(baseObject2);
                        }
                        baseObject2 = attributeSourceExpression.CreateSourceColumn();
                        baseObject2.setColumn(string4);
                    }
                }
            }
            catch (Exception exception) {
            }
        }
    }
}

