/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.javatools.datatransfer;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.bm.javatools.datatransfer.AbstractPartitionSelector;
import oracle.bm.javatools.datatransfer.Flavor;
import oracle.bm.javatools.datatransfer.FlavorSelector;
import oracle.bm.javatools.datatransfer.LeafNode;
import oracle.bm.javatools.datatransfer.SelectorNode;
import oracle.bm.javatools.util.MultivaluedMap;

public class PartitionNode<T>
implements SelectorNode<T> {
    private ArrayList<T> m_localHandlers = new ArrayList();
    private AbstractPartitionSelector m_selector;
    private HashMap<Object, SelectorNode<T>> m_children = new HashMap();

    public PartitionNode(AbstractPartitionSelector selector) {
        this.m_selector = selector;
    }

    @Override
    public void addHandler(Flavor flavor, T handler) {
        this.m_selector.addHandler(this, flavor, handler);
    }

    @Override
    public void getHandlers(Flavor flavor, MultivaluedMap<T, Flavor> handlers) {
        this.m_selector.getHandlers(this, flavor, handlers);
    }

    void addLocalHandler(T handler) {
        this.m_localHandlers.add(handler);
    }

    void addChildHandler(Object discriminator, Flavor flavor, T handler) {
        SelectorNode<T> childNode = this.m_children.get(discriminator);
        if (childNode == null) {
            FlavorSelector selector = this.m_selector.findChildSelector(discriminator);
            childNode = selector == null ? new LeafNode() : selector.createSelectorNode();
            this.m_children.put(discriminator, childNode);
        }
        childNode.addHandler(flavor, handler);
    }

    void addLocalHandlers(Flavor flavor, MultivaluedMap<T, Flavor> handlers) {
        for (T handler : this.m_localHandlers) {
            handlers.put(handler, flavor);
        }
    }

    void addChildHandlers(Object discriminator, Flavor flavor, MultivaluedMap<T, Flavor> handlers) {
        SelectorNode<T> childNode = this.m_children.get(discriminator);
        if (childNode != null) {
            childNode.getHandlers(flavor, handlers);
        }
    }
}

