/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.im.InputMethodRequests;
import java.io.IOException;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.lwAWT.lwText.LWTextComponent;
import oracle.ewt.lwAWT.lwText.TextPosition;
import oracle.ewt.lwAWT.lwText.im.InputMethodManager;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;
import oracle.ewt.util.stringFilter.IdentityStringFilter;
import oracle.ewt.util.stringFilter.StringFilter;

public abstract class LWCommonText
extends LWTextComponent {
    public static final int ALIGNMENT_DEFAULT = 0;
    public static final int ALIGNMENT_LEFT = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_CENTER = 3;
    private static final int _DEFAULT_COLUMNS = 20;
    private StringFilter _valueFilter = IdentityStringFilter.getStringFilter();
    private int _maximumChars = Integer.MAX_VALUE;
    private int _columns;
    private Adjustable _hAdjustable;
    private TextPosition _dropPos;
    private transient boolean _validTextLayout = false;
    private InputMethodManager _imeMgr;

    protected LWCommonText() {
        this(20);
    }

    protected LWCommonText(int n) {
        this._init(n);
        this._imeMgr = new InputMethodManager(this);
    }

    public synchronized void invalidateTextLayout() {
        this._validTextLayout = false;
    }

    public synchronized void validateTextLayout() {
        this._validTextLayout = true;
    }

    public boolean isValidTextlayout() {
        return this._validTextLayout;
    }

    public InputMethodRequests getInputMethodRequests() {
        return this._imeMgr.getInputMethodRequests();
    }

    InputMethodManager getInputMethodManager() {
        return this._imeMgr;
    }

    public void setColumns(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (this._columns != n) {
            this._columns = n;
            this.invalidate();
        }
    }

    public int getColumns() {
        return this._columns;
    }

    public void setMaximumChars(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maximumChars must be >= 0");
        }
        if (this._maximumChars != n) {
            this._maximumChars = n;
            if (n < this.getTextLength()) {
                this.__setTextWithoutCommit(this.getText().substring(0, n));
            }
        }
    }

    public int getMaximumChars() {
        return this._maximumChars;
    }

    public void setValueStringFilter(StringFilter stringFilter) {
        if (stringFilter == null) {
            stringFilter = IdentityStringFilter.getStringFilter();
        }
        if (this._valueFilter != stringFilter) {
            this._valueFilter = stringFilter;
            this.__setTextWithoutCommit(this.getText());
        }
    }

    public StringFilter getValueStringFilter() {
        return this._valueFilter;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean isHScrollable() {
        return true;
    }

    public Adjustable getHAdjustable() {
        return this._hAdjustable;
    }

    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        if (!this.isHScrollable() || this._hAdjustable != null) {
            throw new ScrollableException();
        }
        this._hAdjustable = adjustable;
    }

    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (adjustable == this._hAdjustable) {
            this._hAdjustable = null;
        } else {
            super.detachAdjustable(adjustable);
        }
    }

    public boolean isOKToPaste(Transferable transferable) {
        if (super.isOKToPaste(transferable)) {
            try {
                String string = this.getPasteString(transferable);
                return this.getTextLength() + string.length() + this.getSelectionStart() - this.getSelectionEnd() <= this.getMaximumChars();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    protected int getRepaintFlags() {
        return super.getRepaintFlags() | 0x800 | 0x4000;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        int n = InputEventUtils.getMods(keyEvent);
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (n2 == 4 ? (n & 4) != 0 : (n & 8) != 0 && (n & 2) == 0) {
            return;
        }
        if (!keyEvent.isConsumed()) {
            char c;
            int n3 = keyEvent.getID();
            boolean bl = n3 == 401;
            boolean bl2 = n3 == 400;
            boolean bl3 = n3 == 402;
            boolean bl4 = false;
            int n4 = keyEvent.getKeyCode();
            switch (n4) {
                case 37: 
                case 39: {
                    if (bl) {
                        char c2 = c = n4 == 37 ? (char)'\uffffffff' : '\u0001';
                        if (this.getActualReadingDirection() == 2) {
                            c *= -1;
                        }
                        this._moveCursorXRelative(c, keyEvent.isShiftDown(), keyEvent.isControlDown());
                    }
                    bl4 = true;
                    break;
                }
                case 8: 
                case 127: {
                    if (bl && (c = (char)(this.deleteText(n4 == 8) ? 1 : 0)) != '\u0000') {
                        this.processEvent(new TextEvent(this, 900));
                    }
                    bl4 = true;
                }
            }
            c = keyEvent.getKeyChar();
            c = this.translateKeyChar(c);
            if (c != StringUtils.CHAR_UNDEFINED) {
                int n5 = this.getSelectionStart();
                int n6 = this.getSelectionEnd();
                if (bl2 && this.isEditable() && this.getMaximumChars() >= this.getTextLength() + 1 + (n5 - n6)) {
                    Rectangle rectangle = this.replaceRangeDamage(String.valueOf(c), n5, n6, true);
                    if (rectangle != null) {
                        this.paintText(rectangle, true);
                    }
                    this.deliverTextChangedIfNecessary(rectangle);
                } else if (bl2) {
                    Toolkit.getDefaultToolkit().beep();
                }
                if (bl2 || !keyEvent.isControlDown() && !LocaleUtils.isDeadKey(keyEvent)) {
                    bl4 = true;
                }
            }
            if (n4 == 16 && keyEvent.isControlDown() || n4 == 17 && keyEvent.isShiftDown()) {
                if (bl3) {
                    this._toggleDirection();
                }
                bl4 = true;
            }
            if (bl4) {
                keyEvent.consume();
            }
        }
    }

    protected String paramString() {
        int n;
        int n2;
        String string = super.paramString();
        string = string + ", " + this.getColumns() + " columns";
        StringFilter stringFilter = this.getValueStringFilter();
        if (stringFilter != null && stringFilter != this && stringFilter != IdentityStringFilter.getStringFilter()) {
            string = string + ", " + stringFilter.toString();
        }
        if ((n2 = this.getMaximumChars()) != Integer.MAX_VALUE) {
            string = string + ", " + n2 + " characters max";
        }
        if ((n = this.getActualAlignment()) != 1) {
            String string2 = n == 2 ? "right" : "center";
            string = string + string2 + " aligned";
        }
        return string;
    }

    abstract TextPosition canvasToPosition(int var1, int var2);

    void setDropPosition(TextPosition textPosition) {
        TextPosition textPosition2 = this._dropPos;
        this._dropPos = textPosition;
        Rectangle rectangle = null;
        if (textPosition != null) {
            Point point = this.scrollSelectionIntoView(textPosition);
            if (point != null) {
                this.setCanvasOrigin(point.x, point.y);
            }
            if (textPosition2 != null) {
                if (textPosition2.getIndex() != textPosition.getIndex()) {
                    rectangle = this.getSelectionBounds(textPosition2, textPosition);
                }
            } else {
                rectangle = this.getSelectionBounds(textPosition, textPosition);
            }
        } else {
            Point point;
            TextPosition textPosition3 = this.getSelectionStartPos();
            if (textPosition3 != null && (point = this.scrollSelectionIntoView(textPosition3)) != null) {
                this.setCanvasOrigin(point.x, point.y);
            }
            if (textPosition2 != null) {
                rectangle = this.getSelectionBounds(textPosition2, textPosition2);
            }
        }
        if (rectangle != null) {
            this.repaintCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    TextPosition getDropPosition() {
        return this._dropPos;
    }

    abstract boolean _isBIDIEnabled();

    abstract int findWordBoundary(int var1, boolean var2);

    char translateKeyChar(char c) {
        switch (c) {
            case '\b': 
            case '\u007f': {
                return this.isEditable() ? StringUtils.CHAR_UNDEFINED : c;
            }
            case '\u0003': 
            case '\u0016': 
            case '\u0018': {
                return StringUtils.CHAR_UNDEFINED;
            }
        }
        if (c != '\n' && Character.isISOControl(c)) {
            return StringUtils.CHAR_UNDEFINED;
        }
        return c;
    }

    static int findWordStart(char[] cArray, int n) {
        int n2 = cArray.length;
        if (n <= 0 || n2 == 0) {
            return 0;
        }
        if (n > n2) {
            n = n2;
        }
        --n;
        while (n >= 0 && Character.isLetterOrDigit(cArray[n])) {
            --n;
        }
        return n + 1;
    }

    static int findWordEnd(char[] cArray, int n) {
        if (n < 0) {
            return 0;
        }
        int n2 = cArray.length;
        if (n >= n2) {
            return n2;
        }
        while (n < n2 && Character.isLetterOrDigit(cArray[n])) {
            ++n;
        }
        while (n < n2 && Character.isWhitespace(cArray[n])) {
            ++n;
        }
        return n;
    }

    synchronized void growSelection(TextPosition textPosition) {
        TextPosition textPosition2 = this.isSelectionAnchoredAtStart() ? this.getSelectionStartPos() : this.getSelectionEndPos();
        TextPosition textPosition3 = textPosition;
        TextPosition textPosition4 = textPosition2;
        if (textPosition4.getIndex() > textPosition3.getIndex()) {
            textPosition3 = textPosition4;
            textPosition4 = textPosition;
        }
        this.select(textPosition4, textPosition3, textPosition);
        if (textPosition2 != textPosition4) {
            this.setSelectionAnchoredAtStart(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean deleteText(boolean bl) {
        Rectangle rectangle = null;
        LWCommonText lWCommonText = this;
        // MONITORENTER : lWCommonText
        int n = this.getTextLength();
        if (n != 0 && this.isEditable()) {
            int n2 = this.getSelectionStart();
            int n3 = this.getSelectionEnd();
            int n4 = n2;
            int n5 = n3;
            if (n2 == n3) {
                if (bl && n2 != 0 || !bl && n3 != n) {
                    if (bl) {
                        --n4;
                    } else {
                        ++n5;
                    }
                } else {
                    // MONITOREXIT : lWCommonText
                    return false;
                }
            }
            rectangle = this.replaceRangeDamage(null, n4, n5, false);
            // MONITOREXIT : lWCommonText
            if (rectangle == null) return true;
            this.paintText(rectangle, true);
            return true;
        }
        // MONITOREXIT : lWCommonText
        return false;
    }

    Color __getDisabledTextColor() {
        UIDefaults uIDefaults = this.getUIDefaults();
        Color color = uIDefaults.getColor(LookAndFeel.TEXT_INACTIVE_TEXT);
        if (this.getFill() != this.getUI().getDefaultFill(this)) {
            int n = ColorUtils.getApproximateLuminance(this.getBackground());
            int n2 = ColorUtils.getApproximateLuminance(color);
            int n3 = n - n2;
            boolean bl = false;
            if (n3 <= 20) {
                n3 = -n3;
                bl = true;
            }
            if (n3 < 100) {
                Object object = bl ? LookAndFeel.NORMAL_INTENSITY : LookAndFeel.VERY_DARK_INTENSITY;
                color = uIDefaults.getColor(object);
            }
        }
        return color;
    }

    String replaceRangeFilter(String string, int n, int n2) {
        string = this.getValueStringFilter().convertString(string);
        int n3 = this.getMaximumChars();
        int n4 = this.getTextLength();
        int n5 = n4 + string.length() - (n2 - n);
        if (n5 > n3) {
            int n6 = n3 - (n4 - (n2 - n));
            string = string.substring(0, n6);
        }
        return string;
    }

    void __endComposition() {
        this._imeMgr.endComposition();
    }

    private void _toggleDirection() {
        if (this._isBIDIEnabled()) {
            if (this.getActualReadingDirection() == 2) {
                this.setReadingDirection(1);
            } else {
                this.setReadingDirection(2);
            }
        }
    }

    private void _init(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("columns must be >= 0");
        }
        this._columns = n;
        this.enableEvents(12L);
    }

    void _moveCursorAbsolute(TextPosition textPosition, boolean bl) {
        if (bl) {
            this.growSelection(textPosition);
        } else {
            this.setCaretPosition(textPosition);
        }
    }

    private void _moveCursorXRelative(int n, boolean bl, boolean bl2) {
        int n2;
        TextPosition textPosition;
        TextPosition textPosition2 = textPosition = this.isSelectionAnchoredAtStart() ? this.getSelectionEndPos() : this.getSelectionStartPos();
        int n3 = !bl2 ? textPosition.getIndex() + n : this.findWordBoundary(textPosition.getIndex(), n > 0);
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > (n2 = this.getTextLength())) {
            n3 = n2;
        }
        this._moveCursorAbsolute(this.getPosition(n3), bl);
    }
}

