/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.laf.oracle.OracleButtonPainter;
import oracle.ewt.laf.oracle.OracleComponentUI;
import oracle.ewt.laf.oracle.OracleUIUtils;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.AlignmentPainter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.PainterJoiner;
import oracle.ewt.painter.ThreeDSeparatorPainter;
import oracle.ewt.plaf.ToolBarUI;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarItem;

public class OracleToolBarUI
extends OracleComponentUI
implements ToolBarUI {
    private static final int _IMAGESET_BIT = 1;
    private static final int _TEXT_BIT = 2;
    private static final int _HORIZONTAL_BIT = 4;
    private static final int _MULTIPLE_IMAGE_BIT = 8;
    private static Painter[] _sContentPainters = new Painter[16];
    private static Painter _sVerticalSeparator;
    private static Painter _sHorizontalSeparator;
    private static BorderPainter _sBorderPainter;
    private static Painter _sVertBlankSeparator;
    private static Painter _sHorzBlankSeparator;
    private BorderPainter _sHorizontalBorder;
    private BorderPainter _sVerticalBorder;

    public OracleToolBarUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    public BorderPainter getDefaultBorderPainter(LWComponent lWComponent) {
        if (((ToolBar)lWComponent).isHorizontal()) {
            if (this._sHorizontalBorder == null) {
                this._sHorizontalBorder = this.getUIDefaults(lWComponent).getBorderPainter(TOOLBAR_HORIZONTAL_BORDER);
            }
            return this._sHorizontalBorder;
        }
        if (this._sVerticalBorder == null) {
            this._sVerticalBorder = this.getUIDefaults(lWComponent).getBorderPainter(TOOLBAR_VERTICAL_BORDER);
        }
        return this._sVerticalBorder;
    }

    public Painter getButtonContentPainter(LWComponent lWComponent, ToolBarItem toolBarItem) {
        Painter painter;
        ImageSet imageSet;
        int n = 0;
        if (((ToolBar)lWComponent).isHorizontal()) {
            n += 4;
        }
        if (toolBarItem.getPaintData(PaintContext.LABEL_KEY) != null) {
            n += 2;
        }
        if ((imageSet = (ImageSet)toolBarItem.getPaintData(PaintContext.IMAGESET_KEY)) != null) {
            ++n;
            if (!(imageSet instanceof SynthesizingImageSet)) {
                n += 8;
            }
        }
        if ((painter = _sContentPainters[n]) == null) {
            OracleToolBarUI._sContentPainters[n] = painter = new AlignmentPainter(new FixedBorderPainter(this._createContentPainter(n), 0, 2, 0, 2));
        }
        return painter;
    }

    public BorderPainter getButtonBorderPainter(LWComponent lWComponent) {
        return NullPainter.getPainter();
    }

    public Painter getSeparatorPainter(LWComponent lWComponent, boolean bl) {
        boolean bl2 = ((ToolBar)lWComponent).isHorizontal();
        if (bl) {
            if (bl2) {
                if (_sVerticalSeparator == null) {
                    _sVerticalSeparator = new FixedBorderPainter(new ThreeDSeparatorPainter(true, false, true), 4, 5, 4, 5);
                }
                return _sVerticalSeparator;
            }
            if (_sHorizontalSeparator == null) {
                _sHorizontalSeparator = new FixedBorderPainter(new ThreeDSeparatorPainter(true, true, true), 5, 4, 5, 4);
            }
            return _sHorizontalSeparator;
        }
        if (bl2) {
            return _sVertBlankSeparator;
        }
        return _sHorzBlankSeparator;
    }

    public int getBaseImageState(LWComponent lWComponent) {
        return (Integer)this.getUIDefaults(lWComponent).get(BASE_IMAGE_STATE);
    }

    private Painter _createContentPainter(int n) {
        boolean bl = (n & 4) != 0;
        boolean bl2 = (n & 8) == 0;
        switch (n &= 0xFFFFFFF3) {
            default: {
                return null;
            }
            case 1: {
                return new OracleButtonPainter(OracleUIUtils.getImageSetPainter(), true, true, bl2);
            }
            case 2: {
                return new OracleButtonPainter(new FixedBorderPainter(this._createContentTextPainter(bl), 1, 2, 1, 2), true, true, true);
            }
            case 3: 
        }
        return new PainterJoiner(this._createContentTextPainter(bl), new OracleButtonPainter(OracleUIUtils.getImageSetPainter(), true, true, bl2), 3);
    }

    private Painter _createContentTextPainter(boolean bl) {
        if (bl) {
            return new FixedBorderPainter(OracleUIUtils.getSingleLineTextPainter(), 0, 4, 0, 4, false);
        }
        return OracleUIUtils.getSingleLineTextPainter();
    }

    static {
        _sVertBlankSeparator = new FixedBorderPainter(null, 8, 12, 0, 0);
        _sHorzBlankSeparator = new FixedBorderPainter(null, 12, 8, 0, 0);
    }
}

