/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import java.awt.Color;
import java.awt.Graphics;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.painter.AbstractBorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.util.ImmInsets;

public class GenericInsetBorderPainter
extends AbstractBorderPainter {
    private static final ImmInsets _SMALL_INSETS = new ImmInsets(1, 1, 1, 1);
    private static final ImmInsets _NORMAL_INSETS = new ImmInsets(2, 2, 2, 2);
    private boolean _isRaised;
    private boolean _isSmall;

    public GenericInsetBorderPainter() {
        this(null, false, false);
    }

    public GenericInsetBorderPainter(boolean bl) {
        this(null, bl, false);
    }

    public GenericInsetBorderPainter(Painter painter, boolean bl, boolean bl2) {
        super(painter);
        this._isRaised = bl;
        this._isSmall = bl2;
    }

    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        if (this._isSmall) {
            return _SMALL_INSETS;
        }
        return _NORMAL_INSETS;
    }

    protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        Color color = graphics.getColor();
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        Color color2 = uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
        Color color3 = uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW);
        Color color4 = uIDefaults.getColor(LookAndFeel.CONTROL_HIGHLIGHT);
        Color color5 = uIDefaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
        if (this._isRaised) {
            if (this._isSmall) {
                Color color6 = color2;
                color2 = color3;
                color3 = color6;
            } else {
                Color color7 = color2;
                color2 = color5;
                color5 = color7;
                color7 = color3;
                color3 = color4;
                color4 = color7;
            }
        }
        graphics.setColor(color2);
        graphics.drawLine(n, n6, n5, n6);
        graphics.drawLine(n5, n2, n5, n6);
        graphics.setColor(color3);
        graphics.drawLine(n, n2, --n5, n2);
        graphics.drawLine(n, n2, n, --n6);
        if (!this._isSmall) {
            graphics.setColor(color4);
            graphics.drawLine(++n, n6, n5, n6);
            graphics.drawLine(n5, ++n2, n5, n6);
            graphics.setColor(color5);
            graphics.drawLine(n, n2, --n5, n2);
            graphics.drawLine(n, n2, n, --n6);
        }
        graphics.setColor(color);
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return super.getRepaintFlags(paintContext) | 1 | 0x80;
    }

    protected boolean isBorderTransparent(PaintContext paintContext) {
        return false;
    }
}

