/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.jdeveloper.java.classpath.ClasspathTreeVisitOptions;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.ArrayClassLocator;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;

public final class JarClassPathClassLocator
extends BaseClassLocator {
    private final URLKey jarURL;
    private final BaseClassLocator jarLocator;
    private JarClassPathClassLocator parent;
    private BaseClassLocator classPathLocator;

    public JarClassPathClassLocator(URL rootURL, BaseClassLocator jarLocator) {
        this.jarURL = URLKey.getInstance((URL)rootURL).intern();
        this.jarLocator = jarLocator;
    }

    private synchronized void setParent(JarClassPathClassLocator parent) {
        this.parent = parent;
    }

    private synchronized JarClassPathClassLocator getParent() {
        return this.parent;
    }

    @Override
    public void getPackages(String packagePrefix, Collection<String> out) {
        this.jarLocator.getPackages(packagePrefix, out);
        this.getClassPathLocator().getPackages(packagePrefix, out);
    }

    @Override
    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.jarLocator.getPackages(packagePrefix, out);
        this.getClassPathLocatorInterruptibly().getPackages(packagePrefix, out);
    }

    @Override
    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        this.jarLocator.getClassesInPackage(packagePrefix, out);
        this.getClassPathLocator().getClassesInPackage(packagePrefix, out);
    }

    @Override
    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.jarLocator.getClassesInPackage(packagePrefix, out);
        this.getClassPathLocatorInterruptibly().getClassesInPackage(packagePrefix, out);
    }

    @Override
    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        this.jarLocator.getAllClasses(out, filter);
        this.getClassPathLocator().getAllClasses(out, filter);
    }

    @Override
    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        this.jarLocator.getAllClasses(out, filter);
        this.getClassPathLocatorInterruptibly().getAllClasses(out, filter);
    }

    @Override
    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        this.jarLocator.getAllPackages(out, filter);
        this.getClassPathLocator().getAllPackages(out, filter);
    }

    @Override
    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        this.jarLocator.getAllPackages(out, filter);
        this.getClassPathLocatorInterruptibly().getAllPackages(out, filter);
    }

    @Override
    public void buildIndex() {
        this.jarLocator.buildIndex();
        this.getClassPathLocator().buildIndex();
    }

    @Override
    public void buildIndexInterruptibly() throws InterruptedException {
        this.jarLocator.buildIndex();
        this.getClassPathLocatorInterruptibly().buildIndex();
    }

    @Override
    public URL getURL(String fqClassName) {
        URL url = this.jarLocator.getURL(fqClassName);
        if (url == null) {
            url = this.getClassPathLocator().getURL(fqClassName);
        }
        return url;
    }

    @Override
    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        URL url = this.jarLocator.getURL(fqClassName);
        if (url == null) {
            url = this.getClassPathLocatorInterruptibly().getURL(fqClassName);
        }
        return url;
    }

    @Override
    public URL getSourceURL(String fqClassName) {
        return null;
    }

    @Override
    public URL getClassURL(String fqClassName) {
        URL url = this.jarLocator.getClassURL(fqClassName);
        if (url == null) {
            url = this.getClassPathLocator().getClassURL(fqClassName);
        }
        return url;
    }

    @Override
    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        URL url = this.jarLocator.getClassURL(fqClassName);
        if (url == null) {
            url = this.getClassPathLocatorInterruptibly().getClassURL(fqClassName);
        }
        return url;
    }

    @Override
    public URL getResourceURL(String resourceName) {
        URL url = this.jarLocator.getResourceURL(resourceName);
        if (url == null) {
            url = this.getClassPathLocator().getResourceURL(resourceName);
        }
        return url;
    }

    private BaseClassLocator getClassPathLocator() {
        try {
            return this.getClassPathLocator(false);
        }
        catch (InterruptedException e) {
            return EMPTY_LOCATOR;
        }
    }

    private BaseClassLocator getClassPathLocatorInterruptibly() throws InterruptedException {
        return this.getClassPathLocator(true);
    }

    private synchronized BaseClassLocator getClassPathLocator(boolean checkInterrupt) throws InterruptedException {
        if (this.classPathLocator == null) {
            try {
                if (checkInterrupt) {
                    JarClassPathClassLocator.checkInterrupt();
                }
                Collection classPath = URLKey.asURLKeys((Collection)JarUtil.getClassPathURLs((URL)this.jarURL.toURL()));
                this.removeParents(classPath);
                int size = classPath.size();
                if (size == 0) {
                    this.classPathLocator = EMPTY_LOCATOR;
                } else {
                    ClassLocatorFactory factory = ClassLocatorFactory.getInstance();
                    ArrayList<BaseClassLocator> locators = new ArrayList<BaseClassLocator>(size);
                    for (URLKey key : classPath) {
                        URL url;
                        boolean exists;
                        if (checkInterrupt) {
                            JarClassPathClassLocator.checkInterrupt();
                        }
                        if (!(exists = JarUtil.isJarURL((URL)(url = key.toURL())) ? URLFileSystem.exists((URL)JarUtil.getJarFileURL((URL)url)) : URLFileSystem.exists((URL)url))) continue;
                        BaseClassLocator locator = BaseClassLocator.ensureValid(factory.getClassLocator(url));
                        if (locator instanceof JarClassPathClassLocator) {
                            ((JarClassPathClassLocator)locator).setParent(this);
                        }
                        locators.add(locator);
                    }
                    size = locators.size();
                    this.classPathLocator = size == 0 ? EMPTY_LOCATOR : (size == 1 ? (BaseClassLocator)locators.get(0) : new ArrayClassLocator(locators.toArray(new BaseClassLocator[size])));
                }
            }
            catch (IOException e) {
                this.classPathLocator = EMPTY_LOCATOR;
            }
        }
        return this.classPathLocator;
    }

    private void removeParents(Collection<URLKey> classPath) {
        classPath.remove(this.jarURL);
        for (JarClassPathClassLocator parent = this.getParent(); parent != null; parent = parent.getParent()) {
            classPath.remove(parent.jarURL);
        }
    }

    @Override
    protected Object getClasspathTreeNode() {
        return this.jarURL;
    }

    @Override
    protected Collection<BaseClassLocator> getChildLocators(EnumSet<ClasspathTreeVisitOptions> options) {
        return Collections.singleton(this.getClassPathLocator());
    }

    @Override
    protected Collection<String> getClassesDirectly() {
        return this.jarLocator.getAllClasses();
    }

    @Override
    protected Collection<URL> getResourcesDirectly(String name) {
        return this.jarLocator.getResourceURLs(name);
    }
}

