/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf;

import java.beans.Beans;
import java.util.logging.Level;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.logging.internal.LoggingUtils;
import oracle.adf.share.logging.internal.perf.ADFPerfSensor;
import oracle.adf.share.logging.internal.perf.SensorTable;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;

public class StateTracker
extends ADFPerfSensor {
    public static final byte DOUBLE = 1;
    public static final byte INTEGER = 3;
    public static final byte LONG = 2;
    public static final byte OBJECT = 5;
    @CodeSharingSafe(value="MutableStaticField")
    public static final StateTracker DUMMY_STATE_TRACKER = new DummyStateTracker();
    private String mUnit;
    private State mState = null;

    private StateTracker(Level level, String sensorFullName, byte valueType, String unit, State state) {
        super(level, sensorFullName);
        this.mUnit = unit;
        this.mState = state;
    }

    private StateTracker() {
    }

    public void increment(double increasedAmount) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.increment(increasedAmount);
        if (this.mEnablePerfLog) {
            this.log(Double.toString(increasedAmount));
        }
    }

    public void increment(int increasedAmount) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.increment(increasedAmount);
        if (this.mEnablePerfLog) {
            this.log(Integer.toString(increasedAmount));
        }
    }

    public void increment(long increasedAmount) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.increment(increasedAmount);
        if (this.mEnablePerfLog) {
            this.log(Long.toString(increasedAmount));
        }
    }

    public void update(double newValue) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.update(newValue);
        if (this.mEnablePerfLog) {
            this.log(Double.toString(newValue));
        }
    }

    public void update(int newValue) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.update(newValue);
        if (this.mEnablePerfLog) {
            this.log(Integer.toString(newValue));
        }
    }

    public void update(long newValue) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.update(newValue);
        if (this.mEnablePerfLog) {
            this.log(Long.toString(newValue));
        }
    }

    public void update(Object newValue) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.update(newValue);
        if (this.mEnablePerfLog) {
            this.log(newValue.toString());
        }
    }

    public static StateTracker createStateTracker(Level level, String groupName, String name, byte valueType, String unit, String desc) {
        if (Beans.isDesignTime()) {
            return DUMMY_STATE_TRACKER;
        }
        String nounType = LoggingUtils.getNounType(groupName);
        return StateTracker.createStateTracker(level, groupName, name, nounType, valueType, unit, desc);
    }

    public static StateTracker createStateTracker(Level level, String groupName, String name, String type, byte valueType, String unit, String desc) {
        if (Beans.isDesignTime()) {
            return DUMMY_STATE_TRACKER;
        }
        name = LoggingUtils.standardizeSensorName(name);
        StringBuffer groupNameBuf = LoggingUtils.standardizeGroupName(groupName);
        groupNameBuf.append('/').append(name).append(" ").append("s");
        String fullName = groupNameBuf.toString();
        ADFPerfSensor state = SensorTable.getSensor(fullName);
        if (state != null && state instanceof StateTracker) {
            return (StateTracker)state;
        }
        State st = null;
        if (sLogger.isLoggable(level) || LoggingUtils.isDMSLoggingEnabled(level)) {
            Noun parentNoun = Noun.get((String)groupName);
            if (parentNoun == null) {
                parentNoun = Noun.create((String)groupName);
            }
            if (parentNoun.getType() == "n/a") {
                parentNoun.setType(type);
            }
            st = State.create((Noun)parentNoun, (String)name, (byte)valueType, (String)unit, (String)desc);
            st.deriveMetric(511);
        }
        StateTracker tr = new StateTracker(level, fullName, valueType, unit, st);
        tr = (StateTracker)SensorTable.putSensor(fullName, tr);
        return tr;
    }

    private void log(String value) {
        if (this.mUnit != null && this.mUnit.length() != 0) {
            value = value + this.mUnit;
        }
        this.log(System.currentTimeMillis(), value, null);
    }

    @Override
    public void reset() {
        if (this.mState != null) {
            this.mState.reset();
        }
    }

    private static class DummyStateTracker
    extends StateTracker {
        private static final String sName = "Dummy State Tracker";

        private DummyStateTracker() {
        }

        @Override
        public void increment(double increasedAmount) {
        }

        @Override
        public void increment(int increasedAmount) {
        }

        @Override
        public void increment(long increasedAmount) {
        }

        @Override
        public void update(double newValue) {
        }

        @Override
        public void update(int newValue) {
        }

        @Override
        public void update(long newValue) {
        }

        @Override
        public void update(Object newValue) {
        }

        public String toString() {
            return sName;
        }
    }
}

