/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.rc.util.impl;

import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import oracle.adf.share.common.ClassUtilsForNamePrivAction;
import oracle.adf.share.common.rc.util.impl.MetadataRegistryImpl;
import org.xml.sax.SAXException;

public class MetadataRegistryBigImpl
extends MetadataRegistryImpl {
    private Class clazz = null;
    private Method openInputStream = null;
    private Method openOutputStream = null;
    private Method exists = null;
    private Method list = null;

    public MetadataRegistryBigImpl() {
        this.init();
    }

    @Override
    protected InputStream openStream(URL url) throws IOException {
        try {
            url = this.preprocessURL(url);
            return (InputStream)this.invokeIO(this.openInputStream, url);
        }
        catch (IOException e) {
            logger.log(Level.FINE, String.valueOf(url), e);
            throw e;
        }
    }

    @Override
    protected OutputStream getOutputStream(MetadataRegistryImpl.Context ctx) throws IOException {
        try {
            URL url = this.preprocessURL(ctx.url);
            return (OutputStream)this.invokeIO(this.openOutputStream, url);
        }
        catch (IOException e) {
            logger.log(Level.FINE, String.valueOf(ctx.url), e);
            throw e;
        }
    }

    @Override
    protected void getDocumentForWriting(MetadataRegistryImpl.Context ctx) throws IOException, SAXException, ParserConfigurationException {
        URL url = this.preprocessURL(ctx.url);
        boolean adfmXmlExists = (Boolean)this.invoke(this.exists, url);
        if (adfmXmlExists) {
            ctx.doc = this.getDomDocument(url);
        } else {
            ctx.dirty = true;
            ctx.doc = this.newDomDocument(url);
        }
    }

    @Override
    public URL[] listFiles(URL url) {
        try {
            url = this.preprocessURL(url);
        }
        catch (Exception e) {
            logger.log(Level.INFO, String.valueOf(url), e);
        }
        return (URL[])this.invoke(this.list, url);
    }

    private void init() {
        try {
            ClassUtilsForNamePrivAction privAction = new ClassUtilsForNamePrivAction("oracle.ide.net.URLFileSystem", MetadataRegistryBigImpl.class);
            this.clazz = (Class)AccessController.doPrivileged(privAction);
        }
        catch (Exception e) {
            if (Beans.isDesignTime() && (e instanceof ClassNotFoundException || e.getCause() instanceof ClassNotFoundException)) {
                try {
                    this.clazz = Class.forName("oracle.ide.net.URLFileSystem", true, MetadataRegistryBigImpl.getThreadContextClassLoader());
                }
                catch (ClassNotFoundException f) {
                    throw new RuntimeException(e);
                }
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        try {
            Class[] p1 = new Class[]{URL.class};
            this.openInputStream = this.clazz.getMethod("openInputStream", p1);
            this.openOutputStream = this.clazz.getMethod("openOutputStream", p1);
            this.exists = this.clazz.getMethod("exists", p1);
            this.list = this.clazz.getMethod("list", p1);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private Object invokeIO(Method m, URL url) throws IOException {
        Object[] params = new Object[]{url};
        try {
            return m.invoke(null, params);
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (t != null && t instanceof IOException) {
                throw (IOException)t;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private Object invoke(Method m, URL url) {
        Object[] params = new Object[]{url};
        try {
            return m.invoke(null, params);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static final ClassLoader getThreadContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

