/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.process;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.fcp.SearchDockable;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationFlow;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GlassComponent;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.PointsEnteredCallback;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;
import oracle.dbtools.crest.swingui.process.DPVTransformation;
import oracle.dbtools.crest.swingui.process.Messages;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.swingui.search.SearchPanel;
import oracle.dbtools.crest.util.GUID;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;

public class ControllerTransformation
extends AbstractController {
    private DockStation dockStation = null;
    private DesignPartView designPV = null;
    private Select select;
    private ZoomIn zoomIn;
    private ZoomOut zoomOut;
    private FitScreen fitScreen;
    private ActualSize actualSize;
    private Search search;
    private ProcessObjectCollector poCollector = null;
    private NewTransformation newTransformation;
    private NewInfoStore newInfoStore;
    private NewFlow newFlow;
    private NewNote newNote;
    private NewImage newImage;
    private Delete delete;
    private final String[] OBJECT_PROCESS_PATH = new String[]{AbstractController.OBJECT_CAPTION, AbstractController.TRANSFORMATION_CAPTION};

    public ControllerTransformation(ApplicationView applicationView) {
        super(applicationView);
    }

    public JMenu getObjectTransformationMenu() {
        return this.getApplicationView().getControllerSet().getMenuStructure().get(this.OBJECT_PROCESS_PATH);
    }

    @Override
    public void initializeActions() {
        if (this.isEditable()) {
            this.select = new Select();
            this.newTransformation = new NewTransformation();
            this.newInfoStore = new NewInfoStore();
            this.newFlow = new NewFlow();
            this.newNote = new NewNote();
            this.newImage = new NewImage();
            this.delete = new Delete();
            this.add(this.select);
            this.add(this.newTransformation);
            this.add(this.newInfoStore);
            this.add(this.newFlow);
            this.add(this.newNote);
            this.add(this.newImage);
            this.add(this.delete);
        }
        this.zoomIn = new ZoomIn();
        this.add(this.zoomIn);
        this.zoomOut = new ZoomOut();
        this.add(this.zoomOut);
        this.fitScreen = new FitScreen();
        this.add(this.fitScreen);
        this.actualSize = new ActualSize();
        this.add(this.actualSize);
        this.search = new Search();
        this.add(this.search);
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerTransformation.DataFlow");
    }

    @Override
    public DesignPartView getDesignPartView() {
        return this.designPV;
    }

    @Override
    public void setDesignPartView(DesignPartView dpv) {
        this.designPV = dpv;
    }

    @Override
    public void select_SelectAction() {
        if (this.poCollector != null) {
            this.poCollector.stopWaiting();
        }
        this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
        this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
    }

    public Select getSelectAction() {
        return this.select;
    }

    public NewTransformation getNewTransformationAction() {
        return this.newTransformation;
    }

    public NewInfoStore getNewInfoStoreAction() {
        return this.newInfoStore;
    }

    public NewFlow getNewFlowAction() {
        return this.newFlow;
    }

    public NewNote getNewNoteAction() {
        return this.newNote;
    }

    public NewImage getNewImageAction() {
        return this.newImage;
    }

    public Delete getDeleteAction() {
        return this.delete;
    }

    public ZoomIn getZoomInAction() {
        return this.zoomIn;
    }

    public ZoomOut getZoomOutAction() {
        return this.zoomOut;
    }

    public FitScreen getFitScreenAction() {
        return this.fitScreen;
    }

    public ActualSize getDefaultSizeAction() {
        return this.actualSize;
    }

    @Override
    public MDBAction getFindAction() {
        return this.search;
    }

    @Override
    public void updateActions() {
        boolean enabled = true;
        if (this.getDesign().isLoadFromDB() && this.getDesignPartView().getDesignPart().getRepositoryOID() != null) {
            enabled = this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }
        this.getDesignPartView().getWorkSpace().updateReadOnlyStatus();
        this.setEnabled(this.newTransformation, enabled);
        this.setEnabled(this.newInfoStore, enabled);
        this.setEnabled(this.newFlow, enabled);
        this.setEnabled(this.newNote, enabled);
        this.setEnabled(this.newImage, enabled);
        this.setEnabled(this.delete, enabled);
    }

    @Override
    public boolean canPaste() {
        for (Object obj : this.getApplicationView().getCopiedObjects()) {
            if (obj == null || !(obj instanceof Note) && !(obj instanceof ImageObject)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paste(Point pt) {
        if (this.canPaste()) {
            try {
                ApplicationView.canLogging = false;
                int xx = 0;
                int yy = 0;
                for (Object obj : this.getApplicationView().getCopiedObjects()) {
                    TopView ctv;
                    TopView topView;
                    if (!(obj instanceof DesignObject)) continue;
                    DesignObject copied = (DesignObject)obj;
                    MultiShapedDesignObject newObj = null;
                    if (obj instanceof Note) {
                        ApplicationView.log(Messages.getString("ControllerProcess.CreateNote"));
                        newObj = ((TransformationTask)this.getDesignPartView().getDesignPart()).createNote();
                        copied.copy(newObj);
                    } else if (obj instanceof ImageObject) {
                        ApplicationView.log(Messages.getString("ControllerProcess.CreateImage"));
                        newObj = ((TransformationTask)this.getDesignPartView().getDesignPart()).createImage();
                        copied.copy(newObj);
                    }
                    if (newObj == null || (topView = this.getDesignPartView().getViewFor(newObj)) == null || topView.getCellView() == null || (ctv = copied.getTopView()) == null || ctv.getCellView() == null) continue;
                    Rectangle r = new Rectangle(ctv.getCellView().getBounds().getBounds());
                    Point2D pp = null;
                    if (pt != null) {
                        pp = this.getDesignPartView().getWorkSpace().fromScreen(new Point2D.Double(pt.x, pt.y));
                    }
                    if (pp != null) {
                        r.x = (int)pp.getX() + xx;
                        r.y = (int)pp.getY() + yy;
                    } else {
                        r.x += 30 + xx;
                        r.y += 30 + yy;
                    }
                    topView.getCellView().setNewBounds(r);
                    xx += 20;
                    yy += 20;
                    if (!(obj instanceof Note)) continue;
                    ctv.copy(topView);
                }
                this.getDesign().setDirty(true);
            }
            finally {
                ApplicationView.canLogging = true;
                this.getDesignPartView().getDesignPart().sortCollections();
            }
        }
    }

    public DockStation getDockStation() {
        if (this.dockStation == null) {
            this.dockStation = DockStation.getDockStation();
        }
        return this.dockStation;
    }

    public class ProcessObjectCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;

        public ProcessObjectCollector() {
            this.startCollecting();
        }

        public void startCollecting() {
            ControllerTransformation.this.getDesignPartView().getWorkSpace().clearSelection();
            this.collect();
        }

        private void collect() {
            this.glassComp = ControllerTransformation.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] points) {
            AbstractDataFlowTV sourceTV = this.getTVEntityFor(points[0]);
            AbstractDataFlowTV targetTV = this.getTVEntityFor(points[1]);
            ArrayList<String> errors = new ArrayList<String>();
            if (sourceTV == null) {
                errors.add(Messages.getString("ControllerTransformation.NoSourceObjectSelected"));
            }
            if (targetTV == null) {
                errors.add(Messages.getString("ControllerTransformation.NoDestinationObjectSelected"));
            }
            if (sourceTV != null && sourceTV == targetTV) {
                errors.add(Messages.getString("ControllerTransformation.SourceTargetEquals"));
            } else if (sourceTV != null && targetTV != null) {
                if (sourceTV.getModel() instanceof InOutParams && targetTV.getModel() instanceof InOutParams) {
                    errors.add(Messages.getString("ControllerTransformation.DirectFlowNotPermitted"));
                }
                if (sourceTV.getModel() instanceof InOutParams && ((InOutParams)sourceTV.getModel()).getInOutType().equalsIgnoreCase("Output")) {
                    errors.add(Messages.getString("ControllerTransformation.OutgoingFlowNotPermitted"));
                }
                if (targetTV.getModel() instanceof InOutParams && ((InOutParams)targetTV.getModel()).getInOutType().equalsIgnoreCase("Input")) {
                    errors.add(Messages.getString("ControllerTransformation.FlowNotPermitted"));
                }
            }
            if (errors.size() == 0) {
                AbstractProcessObject spo = (AbstractProcessObject)sourceTV.getModel();
                AbstractProcessObject tpo = (AbstractProcessObject)targetTV.getModel();
                if (!(spo instanceof Transformation) && !(tpo instanceof Transformation)) {
                    errors.add(Messages.getString("ControllerTransformation.OneShouldBeTransformation"));
                }
                if (errors.size() == 0) {
                    this.createFlow(sourceTV, targetTV);
                } else {
                    JOptionPane.showMessageDialog(ControllerTransformation.this.getDesignPartView(), errors.toArray(), Messages.getString("ControllerTransformation.NewFlow"), 0);
                }
            } else {
                JOptionPane.showMessageDialog(ControllerTransformation.this.getDesignPartView(), errors.toArray(), Messages.getString("ControllerTransformation.NewFlow"), 0);
            }
            ControllerTransformation.this.select_SelectAction();
        }

        private AbstractDataFlowTV getTVEntityFor(Point point) {
            Object cell = ControllerTransformation.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (cell != null && cell instanceof DFDiagramCell) {
                return (AbstractDataFlowTV)((DFDiagramCell)cell).getTopView();
            }
            return null;
        }

        private void createFlow(AbstractDataFlowTV sourceTV, AbstractDataFlowTV targetTV) {
            ApplicationView.log(Messages.getString("ControllerTransformation.CreateFlow"));
            DesignPartView dpv = ControllerTransformation.this.getApplicationView().getCurrentDPV();
            if (dpv instanceof DPVTransformation) {
                TransformationTask task = (TransformationTask)dpv.getDesignPart();
                TransformationFlow flow = task.createFlow();
                flow.setSourceTV(sourceTV);
                flow.setTargetTV(targetTV);
                ((TVFlow)flow.getTopView()).addConnection();
            }
        }

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerTransformation.this.getDesignPartView().getWorkSpace();
        }
    }

    class Search
    extends MDBAction {
        private Search() {
            super(MenuUtils.getMnemonicStr(AbstractController.SEARCH_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("SEARCH_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SEARCH_CAPTION));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPart dp = ControllerTransformation.this.getDesignPartView().getDesignPart();
            SearchDockable lastNonPinnedView = dp.getLastNonPinnedSearchDockable();
            if (lastNonPinnedView == null) {
                ViewId vId = new ViewId(new GUID().toString(), Integer.toString(dp.getSearchDockableIdSequence()));
                SearchDockable sdNew = new SearchDockable(vId);
                dp.addSearchDockable(sdNew);
                ((SearchPanel)sdNew.getGUI()).resetItems(dp);
                sdNew.show();
            } else {
                ControllerTransformation.this.getDockStation().activateDockable((Dockable)lastNonPinnedView);
            }
        }
    }

    class ActualSize
    extends MDBAction {
        private ActualSize() {
            super(MenuUtils.getMnemonicStr(AbstractController.ACTUAL_SIZE_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ACTUAL_SIZE_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerTransformation.this.getApplicationView().getCurrentDPV();
            dpv.actualSize();
        }
    }

    class FitScreen
    extends MDBAction {
        private FitScreen() {
            super(MenuUtils.getMnemonicStr(AbstractController.FIT_SCREEN_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("FIT_SCREEN_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.FIT_SCREEN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerTransformation.this.getApplicationView().getCurrentDPV();
            dpv.fitScreen();
        }
    }

    class ZoomOut
    extends MDBAction {
        private ZoomOut() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_OUT_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("ZOOM_OUT_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_OUT_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerTransformation.this.getApplicationView().getCurrentDPV();
            dpv.zoomOut();
        }
    }

    class ZoomIn
    extends MDBAction {
        private ZoomIn() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_IN_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("ZOOM_IN_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_IN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addToolbarSeparator() {
            return ControllerTransformation.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerTransformation.this.getApplicationView().getCurrentDPV();
            dpv.zoomIn();
        }
    }

    class Delete
    extends MDBAction {
        private Delete() {
            super(MenuUtils.getMnemonicStr(AbstractController.DELETE_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("DELETE_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMenuPath(ControllerTransformation.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DELETE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerTransformation.this.poCollector != null) {
                ControllerTransformation.this.poCollector.stopWaiting();
            }
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setDrawnObjectID(6);
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setCursor(Diagram.DELETE_CURSOR);
            ControllerTransformation.this.updateToolbar(this);
        }
    }

    class NewImage
    extends MDBAction {
        private NewImage() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_IMAGE_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("IMAGE_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMenuPath(ControllerTransformation.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_IMAGE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerTransformation.this.poCollector != null) {
                ControllerTransformation.this.poCollector.stopWaiting();
            }
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setDrawnObjectID(25);
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerTransformation.this.updateToolbar(this);
        }
    }

    class NewNote
    extends MDBAction {
        private NewNote() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_NOTE_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("NOTE_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMenuPath(ControllerTransformation.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_NOTE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerTransformation.this.poCollector != null) {
                ControllerTransformation.this.poCollector.stopWaiting();
            }
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setDrawnObjectID(5);
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerTransformation.this.updateToolbar(this);
        }
    }

    class NewInfoStore
    extends MDBAction {
        private NewInfoStore() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_STORE_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("INFO_STORE_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMenuPath(ControllerTransformation.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_STORE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerTransformation.this.poCollector != null) {
                ControllerTransformation.this.poCollector.stopWaiting();
            }
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setDrawnObjectID(9);
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerTransformation.this.updateToolbar(this);
        }
    }

    class NewFlow
    extends MDBAction {
        private NewFlow() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_FLOW_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("FLOW_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMenuPath(ControllerTransformation.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_FLOW_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setDrawnObjectID(10);
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerTransformation.this.updateToolbar(this);
            if (ControllerTransformation.this.poCollector != null) {
                ControllerTransformation.this.poCollector.stopWaiting();
            }
            ControllerTransformation.this.poCollector = new ProcessObjectCollector();
        }
    }

    class NewTransformation
    extends MDBAction {
        private NewTransformation() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_TRANSFORMATION_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("PROCESS_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMenuPath(ControllerTransformation.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_TRANSFORMATION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerTransformation.this.poCollector != null) {
                ControllerTransformation.this.poCollector.stopWaiting();
            }
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setDrawnObjectID(15);
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerTransformation.this.updateToolbar(this);
        }
    }

    class Select
    extends MDBAction {
        private Select() {
            super(MenuUtils.getMnemonicStr(AbstractController.SELECT_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("SELECT_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMenuPath(ControllerTransformation.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SELECT_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerTransformation.this.poCollector != null) {
                ControllerTransformation.this.poCollector.stopWaiting();
            }
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
            ControllerTransformation.this.updateToolbar(this);
        }
    }
}

