/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.multidimensional;

import java.awt.Rectangle;
import java.util.List;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.DPVCompactMultidimentional;

public class TVCube
extends AbstractMDTV {
    public TVCube(ApplicationView appView, DesignPartView dpv) {
        super(appView, dpv);
    }

    @Override
    protected ContainerView createViewSynonim(ApplicationView appv, DesignPartView dpv) {
        return new TVCube(appv, dpv);
    }

    @Override
    protected void doPrivateActions() {
        this.fireChange(ObjectChangeEvent.TOPVIEW_REMOVED);
    }

    @Override
    protected void hideRelations() {
    }

    @Override
    public Rectangle getCalculatedBounds() {
        if (this.getDesignPartView() instanceof DPVCompactMultidimentional) {
            Rectangle rec = super.getCalculatedBounds();
            int nameLength = this.getModel().getName().length() * 7;
            int size = nameLength >= 40 ? nameLength + 40 : 80;
            rec.width = size;
            rec.height = size;
            return rec;
        }
        return this.getCalculatedBoundsEx();
    }

    public Rectangle getCalculatedBoundsEx() {
        int dtl;
        int cl;
        Cube cube = (Cube)this.getModel();
        Rectangle bounds = this.getCellView() != null ? this.getCellView().getBounds().getBounds() : this.getBounds();
        int w = 35;
        int h = 50;
        List mlist = cube.getMeasures();
        int mCount = mlist.size();
        h += mCount * 14;
        int jat = cube.getAllJoinAttributes().size();
        if (jat > 0) {
            h = h + 6 + jat * 14;
        }
        int colLength = 1;
        int dtLength = 1;
        for (int i = 0; i < mCount; ++i) {
            DesignObject element = (Measure)mlist.get(i);
            cl = element.getName().length() * 7;
            dtl = 41;
            if (((Measure)element).isFormula() && ((Measure)element).getFormula().length() > 0) {
                dtl += 35;
            }
            colLength = Math.max(cl, colLength);
            dtLength = Math.max(dtl, dtLength);
        }
        for (DesignObject element : cube.getAllJoinAttributes()) {
            cl = ((ContainedObject)element).getName().length() * 7;
            dtl = 41;
            colLength = Math.max(cl, colLength);
            dtLength = Math.max(dtl, dtLength);
        }
        colLength = Math.max(cube.getName().length() * 7, colLength);
        Object[] links = cube.getOutgoingLinks().toArray();
        int dl = 10;
        if (links.length > 0) {
            for (int i = 0; i < links.length; ++i) {
                Link link = (Link)links[i];
                String name = link.getTargetMDObject().getName();
                dl = Math.max(dl, name.length() * 5);
            }
        }
        return new Rectangle(bounds.x, bounds.y, w + colLength + dtLength + dl, h);
    }
}

