/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.datatype.udb.MDBlobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDClobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDBClobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDataLinkUDB;
import oracle.dbtools.crest.model.datatype.udb.MDLongVarGraphicUDB;
import oracle.dbtools.crest.model.datatype.udb.MDLongVarcharUDB;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.PermissionsPropertyDialogUDB;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TablePropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private TableProxyUDBv81 table;
    private JComboBox cbScheme;
    private JComboBox cbPartKeyHashing;
    private JComboBox cbTS;
    private JComboBox cbIndexTS;
    private JComboBox cbLongTS;
    private JComboBox cbInitialLogging;
    private JComboBox cbDataCapture;
    private JComboBox cbFederated;
    private JComboBox cbRestrictOnDrop;
    private JComboBox cbValueCompression;
    private JPanel partKeys;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JComboBox cbSummaryQuery;
    protected JComboBox cbSummaryStatus;
    protected JComboBox cbSummaryMaintenance;
    protected JComboBox cbSummaryQueryOptimization;
    protected JComboBox cbSummaryIdentityColumn;
    protected JComboBox cbSummaryColumnDefaults;
    protected JComboBox cbSummaryRefreshOptions;
    protected JComboBox cbSummaryReplicated;
    protected JPanel summaryQuery;
    protected JPanel others;
    protected JTextArea queryArea;
    protected JCheckBox chbUseRemoteOptions;
    protected JTextField tfOwner;
    protected JTextField tfRemoteServer;
    protected JTextField tfRemoteSchema;
    protected JTextField tfRemoteTabName;
    protected JCheckBox chbOrganizeByDimensions;
    protected JTextArea taDimesions;
    private String comment;
    private String commentInRDBMS;
    private JButton bnPermissions;
    private PermissionsPropertyDialogUDB dialog;
    private JTextField tfHierarchyName;
    private JTextField tfSuperTable;

    public TablePropertyDialogUDBv81(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.table = (TableProxyUDBv81)object;
        this.setHeight(560);
        this.initCommentsView(230);
        this.initCommentsInRDBMS(230);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TablePropertyDialogUDBv81.TableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initScheme();
        this.initPartKeyHashing();
        this.initTS();
        this.initIndexTS();
        this.initLongTS();
        this.initInitialLogging();
        this.initDataCapture();
        this.initFederated();
        this.initHasSummaryQuery();
        this.initRestrictOnDrop();
        this.initValueCompression();
        this.initHierarchyName();
        this.initSuperTable();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Owner"));
        this.general.add(label);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setEditable(false);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOwner);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfOwner, 80);
    }

    private void initScheme() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Scheme"));
        this.general.add(label);
        this.cbScheme = new JComboBox();
        this.setBG(this.cbScheme);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.addActionListener(new SchemeListener());
        this.cbScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScheme);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbScheme, 50);
    }

    private void initPartKeyHashing() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.PartKeyHashing"));
        if (this.getStorageDesign() instanceof StorageDesignUDBv9) {
            label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.DistributionKeyHashing"));
        }
        this.general.add(label);
        this.cbPartKeyHashing = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPartKeyHashing);
        this.cbPartKeyHashing.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPartKeyHashing);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbPartKeyHashing, 110);
    }

    private void initTS() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.TableSpace"));
        this.general.add(label);
        this.cbTS = new JComboBox();
        this.setBG(this.cbTS);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTS);
        }
        this.cbTS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTS);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbTS, 140);
    }

    private void initIndexTS() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.IndexTableSpace"));
        this.general.add(label);
        this.cbIndexTS = new JComboBox();
        this.setBG(this.cbIndexTS);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbIndexTS);
        }
        this.cbIndexTS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIndexTS);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbIndexTS, 170);
    }

    private void initLongTS() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.LongTableSpace"));
        this.general.add(label);
        this.cbLongTS = new JComboBox();
        this.setBG(this.cbLongTS);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbLongTS);
        }
        this.cbLongTS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLongTS);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbLongTS, 200);
    }

    private void initInitialLogging() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.InitialLogging"));
        this.general.add(label);
        this.cbInitialLogging = new JComboBox<String>(YES_NO);
        this.setBG(this.cbInitialLogging);
        this.cbInitialLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbInitialLogging);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbInitialLogging, 230);
    }

    private void initDataCapture() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.DataCapture"));
        this.general.add(label);
        this.cbDataCapture = new JComboBox<String>(TableProxyUDB.getAvailableDataCaptureValues());
        this.setBG(this.cbDataCapture);
        this.cbDataCapture.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataCapture);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbDataCapture, 260);
    }

    private void initFederated() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Federated"));
        this.general.add(label);
        this.cbFederated = new JComboBox<String>(TableProxyUDB.getFederatedChoices());
        this.setBG(this.cbFederated);
        this.cbFederated.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFederated);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbFederated, 290);
    }

    protected void initHasSummaryQuery() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.SummaryQueryL"));
        this.general.add(label);
        this.cbSummaryQuery = new JComboBox<String>(YES_NO);
        this.cbSummaryQuery.addActionListener(new SummaryQueryListener());
        this.setBG(this.cbSummaryQuery);
        this.cbSummaryQuery.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSummaryQuery);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbSummaryQuery, 320);
    }

    private void enableSummaryPanel(boolean enable) {
        this.cbSummaryStatus.setEnabled(enable);
        this.cbSummaryMaintenance.setEnabled(enable);
        this.cbSummaryQueryOptimization.setEnabled(enable);
        this.cbSummaryIdentityColumn.setEnabled(enable);
        this.cbSummaryColumnDefaults.setEnabled(enable);
        this.cbSummaryRefreshOptions.setEnabled(enable);
        this.cbSummaryReplicated.setEnabled(enable);
        this.queryArea.setEnabled(enable);
    }

    protected void initRestrictOnDrop() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.RestrictOnDrop"));
        this.general.add(label);
        this.cbRestrictOnDrop = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRestrictOnDrop);
        this.cbRestrictOnDrop.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRestrictOnDrop);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.cbRestrictOnDrop, 350);
    }

    protected void initValueCompression() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.ValueCompression"));
        this.general.add(label);
        this.cbValueCompression = new JComboBox<String>(YES_NO);
        this.setBG(this.cbValueCompression);
        this.cbValueCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbValueCompression);
        this.setLabelConstraints(label, 380);
        this.setObjectConstraints(this.cbValueCompression, 380);
    }

    private void initHierarchyName() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.HierarchyName"));
        this.general.add(label);
        this.tfHierarchyName = new JTextField("", 26);
        this.general.add(this.tfHierarchyName);
        this.setLabelConstraints(label, 410);
        this.setObjectConstraints(this.tfHierarchyName, 410);
    }

    private void initSuperTable() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.SuperTable"));
        this.general.add(label);
        this.tfSuperTable = new JTextField("", 26);
        this.tfSuperTable.setEnabled(false);
        this.general.add(this.tfSuperTable);
        this.setLabelConstraints(label, 440);
        this.setObjectConstraints(this.tfSuperTable, 440);
    }

    private void initPropagatePropsButton() {
        JButton bnPropagateProps = new JButton(Messages.getString("TablePropertyDialogUDBv81.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(TablePropertyDialogUDBv81.this.getStorageDesign().getTableProxySet().getElements());
                list.remove(TablePropertyDialogUDBv81.this.table);
                new PropertiesPropagationDialog(TablePropertyDialogUDBv81.this.getAppView(), TablePropertyDialogUDBv81.this.table, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, 480);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("TablePropertyDialogUDBv81.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 480);
    }

    @Override
    protected void addTabs() {
        this.initPartKeyView();
        this.initSummaryQueryView();
        this.initROAndDimensionsView();
    }

    protected SpringLayout getROAndDimensionsLayout() {
        return (SpringLayout)this.others.getLayout();
    }

    private void initPartKeyView() {
        this.partKeys = new JPanel(new SpringLayout());
        if (this.getStorageDesign() instanceof StorageDesignUDBv9) {
            this.getPane().addTab(Messages.getString("TablePropertyDialogUDBv81.DistributionKeys"), this.partKeys);
        } else {
            this.getPane().addTab(Messages.getString("TablePropertyDialogUDBv81.PartitioningKeys"), this.partKeys);
        }
        this.initPartKeys();
    }

    protected SpringLayout getPartKeysLayout() {
        return (SpringLayout)this.partKeys.getLayout();
    }

    private void initPartKeys() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.table.getName());
        this.tfName.setText(this.table.getName());
        this.selectObject(this.cbScheme, this.table.getSchema());
        this.cbPartKeyHashing.setSelectedItem(this.table.getPartKeyHashing() ? YES_NO[0] : YES_NO[1]);
        this.selectObject(this.cbTS, this.table.getTableSpace());
        this.selectObject(this.cbIndexTS, this.table.getIndexInTableSpace());
        this.selectObject(this.cbLongTS, this.table.getLongInTableSpace());
        this.cbInitialLogging.setSelectedItem(this.table.getInitialLogging() ? YES_NO[0] : YES_NO[1]);
        this.cbDataCapture.setSelectedItem(this.table.getDataCapture());
        this.cbSummaryQuery.setSelectedItem(TablePropertyDialogUDBv81.translateYesNoForDisplay(this.table.getSummaryQuery()));
        if (this.table.getSummaryQuery().equalsIgnoreCase("YES")) {
            this.enableSummaryPanel(true);
        } else {
            this.enableSummaryPanel(false);
        }
        this.cbFederated.setSelectedItem(this.table.getFederated());
        this.cbRestrictOnDrop.setSelectedItem(TablePropertyDialogUDBv81.translateYesNoForDisplay(this.table.getRestrictOnDrop()));
        this.cbValueCompression.setSelectedItem(TablePropertyDialogUDBv81.translateYesNoForDisplay(this.table.getValueCompression()));
        if (((Table)this.table.getObject()).isRoot()) {
            this.tfHierarchyName.setText(this.table.getHierarchyName());
        } else {
            this.tfHierarchyName.setEditable(false);
        }
        this.tfSuperTable.setText(this.table.getSuperTableName());
        ColumnProxy[] columnSet = this.table.getColumnProxies();
        for (int i = 0; i < columnSet.length; ++i) {
            ColumnProxy col = columnSet[i];
            if (col.getDataType() instanceof MDBlobUDB && col.getDataType() instanceof MDLongVarcharUDB && col.getDataType() instanceof MDLongVarGraphicUDB && col.getDataType() instanceof MDClobUDB && col.getDataType() instanceof MDDBClobUDB && col.getDataType() instanceof MDDataLinkUDB) continue;
            if (this.table.getColumnSet().contains(col.getName())) {
                this.selectedColumnsModel.addElement(col);
                continue;
            }
            this.allColumnsModel.addElement(col);
        }
        this.queryArea.setText(this.table.getSummaryQueryDefinition());
        this.cbSummaryStatus.setSelectedItem(this.table.getSummaryStatus());
        this.cbSummaryMaintenance.setSelectedItem(this.table.getSummaryMaintenance());
        this.cbSummaryRefreshOptions.setSelectedItem(this.table.getSummaryRefreshOptions());
        this.cbSummaryQueryOptimization.setSelectedItem(this.table.getSummaryQueryOptimization());
        this.cbSummaryIdentityColumn.setSelectedItem(this.table.getSummaryIdentityColumn());
        this.cbSummaryColumnDefaults.setSelectedItem(this.table.getSummaryCopyColumnDefaults());
        this.cbSummaryReplicated.setSelectedItem(TablePropertyDialogUDBv81.translateYesNoForDisplay(this.table.getReplicated()));
        this.chbUseRemoteOptions.setSelected(this.table.getUseRemoteOptions());
        this.tfRemoteServer.setText(this.table.getRoRemoteServer());
        this.tfRemoteSchema.setText(this.table.getRoRemoteSchema());
        this.tfRemoteTabName.setText(this.table.getRoRemoteTabName());
        this.tfRemoteServer.setEnabled(this.table.getUseRemoteOptions());
        this.tfRemoteSchema.setEnabled(this.table.getUseRemoteOptions());
        this.tfRemoteTabName.setEnabled(this.table.getUseRemoteOptions());
        this.chbOrganizeByDimensions.setSelected(this.table.getOrganizeByDimensions());
        this.taDimesions.setText(this.table.getDimensions());
        this.taDimesions.setEnabled(this.table.getOrganizeByDimensions());
        this.comment = this.table.getObject().getComment();
        this.commentInRDBMS = this.table.getObject().getCommentInRDBMS();
        if (this.table.isCommentChanged()) {
            this.getCommentsList().insert(this.table.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.table.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.table.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    @Override
    protected void setProperties() {
        if (this.table != null) {
            this.table.setName(this.tfName.getText());
            Object selected = this.cbScheme.getSelectedItem();
            if (selected instanceof SchemaUDBv81) {
                this.table.setOwner(((SchemaUDBv81)selected).getOwner());
                this.table.setSchema((SchemaUDBv81)selected);
            } else {
                this.table.setOwner(null);
                this.table.setSchema(null);
            }
            selected = this.cbPartKeyHashing.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.table.setPartKeyHashing(result);
            selected = this.cbTS.getSelectedItem();
            if (selected instanceof TableSpaceUDBv81) {
                this.table.setTableSpace((TableSpaceUDBv81)selected);
            } else {
                this.table.setTableSpace(null);
            }
            selected = this.cbIndexTS.getSelectedItem();
            if (selected instanceof TableSpaceUDBv81) {
                this.table.setIndexInTableSpace((TableSpaceUDBv81)selected);
            } else {
                this.table.setIndexInTableSpace(null);
            }
            selected = this.cbLongTS.getSelectedItem();
            if (selected instanceof TableSpaceUDBv81) {
                this.table.setLongInTableSpace((TableSpaceUDBv81)selected);
            } else {
                this.table.setLongInTableSpace(null);
            }
            selected = this.cbInitialLogging.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.table.setInitialLogging(result);
            this.table.setDataCapture((String)this.cbDataCapture.getSelectedItem());
            this.table.setSummaryQuery(TablePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbSummaryQuery.getSelectedItem()));
            this.table.setFederated((String)this.cbFederated.getSelectedItem());
            this.table.setRestrictOnDrop(TablePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbRestrictOnDrop.getSelectedItem()));
            this.table.setValueCompression(TablePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbValueCompression.getSelectedItem()));
            if (this.tfHierarchyName.isEditable()) {
                this.table.setHierarchyName(this.tfHierarchyName.getText());
            }
            Object[] columnSet = this.selectedColumnsModel.toArray();
            this.table.clear();
            for (int i = 0; i < columnSet.length; ++i) {
                Object ob = columnSet[i];
                if (!(ob instanceof RelationalObjectProxy)) continue;
                this.table.setPartitioningKey(((RelationalObjectProxy)ob).getName());
            }
            this.table.setSummaryQueryDefinition(this.queryArea.getText());
            this.table.setSummaryStatus((String)this.cbSummaryStatus.getSelectedItem());
            this.table.setSummaryMaintenance((String)this.cbSummaryMaintenance.getSelectedItem());
            this.table.setSummaryRefreshOptions((String)this.cbSummaryRefreshOptions.getSelectedItem());
            this.table.setSummaryQueryOptimization((String)this.cbSummaryQueryOptimization.getSelectedItem());
            this.table.setSummaryIdentityColumn((String)this.cbSummaryIdentityColumn.getSelectedItem());
            this.table.setSummaryCopyColumnDefaults((String)this.cbSummaryColumnDefaults.getSelectedItem());
            this.table.setReplicated(TablePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbSummaryReplicated.getSelectedItem()));
            this.table.setUseRemoteOptions(this.chbUseRemoteOptions.isSelected());
            this.table.setRoRemoteServer(this.tfRemoteServer.getText());
            this.table.setRoRemoteSchema(this.tfRemoteSchema.getText());
            this.table.setRoRemoteTabName(this.tfRemoteTabName.getText());
            this.table.setOrganizeByDimensions(this.chbOrganizeByDimensions.isSelected());
            this.table.setDimensions(this.taDimesions.getText());
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equalsIgnoreCase(commentText)) {
                this.table.setComment(commentText);
                this.table.setCommentChanged(true);
            } else {
                this.table.setComment("");
                this.table.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equalsIgnoreCase(commentInRDBMSText)) {
                this.table.setCommentInRDBMS(commentInRDBMSText);
                this.table.setCommentInRDBMSChanged(true);
            } else {
                this.table.setCommentInRDBMS("");
                this.table.setCommentInRDBMSChanged(false);
            }
        }
    }

    private void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.AllColumns"));
        this.partKeys.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(144, 480));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.partKeys.add(sp);
        this.setLabelConstraints(this.getPartKeysLayout(), label, 12, 4);
        this.setObjectConstraints(this.getPartKeysLayout(), sp, 10, 22);
    }

    private void initSelectedColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.SelectedColumns"));
        this.partKeys.add(label);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsList);
        sp.setPreferredSize(new Dimension(145, 480));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.partKeys.add(sp);
        this.setLabelConstraints(this.getPartKeysLayout(), label, 292, 4);
        this.setObjectConstraints(this.getPartKeysLayout(), sp, 290, 22);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("TablePropertyDialogUDBv81.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.partKeys.add(this.bnAdd);
        this.setObjectConstraints(this.getPartKeysLayout(), this.bnAdd, 175, 185);
        this.bnRemove = new JButton(Messages.getString("TablePropertyDialogUDBv81.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.partKeys.add(this.bnRemove);
        this.setObjectConstraints(this.getPartKeysLayout(), this.bnRemove, 175, 215);
        TablePropertyDialogUDBv81.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected void initSummaryQueryView() {
        this.summaryQuery = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogUDBv81.SummaryQuery"), this.summaryQuery);
        this.initSummaryQuery();
    }

    private void initSummaryQuery() {
        this.initSummaryQueryDefinition();
        this.initSummaryStatus();
        this.initSummaryMaintenance();
        this.initSummaryRefreshOptions();
        this.initSummaryQueryOptimization();
        this.initSummaryIdentityColumn();
        this.initSummaryCopyColumnDefaults();
        this.initReplicated();
    }

    private void initSummaryQueryDefinition() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Query"));
        this.summaryQuery.add(label);
        this.setLabelConstraints(this.getSummaryQueryLayout(), label, 10);
        this.queryArea = new JTextArea();
        JScrollPane sp = new JScrollPane(this.queryArea);
        sp.setPreferredSize(new Dimension(395, 190));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.queryArea.setLineWrap(true);
        this.summaryQuery.add(sp);
        this.setObjectConstraints(this.getSummaryQueryLayout(), sp, 10, 30);
    }

    protected SpringLayout getSummaryQueryLayout() {
        return (SpringLayout)this.summaryQuery.getLayout();
    }

    private void initSummaryStatus() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Status"));
        this.summaryQuery.add(label);
        this.cbSummaryStatus = new JComboBox<String>(TableProxyUDB.SUMMARY_STATUS_STATES);
        this.setBG(this.cbSummaryStatus);
        this.cbSummaryStatus.setPreferredSize(this.tfName.getPreferredSize());
        this.summaryQuery.add(this.cbSummaryStatus);
        this.setLabelConstraints(this.getSummaryQueryLayout(), label, 230);
        this.setObjectConstraints(this.getSummaryQueryLayout(), this.cbSummaryStatus, 230);
    }

    private void initSummaryMaintenance() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Maintenance"));
        this.summaryQuery.add(label);
        this.cbSummaryMaintenance = new JComboBox<String>(TableProxyUDB.SUMMARY_MAINTENANCE_STATES);
        this.setBG(this.cbSummaryMaintenance);
        this.cbSummaryMaintenance.setPreferredSize(this.tfName.getPreferredSize());
        this.summaryQuery.add(this.cbSummaryMaintenance);
        this.setLabelConstraints(this.getSummaryQueryLayout(), label, 260);
        this.setObjectConstraints(this.getSummaryQueryLayout(), this.cbSummaryMaintenance, 260);
    }

    private void initSummaryRefreshOptions() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.RefreshOptions"));
        this.summaryQuery.add(label);
        this.cbSummaryRefreshOptions = new JComboBox<String>(TableProxyUDB.SUMMARY_REFRESH_OPTIONS_STATES);
        this.setBG(this.cbSummaryRefreshOptions);
        this.cbSummaryRefreshOptions.setPreferredSize(this.tfName.getPreferredSize());
        this.summaryQuery.add(this.cbSummaryRefreshOptions);
        this.setLabelConstraints(this.getSummaryQueryLayout(), label, 290);
        this.setObjectConstraints(this.getSummaryQueryLayout(), this.cbSummaryRefreshOptions, 290);
    }

    private void initSummaryQueryOptimization() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.QueryOptimization"));
        this.summaryQuery.add(label);
        this.cbSummaryQueryOptimization = new JComboBox<String>(TableProxyUDB.SUMMARY_QUERY_OPTIMIZATION_STATES);
        this.setBG(this.cbSummaryQueryOptimization);
        this.cbSummaryQueryOptimization.setPreferredSize(this.tfName.getPreferredSize());
        this.summaryQuery.add(this.cbSummaryQueryOptimization);
        this.setLabelConstraints(this.getSummaryQueryLayout(), label, 320);
        this.setObjectConstraints(this.getSummaryQueryLayout(), this.cbSummaryQueryOptimization, 320);
    }

    private void initSummaryIdentityColumn() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.IdentityColumn"));
        this.summaryQuery.add(label);
        this.cbSummaryIdentityColumn = new JComboBox<String>(TableProxyUDB.SUMMARY_IDENTITY_COLUMN_STATES);
        this.setBG(this.cbSummaryIdentityColumn);
        this.cbSummaryIdentityColumn.setPreferredSize(this.tfName.getPreferredSize());
        this.summaryQuery.add(this.cbSummaryIdentityColumn);
        this.setLabelConstraints(this.getSummaryQueryLayout(), label, 350);
        this.setObjectConstraints(this.getSummaryQueryLayout(), this.cbSummaryIdentityColumn, 350);
    }

    private void initSummaryCopyColumnDefaults() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.ColumnDefaults"));
        this.summaryQuery.add(label);
        this.cbSummaryColumnDefaults = new JComboBox<String>(TableProxyUDB.SUMMARY_COPY_COLUMN_DEFAULTS_STATES);
        this.setBG(this.cbSummaryColumnDefaults);
        this.cbSummaryColumnDefaults.setPreferredSize(this.tfName.getPreferredSize());
        this.summaryQuery.add(this.cbSummaryColumnDefaults);
        this.setLabelConstraints(this.getSummaryQueryLayout(), label, 380);
        this.setObjectConstraints(this.getSummaryQueryLayout(), this.cbSummaryColumnDefaults, 380);
    }

    private void initReplicated() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Replicated"));
        this.summaryQuery.add(label);
        this.cbSummaryReplicated = new JComboBox<String>(YES_NO);
        this.setBG(this.cbSummaryReplicated);
        this.cbSummaryReplicated.setPreferredSize(this.tfName.getPreferredSize());
        this.summaryQuery.add(this.cbSummaryReplicated);
        this.setLabelConstraints(this.getSummaryQueryLayout(), label, 410);
        this.setObjectConstraints(this.getSummaryQueryLayout(), this.cbSummaryReplicated, 410);
    }

    protected void initROAndDimensionsView() {
        this.others = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogUDBv81.RemoteOptionsAndDimensions"), this.others);
        this.initROAndDimensions();
    }

    private void initROAndDimensions() {
        this.initUseRemoteOptions();
        this.initRORemoteServer();
        this.initRORemoteSchema();
        this.initRORemoteTabName();
        this.initOrganizeByDimensions();
        this.initDimensions();
    }

    private void initUseRemoteOptions() {
        this.chbUseRemoteOptions = new JCheckBox(Messages.getString("TablePropertyDialogUDBv81.UseRemoteOptions"));
        this.chbUseRemoteOptions.addActionListener(new UseRemoteOptionsListener());
        this.others.add(this.chbUseRemoteOptions);
        this.setObjectConstraints(this.getROAndDimensionsLayout(), this.chbUseRemoteOptions, 5, 12);
    }

    private void initRORemoteServer() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.RemoteServer"));
        this.others.add(label);
        this.tfRemoteServer = new JTextField("", 26);
        this.others.add(this.tfRemoteServer);
        this.setLabelConstraints(this.getROAndDimensionsLayout(), label, 50);
        this.setObjectConstraints(this.getROAndDimensionsLayout(), this.tfRemoteServer, 50);
    }

    private void initRORemoteSchema() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.RemoteSchema"));
        this.others.add(label);
        this.tfRemoteSchema = new JTextField("", 26);
        this.others.add(this.tfRemoteSchema);
        this.setLabelConstraints(this.getROAndDimensionsLayout(), label, 80);
        this.setObjectConstraints(this.getROAndDimensionsLayout(), this.tfRemoteSchema, 80);
    }

    private void initRORemoteTabName() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.RemoteTABName"));
        this.others.add(label);
        this.tfRemoteTabName = new JTextField("", 26);
        this.others.add(this.tfRemoteTabName);
        this.setLabelConstraints(this.getROAndDimensionsLayout(), label, 110);
        this.setObjectConstraints(this.getROAndDimensionsLayout(), this.tfRemoteTabName, 110);
    }

    private void initOrganizeByDimensions() {
        this.chbOrganizeByDimensions = new JCheckBox(Messages.getString("TablePropertyDialogUDBv81.OrganizeByDimensions"));
        this.chbOrganizeByDimensions.addActionListener(new OrganizeByDimensionsListener());
        this.others.add(this.chbOrganizeByDimensions);
        this.setObjectConstraints(this.getROAndDimensionsLayout(), this.chbOrganizeByDimensions, 5, 150);
    }

    private void initDimensions() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Dimensions"));
        this.others.add(label);
        this.taDimesions = new JTextArea();
        JScrollPane sp = new JScrollPane(this.taDimesions);
        sp.setPreferredSize(new Dimension(395, 215));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.taDimesions.setLineWrap(true);
        this.others.add(sp);
        this.setLabelConstraints(this.getROAndDimensionsLayout(), label, 190);
        this.setObjectConstraints(this.getROAndDimensionsLayout(), sp, 10, 215);
    }

    private class SchemeListener
    implements ActionListener {
        private SchemeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SchemaUDBv81 schema = (SchemaUDBv81)TablePropertyDialogUDBv81.this.cbScheme.getSelectedItem();
            try {
                if (schema != null) {
                    TablePropertyDialogUDBv81.this.tfOwner.setText(schema.getOwner().toString());
                } else {
                    TablePropertyDialogUDBv81.this.tfOwner.setText("");
                }
            }
            catch (NullPointerException e1) {
                TablePropertyDialogUDBv81.this.tfOwner.setText("");
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogUDBv81.this.selectedColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogUDBv81.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogUDBv81.this.allColumnsModel.contains(ob)) continue;
                    TablePropertyDialogUDBv81.this.allColumnsModel.addElement(ob);
                    TablePropertyDialogUDBv81.this.selectedColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class OrganizeByDimensionsListener
    implements ActionListener {
        private OrganizeByDimensionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePropertyDialogUDBv81.this.taDimesions.setEnabled(TablePropertyDialogUDBv81.this.chbOrganizeByDimensions.isSelected());
        }
    }

    private class UseRemoteOptionsListener
    implements ActionListener {
        private UseRemoteOptionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePropertyDialogUDBv81.this.tfRemoteServer.setEnabled(TablePropertyDialogUDBv81.this.chbUseRemoteOptions.isSelected());
            TablePropertyDialogUDBv81.this.tfRemoteSchema.setEnabled(TablePropertyDialogUDBv81.this.chbUseRemoteOptions.isSelected());
            TablePropertyDialogUDBv81.this.tfRemoteTabName.setEnabled(TablePropertyDialogUDBv81.this.chbUseRemoteOptions.isSelected());
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogUDBv81.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogUDBv81.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogUDBv81.this.selectedColumnsModel.contains(ob)) continue;
                    TablePropertyDialogUDBv81.this.selectedColumnsModel.addElement(ob);
                    TablePropertyDialogUDBv81.this.allColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogUDBv81.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogUDBv81.this.selectedColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogUDBv81.this.bnRemove.setEnabled(false);
                } else {
                    TablePropertyDialogUDBv81.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogUDBv81.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogUDBv81.this.allColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogUDBv81.this.bnAdd.setEnabled(false);
                } else {
                    TablePropertyDialogUDBv81.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TablePropertyDialogUDBv81.this.dialog == null) {
                TablePropertyDialogUDBv81.this.dialog = new PermissionsPropertyDialogUDB(TablePropertyDialogUDBv81.this.getAppView(), TablePropertyDialogUDBv81.this.getStorageDesign(), TablePropertyDialogUDBv81.this.table);
            }
            TablePropertyDialogUDBv81.this.dialog.show();
        }
    }

    private class SummaryQueryListener
    implements ActionListener {
        private SummaryQueryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((String)TablePropertyDialogUDBv81.this.cbSummaryQuery.getSelectedItem()).equalsIgnoreCase(AbstractPropertyDialog.YES)) {
                TablePropertyDialogUDBv81.this.enableSummaryPanel(true);
            } else {
                TablePropertyDialogUDBv81.this.enableSummaryPanel(false);
            }
        }
    }
}

