/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.businessinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.businessinfo.Messages;

public class EmailPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfEmailAddress;
    private JTextField tfEmailType;
    private BIEmail email;
    private JTable cTable;
    private List cList;
    private JPanel pnContacts;

    public EmailPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public EmailPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbAddress = new JLabel(LB_EMAIL_ADDRESS);
        lbAddress.setPreferredSize(this.getDefaultSize());
        this.tfEmailAddress = new JTextField();
        this.tfEmailAddress.setPreferredSize(this.getDefaultSize());
        this.tfEmailAddress.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbAddress, this.tfEmailAddress));
        JLabel lbType = new JLabel(LB_EMAIL_TYPE);
        lbType.setPreferredSize(this.getDefaultSize());
        this.tfEmailType = new JTextField();
        this.tfEmailType.setPreferredSize(this.getDefaultSize());
        this.tfEmailType.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbType, this.tfEmailType));
    }

    @Override
    public String getCaption() {
        return Messages.getString("EmailPropertiesDialogEx.EmailProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof BIEmail) {
            this.email = (BIEmail)object;
            this.tfName.setText(this.email.getName());
            this.tfEmailAddress.setText(this.email.getEmailAddress());
            this.tfEmailType.setText(this.email.getType());
            this.cList.addAll(this.email.getContacts());
            this.taComments.setText(this.email.getComment());
            this.tfObjectID.setText(this.email.getObjectID());
            this.tfCreationTime.setText(this.email.getCreationTime());
            this.tfCreator.setText(this.email.getCreator().getName());
            this.tfDesign.setText(this.email.getOwnerDesignName());
            if (this.email.getGenerator() != null) {
                this.tfGeneratorName.setText(this.email.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.email.getChanger().getName());
            this.tfLastChangedTime.setText(this.email.getChangeTime());
            this.initDynamicProperties();
        }
    }

    @Override
    protected void setProperties() {
        this.email.setName(this.tfName.getText());
        this.email.setComment(this.taComments.getText());
        this.email.setEmailAddress(this.tfEmailAddress.getText());
        this.email.setType(this.tfEmailType.getText());
        EmailPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.email.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.email.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getContactsPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "EMAIL_PROPERTIES_DIALOG";
    }

    private JPanel getContactsPanel() {
        if (this.pnContacts == null) {
            this.pnContacts = this.createPage(Messages.getString("EmailPropertiesDialogEx.Contacts"));
            this.cList = new ArrayList();
            this.cTable = new JTable(new ContactTableModel());
            this.cTable.setSelectionMode(0);
            this.cTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = EmailPropertiesDialogEx.this.cTable.getSelectedRow()) != -1 && EmailPropertiesDialogEx.this.cList.size() > 0 && row < EmailPropertiesDialogEx.this.cList.size()) {
                        DesignObject object = (DesignObject)EmailPropertiesDialogEx.this.cList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.cTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("EmailPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = EmailPropertiesDialogEx.this.cTable.getSelectedRow();
                    if (row != -1 && EmailPropertiesDialogEx.this.cList.size() > 0 && row < EmailPropertiesDialogEx.this.cList.size()) {
                        DesignObject object = (DesignObject)EmailPropertiesDialogEx.this.cList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 180));
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnContacts.add(pPanel);
        }
        return this.pnContacts;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class ContactTableModel
    extends AbstractTableModel {
        private ContactTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return EmailPropertiesDialogEx.this.cList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("EmailPropertiesDialogEx.Contacts");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)EmailPropertiesDialogEx.this.cList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }
}

