/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.process.TVTransformation;
import oracle.ide.Ide;

public class TransformationDiagramCell
extends DFDiagramCell {
    private JPopupMenu menu;

    public TransformationDiagramCell(AbstractProcessObject processObject) {
        super(processObject);
    }

    public TransformationDiagramCell(AbstractProcessObject processObject, Map attributeMap) {
        super(processObject, attributeMap);
    }

    private void showProperty() {
        this.getProcessObject().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TransformationDiagramCell.this.deleteProcess();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TransformationDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(SEND_TO_BACK){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TransformationDiagramCell.this.getTopView().sendToBack();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransformationDiagramCell.this.showProperty();
                }
            });
        }
        return this.menu;
    }

    public void deleteProcess() {
        Diagram d = this.getDiagram();
        ApplicationView view = d.getAppView();
        DesignPartView dpv = view.getCurrentDPV();
        Transformation process = (Transformation)this.getProcessObject();
        if (process.getDesignPart() == dpv.getDesignPart()) {
            ApplicationView.log(MessageFormat.format(Messages.getString("TransformationDiagramCell.DeleteTransformation"), process.getName()));
            TVTransformation tv = (TVTransformation)this.getTopView();
            tv.remove(true);
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("TransformationDiagramCell.TransformationNotCreatedAtThisLevel"));
        }
    }

    @Override
    public void deleteSelected() {
        this.deleteProcess();
    }
}

