/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.types;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.datatype.AbstractDataType;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.swingui.admin.types.Row;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class TypesAdmin
extends CustomDialog {
    private static final Logger LOGGER = new Logger(TypesAdmin.class);
    private static final String EMPTY_VALUE = "";
    private static final int DEFAULT_COMBO_MAX_ROW_COUNT = 20;
    private String currentRDBMS;
    private String[] typesRDBMSSites;
    private boolean isSaved = true;
    private boolean applyMode = false;
    private Design design;
    private String fileName;
    private JDialog dialog;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnModify;
    private JButton btnApply;
    private JButton btnSave;
    private JButton btnClose;
    private JPanel general;
    private JPanel addPanel;
    private JPanel listPanel;
    private JPanel propPanel;
    private JPanel buttonPanel;
    private JTabbedPane tabbed;
    private JPanel nativePanel;
    private JPanel nativeDBTPanel;
    private DefaultListModel allTypesModel;
    private JList allTypesList;
    private JList rdbmsJlist;
    private JList rdbmsDBTJlist;
    private JPanel typesButtonsPanel;
    private JPanel propSubPanelCurrentMapping;
    private JPanel pnDBButtons;
    private JComboBox cbNativeDataType;
    private JTextField tfName;
    private JPanel propSubPanelName;
    private JPanel propSubPanelNameLeft;
    private JPanel propSubPanelNameRight;
    private JPanel propSubPanelMappings;
    private Hashtable elementProps = new Hashtable();
    private Object[] dbtypes;
    private Map rdbmsMap = new TreeMap();
    private Map rdbmsNTMap = new TreeMap();
    private List currentMappings = new ArrayList();
    private List currentDBTList = new ArrayList();
    private JComboBox cbLogTypes;
    private JComboBox cbNativeTypeKinds;
    private JComboBox cbLogTypesInNT;
    private LogicalDatatype unknown;
    private boolean isDBRepos = false;
    private JButton bnCheckOut;
    private JButton bnCheckIn;
    private List lsDeleted = new ArrayList();
    private List lsAdded = new ArrayList();
    JTable nativeLog;
    JTable nativeTypes;

    public TypesAdmin(ApplicationView view) {
        super(view);
        this.design = view.getCurrentDesign();
        this.dbtypes = Design.getDefaultRDBMSTypeSet().toArray();
        this.typesRDBMSSites = new String[this.dbtypes.length];
        this.setTypesRDBMSSites(this.dbtypes);
        this.design.getSelectedRDBMSType();
        this.unknown = (LogicalDatatype)this.design.getLogicalDatatypeSet().getByName("UNKNOWN");
        this.buildNativeToLogicalMappings();
        AbstractRepositoryManager dbman = this.design.getAppView().getDBPersistenceManager().getDBRepositoryManager();
        this.isDBRepos = dbman.isConnected() || this.getDesign().isLoadFromDB();
    }

    @Override
    protected String getHelpIndex() {
        return "TYPE_ADMINISTRATION_DIALOG";
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("TypesAdmin.TypesAdministration"), true);
            this.dialog.setDefaultCloseOperation(2);
            this.general = new JPanel();
            this.tabbed = new JTabbedPane();
            this.general.setLayout(new BorderLayout());
            this.general.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.addPanel = new JPanel(new BorderLayout());
            this.addPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TypesAdmin.LogicalTypes")));
            this.addPanel.setPreferredSize(new Dimension(350, 400));
            this.propPanel = new JPanel(new BorderLayout());
            this.propPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TypesAdmin.LogicalTypeMappings")));
            this.initAddPanel();
            this.buttonPanel = this.getButtonPanel();
            this.initPropPanel();
            this.general.add((Component)this.addPanel, "West");
            this.general.add((Component)this.propPanel, "Center");
            this.tabbed.add(Messages.getString("TypesAdmin.LogicalTypesToNativeTypes"), this.general);
            this.initNativePanel();
            this.initNativeDBtypePanel();
            JPanel newgeneral = new JPanel(new BorderLayout());
            newgeneral.add((Component)this.tabbed, "Center");
            newgeneral.add((Component)this.buttonPanel, "South");
            this.dialog.getContentPane().add(newgeneral);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            if (this.isDBRepos) {
                boolean enable = this.canDoCheckIn();
                this.enableButtons(enable);
                this.nativeLog.setEnabled(enable);
            } else {
                this.enableButtons(true);
            }
            this.dialog.setResizable(true);
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    JTabbedPane sourceTabbedPane = (JTabbedPane)changeEvent.getSource();
                    int index = sourceTabbedPane.getSelectedIndex();
                    if (index == 0) {
                        TypesAdmin.this.updateUD_NativeInAll();
                    }
                }
            };
            this.tabbed.addChangeListener(changeListener);
        }
        this.refreshTypesList();
        this.updateLogtypesCombo();
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    private void initAddPanel() {
        this.initAddSubPanels();
        this.initTypesButtons();
        this.initTypesPanel();
    }

    private void initAddSubPanels() {
        JPanel pnButtons = new JPanel(new GridLayout(0, 1));
        if (this.isDBRepos) {
            this.pnDBButtons = new JPanel();
            this.initDBButtons();
            pnButtons.add(this.pnDBButtons);
            this.bnCheckIn.setEnabled(this.canDoCheckIn());
            this.bnCheckOut.setEnabled(this.canDoCheckOut());
        }
        this.typesButtonsPanel = new JPanel();
        this.typesButtonsPanel.setAlignmentX(0.5f);
        this.listPanel = new JPanel(new BorderLayout());
        this.listPanel.setAlignmentX(0.5f);
        pnButtons.add(this.typesButtonsPanel);
        this.addPanel.add((Component)pnButtons, "South");
        this.addPanel.add(this.listPanel);
    }

    private void initNativePanel() {
        this.nativePanel = new JPanel(new BorderLayout());
        this.nativePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.rdbmsJlist = new JList(new RDBMSListModel());
        this.rdbmsJlist.setSelectionMode(0);
        this.rdbmsJlist.addListSelectionListener(new RDBMSSelectionListener());
        JScrollPane sp = new JScrollPane(this.rdbmsJlist);
        JPanel dblistPanel = new JPanel(new BorderLayout());
        dblistPanel.setAlignmentX(0.5f);
        dblistPanel.setPreferredSize(new Dimension(230, 400));
        dblistPanel.add(sp);
        this.nativePanel.add((Component)dblistPanel, "West");
        this.cbLogTypes = new JComboBox();
        this.nativeLog = new JTable(new NativeTableModel());
        this.nativeLog.setRowHeight(this.nativeLog.getRowHeight() + 3);
        TableColumn logtypecol = this.nativeLog.getColumnModel().getColumn(1);
        logtypecol.setCellEditor(new DefaultCellEditor(this.cbLogTypes));
        sp = new JScrollPane(this.nativeLog);
        JPanel nlog = new JPanel(new BorderLayout());
        nlog.add((Component)sp, "Center");
        this.nativePanel.add((Component)nlog, "Center");
        dblistPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TypesAdmin.RDBMSTypes")));
        nlog.setBorder(BorderFactory.createTitledBorder(Messages.getString("TypesAdmin.Mappings")));
        this.tabbed.add(Messages.getString("TypesAdmin.NativeTypesToLogicalTypes"), this.nativePanel);
    }

    private void initNativeDBtypePanel() {
        this.nativeDBTPanel = new JPanel(new BorderLayout());
        this.nativeDBTPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.rdbmsDBTJlist = new JList(new RDBMSListModel());
        this.rdbmsDBTJlist.setSelectionMode(0);
        this.rdbmsDBTJlist.addListSelectionListener(new NTRDBMSSelectionListener());
        JScrollPane sp = new JScrollPane(this.rdbmsDBTJlist);
        JPanel dblistPanel = new JPanel(new BorderLayout());
        dblistPanel.setAlignmentX(0.5f);
        dblistPanel.setPreferredSize(new Dimension(230, 400));
        dblistPanel.add(sp);
        this.nativeDBTPanel.add((Component)dblistPanel, "West");
        this.cbNativeTypeKinds = new JComboBox<String>(new DefaultComboBoxModel<String>(NativeDBType.getNT_Types()));
        ArrayList list = new ArrayList();
        list.add(null);
        Enumeration en = this.allTypesModel.elements();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        this.cbLogTypesInNT = new JComboBox<Object>(new DefaultComboBoxModel<Object>(list.toArray()));
        this.nativeTypes = new JTable(new NativeTypesModel());
        this.nativeTypes.setRowHeight(this.nativeTypes.getRowHeight() + 3);
        this.rdbmsDBTJlist.setSelectionMode(0);
        TableColumn kindTypecol = this.nativeTypes.getColumnModel().getColumn(3);
        kindTypecol.setCellEditor(new DefaultCellEditor(this.cbNativeTypeKinds));
        TableColumn logTypecol = this.nativeTypes.getColumnModel().getColumn(4);
        logTypecol.setCellEditor(new DefaultCellEditor(this.cbLogTypesInNT));
        sp = new JScrollPane(this.nativeTypes);
        JPanel nlog = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        btnAdd.setToolTipText(AbstractPropertiesDialog.BTN_ADD);
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor ed;
                int sel = TypesAdmin.this.nativeTypes.getEditingRow();
                int col = TypesAdmin.this.nativeTypes.getEditingColumn();
                if (sel > -1 && col > -1 && (ed = TypesAdmin.this.nativeTypes.getCellEditor(sel, col)) != null) {
                    ed.stopCellEditing();
                }
                NativeDBType type = new NativeDBType();
                type.setName("native_type");
                TypesAdmin.this.currentDBTList.add(type);
                TypesAdmin.this.nativeTypes.updateUI();
                TypesAdmin.this.nativeTypes.changeSelection(TypesAdmin.this.currentDBTList.size() - 1, 1, false, false);
                TypesAdmin.this.isSaved = false;
                TypesAdmin.this.btnSave.setEnabled(true);
            }
        });
        JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        btnRemove.setToolTipText(AbstractPropertiesDialog.BTN_REMOVE);
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int sel = TypesAdmin.this.nativeTypes.getSelectedRow();
                if (sel > -1 && sel < TypesAdmin.this.currentDBTList.size()) {
                    TypesAdmin.this.currentDBTList.remove(sel);
                    TypesAdmin.this.nativeTypes.updateUI();
                    TypesAdmin.this.isSaved = false;
                    TypesAdmin.this.btnSave.setEnabled(true);
                }
            }
        });
        toolBar.add(btnAdd);
        toolBar.add(btnRemove);
        nlog.add((Component)toolBar, "North");
        nlog.add((Component)sp, "Center");
        this.nativeDBTPanel.add((Component)nlog, "Center");
        dblistPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TypesAdmin.RDBMSTypes")));
        nlog.setBorder(BorderFactory.createTitledBorder(Messages.getString("TypesAdmin.NativeTypes")));
        this.tabbed.add(Messages.getString("TypesAdmin.UserDefinedNativeTypes"), this.nativeDBTPanel);
        this.nativeTypes.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void updateLogtypesCombo() {
        int row = this.nativeLog.getEditingRow();
        int col = this.nativeLog.getEditingColumn();
        if (row > -1 && col > -1) {
            this.nativeLog.getCellEditor(row, col).stopCellEditing();
        }
        ArrayList list = new ArrayList();
        this.design.getLogicalDatatypeSet().addAllElementsTo(list);
        Collections.sort(list, ModelObjectSet.LONG_NAME_COMPARATOR);
        list.add(0, null);
        this.cbLogTypes.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        if (this.cbLogTypesInNT != null) {
            list.clear();
            Enumeration en = this.allTypesModel.elements();
            while (en.hasMoreElements()) {
                list.add(en.nextElement());
            }
            this.cbLogTypesInNT.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        }
    }

    private void enableButtons(boolean b) {
        this.btnAdd.setEnabled(b);
        this.btnRemove.setEnabled(b);
        this.btnModify.setEnabled(b);
    }

    private void initPropPanel() {
        this.initPropSubPanels();
        this.editableAll(false);
    }

    private void initPropSubPanels() {
        this.propSubPanelName = new JPanel();
        this.propSubPanelName.setLayout(new BorderLayout());
        this.propSubPanelName.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.propPanel.add((Component)this.propSubPanelName, "North");
        this.propSubPanelNameLeft = new JPanel();
        this.propSubPanelNameLeft.setLayout(new GridLayout(2, 1));
        this.propSubPanelNameLeft.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.propSubPanelName.add((Component)this.propSubPanelNameLeft, "West");
        this.propSubPanelNameRight = new JPanel();
        this.propSubPanelNameRight.setLayout(new GridLayout(2, 1));
        this.propSubPanelNameRight.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.propSubPanelName.add((Component)this.propSubPanelNameRight, "Center");
        this.initSubPanelName();
        this.propSubPanelMappings = new JPanel();
        this.propSubPanelMappings.setLayout(new GridLayout(0, 1));
        this.propPanel.add(this.propSubPanelMappings);
        for (int i = 0; i < this.typesRDBMSSites.length; ++i) {
            this.propSubPanelCurrentMapping = new JPanel();
            this.propSubPanelCurrentMapping.setLayout(new FlowLayout());
            this.propSubPanelCurrentMapping.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.initSubPanelCurrentMapping(this.typesRDBMSSites[i], (RDBMSType)this.dbtypes[i]);
            this.propSubPanelMappings.add(this.propSubPanelCurrentMapping);
        }
    }

    private void initSubPanelName() {
        JLabel lbName = new JLabel(Messages.getString("TypesAdmin.Name"));
        this.propSubPanelNameLeft.add(lbName);
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(new Dimension(180, 20));
        this.propSubPanelNameLeft.add(this.tfName);
    }

    private void initSubPanelCurrentMapping(String rdbms, RDBMSType dbtype) {
        JLabel lbRDBMS = new JLabel(rdbms);
        lbRDBMS.setPreferredSize(new Dimension(130, 20));
        this.propSubPanelCurrentMapping.add(lbRDBMS);
        this.cbNativeDataType = new JComboBox<String>(this.getNativeDataTypes(dbtype));
        this.cbNativeDataType.addActionListener(new AddTypesActionListener(){});
        this.cbNativeDataType.setPreferredSize(new Dimension(160, 20));
        this.cbNativeDataType.setMaximumRowCount(20);
        this.setBG(this.cbNativeDataType);
        JCheckBox chPrecision = new JCheckBox(Messages.getString("TypesAdmin.Precision"), false);
        chPrecision.setHorizontalAlignment(4);
        JIntegerField tfPrecision = new JIntegerField();
        tfPrecision.setPreferredSize(new Dimension(40, 20));
        JCheckBox chSize = new JCheckBox(Messages.getString("TypesAdmin.Size"), false);
        chSize.setHorizontalAlignment(4);
        JTextField tfSize = new JTextField();
        tfSize.setPreferredSize(new Dimension(40, 20));
        JCheckBox chScale = new JCheckBox(Messages.getString("TypesAdmin.Scale"), false);
        chScale.setHorizontalAlignment(4);
        JIntegerField tfScale = new JIntegerField();
        tfScale.setPreferredSize(new Dimension(40, 20));
        Row row = new Row(rdbms, this.cbNativeDataType, chSize, chScale, chPrecision, tfPrecision, tfSize, tfScale);
        this.propSubPanelCurrentMapping.add(row.getType());
        this.propSubPanelCurrentMapping.add(row.getPrecision());
        this.propSubPanelCurrentMapping.add(row.getTfPrecision());
        this.propSubPanelCurrentMapping.add(row.getScale());
        this.propSubPanelCurrentMapping.add(row.getTfScale());
        this.propSubPanelCurrentMapping.add(row.getSize());
        this.propSubPanelCurrentMapping.add(row.getTfSize());
        this.elementProps.put(rdbms, row);
    }

    private String[] getNativeDataTypes(RDBMSType dbtype) {
        List<String> list = Arrays.asList(StandardDatatypeNames.getPredefinedNativeDatatypes(dbtype));
        ArrayList<String> plist = new ArrayList<String>(list);
        for (RDBMSType current = dbtype; current != null; current = current.getParentType()) {
            List nlist = (List)this.rdbmsNTMap.get(current);
            for (NativeDBType nt : nlist) {
                String name = nt.getName();
                if (plist.contains(name)) continue;
                plist.add(name);
            }
        }
        Object[] array = plist.toArray(new String[0]);
        Arrays.sort(array);
        return array;
    }

    protected boolean setProperties() {
        LogicalDatatype logicalDatatype = (LogicalDatatype)this.allTypesList.getSelectedValue();
        if (logicalDatatype == null) {
            String id = this.design.getAppView().getIDGenerator().createNewID();
            while (this.design.getLogicalDatatypeSet().containsId(id)) {
                id = this.design.getAppView().getIDGenerator().createNewID();
            }
            logicalDatatype = this.design.getLogicalDatatypeSet().createLogicalDatatype(id);
        }
        logicalDatatype.setName(this.tfName.getText());
        for (int i = 0; i < this.typesRDBMSSites.length; ++i) {
            if (this.canApply(this.typesRDBMSSites[i])) {
                String encodedString = this.encodeString(this.typesRDBMSSites[i]);
                logicalDatatype.put(this.typesRDBMSSites[i], encodedString);
                TreeMap defaults = this.getDefaultValues(this.typesRDBMSSites[i]);
                logicalDatatype.addDefaults(this.typesRDBMSSites[i], defaults);
                this.refreshTypesList();
                this.editableAll(false);
                if (!this.isDBRepos) continue;
                this.getDesign().getLogicalDatatypeSet().setDirty(true);
                continue;
            }
            this.editableAll(true);
            if (this.isDBRepos) {
                this.getDesign().getLogicalDatatypeSet().setDirty(false);
            }
            return false;
        }
        this.design.getAppView().clearDomainsDatatypes(logicalDatatype);
        return true;
    }

    private String encodeString(String rdbms) {
        String encodedString = null;
        Row row = (Row)this.elementProps.get(rdbms);
        encodedString = (String)row.getType().getSelectedItem();
        if (row.getSize().isSelected()) {
            encodedString = encodedString.concat(", ");
            encodedString = encodedString.concat("size");
        }
        if (row.getPrecision().isSelected() || row.getScale().isSelected()) {
            encodedString = encodedString.concat(", ");
            encodedString = encodedString.concat("precision");
        }
        if (row.getScale().isSelected()) {
            encodedString = encodedString.concat(", ");
            encodedString = encodedString.concat("scale");
        }
        return encodedString;
    }

    private void initTypesPanel() {
        this.initTypes();
    }

    private TreeMap getDefaultValues(String rdbms) {
        String dScale;
        String dSize;
        TreeMap<String, String> defaults = new TreeMap<String, String>();
        Row row = (Row)this.elementProps.get(rdbms);
        String dPrecision = row.getTfPrecision().getText().trim();
        if (dPrecision.length() > 0) {
            defaults.put("precision_default_value", row.getTfPrecision().getText().trim());
        }
        if ((dSize = row.getTfSize().getText().trim()).length() > 0) {
            defaults.put("size_default_value", row.getTfSize().getText().trim());
        }
        if ((dScale = row.getTfScale().getText().trim()).length() > 0) {
            defaults.put("scale_default_value", row.getTfScale().getText().trim());
        }
        return defaults;
    }

    private void initTypes() {
        this.lsDeleted.clear();
        this.lsAdded.clear();
        this.allTypesModel = new DefaultListModel();
        this.allTypesList = new JList(this.allTypesModel);
        this.allTypesList.setSelectionMode(0);
        this.allTypesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LogicalDatatype logicalDatatype = (LogicalDatatype)TypesAdmin.this.allTypesList.getSelectedValue();
                if (logicalDatatype != null) {
                    TypesAdmin.this.clear();
                    TypesAdmin.this.applyMode = false;
                    TypesAdmin.this.btnModify.setText(Messages.getString("TypesAdmin.Modify"));
                    TypesAdmin.this.btnModify.setMnemonic(77);
                    if (logicalDatatype == TypesAdmin.this.unknown) {
                        TypesAdmin.this.btnRemove.setEnabled(false);
                        TypesAdmin.this.btnModify.setEnabled(false);
                    } else if (TypesAdmin.this.isDBRepos) {
                        TypesAdmin.this.btnRemove.setEnabled(TypesAdmin.this.canDoCheckIn());
                        TypesAdmin.this.btnModify.setEnabled(TypesAdmin.this.btnRemove.isEnabled());
                    } else {
                        TypesAdmin.this.btnRemove.setEnabled(true);
                        TypesAdmin.this.btnModify.setEnabled(true);
                    }
                    TypesAdmin.this.tfName.setText(logicalDatatype.getName());
                    for (int i = 0; i < TypesAdmin.this.typesRDBMSSites.length; ++i) {
                        String rdbms = TypesAdmin.this.typesRDBMSSites[i];
                        Row row = (Row)TypesAdmin.this.elementProps.get(TypesAdmin.this.typesRDBMSSites[i]);
                        Map m = logicalDatatype.getToPhysical();
                        MDDataType type = logicalDatatype.createDataType(rdbms, m);
                        try {
                            TypesAdmin.this.setNativeType(rdbms, (RDBMSType)TypesAdmin.this.dbtypes[i], type);
                        }
                        catch (RuntimeException exp) {
                            LOGGER.error("Error mapping native types: " + logicalDatatype.getName() + " rdbms: " + rdbms, exp);
                        }
                        String stringEncodedType = (String)m.get(TypesAdmin.this.typesRDBMSSites[i]);
                        String[] tokenized = MDDataTypeFactory.tokenize(stringEncodedType);
                        TreeMap defaults0 = (TreeMap)logicalDatatype.getDefaultValues();
                        TreeMap defaults1 = (TreeMap)defaults0.get(TypesAdmin.this.typesRDBMSSites[i]);
                        if (defaults1 != null) {
                            TypesAdmin.this.setTfPrecision(row, (String)defaults1.get("precision_default_value"));
                            TypesAdmin.this.setTfSize(row, (String)defaults1.get("size_default_value"));
                            TypesAdmin.this.setTfScale(row, (String)defaults1.get("scale_default_value"));
                        }
                        if (tokenized.length == 1) {
                            TypesAdmin.this.setSize(row, false);
                            TypesAdmin.this.setScale(row, false);
                            TypesAdmin.this.setPrecision(row, false);
                            continue;
                        }
                        if (tokenized.length == 2) {
                            if (tokenized[1].equalsIgnoreCase("size")) {
                                TypesAdmin.this.setSize(row, true);
                                TypesAdmin.this.setPrecision(row, false);
                                TypesAdmin.this.setScale(row, false);
                                continue;
                            }
                            if (tokenized[1].equalsIgnoreCase("scale")) {
                                TypesAdmin.this.setSize(row, false);
                                TypesAdmin.this.setPrecision(row, false);
                                TypesAdmin.this.setScale(row, true);
                                continue;
                            }
                            if (!tokenized[1].equalsIgnoreCase("precision")) continue;
                            TypesAdmin.this.setSize(row, false);
                            TypesAdmin.this.setPrecision(row, true);
                            TypesAdmin.this.setScale(row, false);
                            continue;
                        }
                        if (tokenized.length != 3) continue;
                        if (tokenized[1].equalsIgnoreCase("size")) {
                            TypesAdmin.this.setSize(row, true);
                            TypesAdmin.this.setPrecision(row, false);
                            TypesAdmin.this.setScale(row, false);
                        } else if (tokenized[1].equalsIgnoreCase("scale")) {
                            TypesAdmin.this.setSize(row, false);
                            TypesAdmin.this.setPrecision(row, false);
                            TypesAdmin.this.setScale(row, true);
                        } else if (tokenized[1].equalsIgnoreCase("precision")) {
                            TypesAdmin.this.setSize(row, false);
                            TypesAdmin.this.setPrecision(row, true);
                            TypesAdmin.this.setScale(row, false);
                        }
                        if (tokenized[2].equalsIgnoreCase("size")) {
                            TypesAdmin.this.setSize(row, true);
                            continue;
                        }
                        if (tokenized[2].equalsIgnoreCase("scale")) {
                            TypesAdmin.this.setScale(row, true);
                            continue;
                        }
                        if (!tokenized[2].equalsIgnoreCase("precision")) continue;
                        TypesAdmin.this.setPrecision(row, true);
                    }
                    TypesAdmin.this.editableAll(false);
                    if (logicalDatatype == TypesAdmin.this.unknown) {
                        TypesAdmin.this.tfName.setEnabled(false);
                        TypesAdmin.this.tfName.setEditable(false);
                    }
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.allTypesList);
        this.listPanel.add(sp);
    }

    protected void setScale(Row row, boolean b) {
        row.getScale().setSelected(b);
    }

    protected void setTfScale(Row row, String b) {
        row.getTfScale().setText(b);
    }

    protected void setPrecision(Row row, boolean b) {
        row.getPrecision().setSelected(b);
    }

    protected void setTfPrecision(Row row, String b) {
        row.getTfPrecision().setText(b);
    }

    protected void setNativeType(String rdbms, RDBMSType dbtype, MDDataType type) throws RuntimeException {
        Row row = (Row)this.elementProps.get(rdbms);
        for (int i = 0; i < this.getNativeDataTypes(dbtype).length; ++i) {
            try {
                if (!((String)row.getType().getItemAt(i)).equalsIgnoreCase(type.getName())) continue;
                row.getType().setSelectedIndex(i);
                continue;
            }
            catch (RuntimeException e) {
                LOGGER.error("Error mapping native types!" + rdbms + " RDBMSType: " + dbtype.getName() + " MDDataType: " + type.getName(), e);
                throw new RuntimeException(e);
            }
        }
    }

    protected void setSize(Row row, boolean b) {
        row.getSize().setSelected(b);
    }

    protected void setTfSize(Row row, String b) {
        row.getTfSize().setText(b);
    }

    protected void initDBButtons() {
        this.bnCheckOut = new JButton(Messages.getString("TypesAdmin.CheckOut"));
        this.bnCheckOut.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCheckOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypesAdmin.this.enableButtons(true);
                TypesAdmin.this.bnCheckIn.setEnabled(true);
                TypesAdmin.this.bnCheckOut.setEnabled(false);
                TypesAdmin.this.nativeLog.setEnabled(true);
                TypesAdmin.this.checkOut();
            }
        });
        this.bnCheckIn = new JButton(Messages.getString("TypesAdmin.CheckIn"));
        this.bnCheckIn.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCheckIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypesAdmin.this.enableButtons(false);
                TypesAdmin.this.bnCheckIn.setEnabled(false);
                TypesAdmin.this.bnCheckOut.setEnabled(true);
                TypesAdmin.this.nativeLog.setEnabled(false);
                TypesAdmin.this.checkIn();
            }
        });
        this.pnDBButtons.add(this.bnCheckOut);
        this.pnDBButtons.add(this.bnCheckIn);
    }

    protected void initTypesButtons() {
        this.btnAdd = new JButton(Messages.getString("TypesAdmin.Add"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TypesAdmin.this.design != null) {
                    TypesAdmin.this.clear();
                    LogicalDatatype logicalDatatype = TypesAdmin.this.design.getLogicalDatatypeSet().createLogicalDatatype(null);
                    TypesAdmin.this.lsAdded.add(logicalDatatype);
                    for (int i = 0; i < TypesAdmin.this.typesRDBMSSites.length; ++i) {
                        logicalDatatype.put(TypesAdmin.this.typesRDBMSSites[i], "UNKNOWN");
                    }
                    if ("types".equalsIgnoreCase(TypesAdmin.this.fileName)) {
                        logicalDatatype.setOwnerDesignName("System");
                    } else {
                        logicalDatatype.setOwnerDesignName(TypesAdmin.this.getApplicationView().getDesignName());
                    }
                    TypesAdmin.this.refreshTypesList();
                    TypesAdmin.this.allTypesList.setSelectedValue(logicalDatatype, true);
                    TypesAdmin.this.editableAll(true);
                    TypesAdmin.this.applyMode = true;
                    TypesAdmin.this.isSaved = false;
                    TypesAdmin.this.btnModify.setText(Messages.getString("TypesAdmin.Apply"));
                    TypesAdmin.this.btnModify.setMnemonic(89);
                    TypesAdmin.this.updateLogtypesCombo();
                    TypesAdmin.this.nativeLog.updateUI();
                }
            }
        });
        this.btnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnAdd.setMnemonic(65);
        this.typesButtonsPanel.add(this.btnAdd);
        this.btnRemove = new JButton(Messages.getString("TypesAdmin.Remove"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogicalDatatype logicalDatatype = (LogicalDatatype)TypesAdmin.this.allTypesList.getSelectedValue();
                if (TypesAdmin.this.design != null && logicalDatatype != null) {
                    TypesAdmin.this.lsDeleted.add(logicalDatatype);
                    TypesAdmin.this.design.getLogicalDatatypeSet().remove(logicalDatatype);
                }
                TypesAdmin.this.refreshTypesList();
                TypesAdmin.this.clear();
                TypesAdmin.this.btnSave.setEnabled(true);
                TypesAdmin.this.isSaved = false;
                TypesAdmin.this.editableAll(false);
                TypesAdmin.this.applyMode = false;
                TypesAdmin.this.btnModify.setText(Messages.getString("TypesAdmin.Modify"));
                TypesAdmin.this.btnModify.setMnemonic(77);
                TypesAdmin.this.updateLogtypesCombo();
                TypesAdmin.this.nullifyUsagerofType(logicalDatatype);
                TypesAdmin.this.nativeLog.updateUI();
            }
        });
        this.btnRemove.setMnemonic(82);
        this.btnRemove.setEnabled(false);
        this.btnRemove.setPreferredSize(this.btnAdd.getPreferredSize());
        this.typesButtonsPanel.add(this.btnRemove);
        this.btnModify = new JButton(Messages.getString("TypesAdmin.Modify"));
        this.btnModify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TypesAdmin.this.applyMode) {
                    boolean validated = TypesAdmin.this.apply();
                    if (validated) {
                        TypesAdmin.this.applyMode = false;
                        TypesAdmin.this.btnModify.setText(Messages.getString("TypesAdmin.Modify"));
                        TypesAdmin.this.btnModify.setMnemonic(77);
                    } else {
                        TypesAdmin.this.applyMode = true;
                        TypesAdmin.this.btnModify.setText(Messages.getString("TypesAdmin.Apply"));
                        TypesAdmin.this.btnModify.setMnemonic(65);
                    }
                    TypesAdmin.this.updateLogtypesCombo();
                    TypesAdmin.this.nativeLog.updateUI();
                } else if (TypesAdmin.this.allTypesList.getSelectedIndex() > -1) {
                    TypesAdmin.this.editableAll(true);
                    LogicalDatatype logicalDatatype = (LogicalDatatype)TypesAdmin.this.allTypesList.getSelectedValue();
                    if (logicalDatatype == TypesAdmin.this.unknown) {
                        TypesAdmin.this.tfName.setEnabled(false);
                        TypesAdmin.this.tfName.setEditable(false);
                    }
                    TypesAdmin.this.applyMode = true;
                    TypesAdmin.this.btnModify.setText(Messages.getString("TypesAdmin.Apply"));
                    TypesAdmin.this.btnModify.setMnemonic(89);
                }
            }
        });
        this.btnModify.setMnemonic(77);
        this.btnModify.setEnabled(false);
        this.btnModify.setPreferredSize(this.btnAdd.getPreferredSize());
        this.typesButtonsPanel.add(this.btnModify);
    }

    private void nullifyUsagerofType(LogicalDatatype ltype) {
        for (Holder holder : this.currentMappings) {
            if (holder.oldtype == ltype) {
                holder.oldtype = this.unknown;
            }
            if (holder.type != ltype) continue;
            holder.type = null;
        }
    }

    protected void refreshTypesList() {
        this.allTypesModel.clear();
        if (this.design != null) {
            LogicalDatatype[] logTypesSet = (LogicalDatatype[])this.design.getLogicalDatatypeSet().toArray();
            for (int i = 0; i < logTypesSet.length; ++i) {
                LogicalDatatype currLogType = logTypesSet[i];
                this.allTypesModel.addElement(currLogType);
            }
        }
    }

    protected void editableAll(boolean b) {
        this.tfName.setEnabled(b);
        this.tfName.setEditable(b);
        this.btnApply.setEnabled(b);
        for (int i = 0; i < this.typesRDBMSSites.length; ++i) {
            Row row = (Row)this.elementProps.get(this.typesRDBMSSites[i]);
            row.getType().setEnabled(b);
            if (row.getPrecision().isSelected()) {
                row.getPrecision().setEnabled(b);
                row.getTfPrecision().setEnabled(b);
            } else {
                row.getPrecision().setEnabled(false);
                row.getTfPrecision().setEnabled(false);
            }
            if (row.getSize().isSelected()) {
                row.getSize().setEnabled(b);
                row.getTfSize().setEnabled(b);
            } else {
                row.getSize().setEnabled(false);
                row.getTfSize().setEnabled(false);
            }
            if (row.getScale().isSelected()) {
                row.getScale().setEnabled(b);
                row.getTfScale().setEnabled(b);
            } else {
                row.getScale().setEnabled(false);
                row.getTfScale().setEnabled(false);
            }
            if (!b) continue;
            this.currentRDBMS = this.typesRDBMSSites[i];
            String dataTypeName = StandardDatatypeNames.getUsedDatatypeName((String)row.getType().getSelectedItem());
            MDDataTypeFactory factory = MDDataTypeFactory.getInstance(this.currentRDBMS, this.getApplicationView().getSettings());
            AbstractDataType type = (AbstractDataType)factory.createType(dataTypeName, 1, 1);
            if (type != null) {
                row.getScale().setEnabled(true);
                row.getPrecision().setEnabled(true);
                row.getSize().setEnabled(false);
                row.getTfScale().setEnabled(true);
                row.getTfPrecision().setEnabled(true);
                row.getTfSize().setEnabled(false);
            } else {
                type = (AbstractDataType)factory.createType(dataTypeName, "1");
                if (type != null) {
                    row.getScale().setEnabled(false);
                    row.getPrecision().setEnabled(false);
                    row.getSize().setEnabled(true);
                    row.getTfScale().setEnabled(false);
                    row.getTfPrecision().setEnabled(false);
                    row.getTfSize().setEnabled(true);
                } else {
                    type = (AbstractDataType)factory.createType(dataTypeName);
                    if (type != null) {
                        row.getScale().setEnabled(false);
                        row.getPrecision().setEnabled(false);
                        row.getSize().setEnabled(false);
                        row.getTfScale().setEnabled(false);
                        row.getTfPrecision().setEnabled(false);
                        row.getTfSize().setEnabled(false);
                    }
                }
            }
            if (type == null) continue;
            row.getScale().setEnabled(type.hasScale());
            row.getPrecision().setEnabled(type.hasPrecision());
            row.getSize().setEnabled(type.hasSize());
            row.getTfScale().setEnabled(type.hasScale());
            row.getTfPrecision().setEnabled(type.hasPrecision());
            row.getTfSize().setEnabled(type.hasSize());
            row.getScale().setToolTipText(type.getScaleText());
            row.getPrecision().setToolTipText(type.getPrecisionText());
            row.getSize().setToolTipText(type.getSizeText());
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout());
            this.buttonPanel.setPreferredSize(new Dimension(200, 35));
            this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel panel = new JPanel(new GridLayout(1, 0, 5, 5));
            this.btnSave = new JButton(Messages.getString("TypesAdmin.Save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TypesAdmin.this.applyMappings();
                    TypesAdmin.this.applyUD_NativeTypes();
                    TypesAdmin.this.design.getAppView().getPersistenceManager().writeTypes(TypesAdmin.this.design);
                    TypesAdmin.this.isSaved = true;
                    TypesAdmin.this.btnSave.setEnabled(false);
                    TypesAdmin.this.editableAll(false);
                    TypesAdmin.this.setUnknownToNull();
                    TypesAdmin.this.nativeLog.updateUI();
                    TypesAdmin.this.lsDeleted.clear();
                    TypesAdmin.this.lsAdded.clear();
                }
            });
            if (this.isDBRepos) {
                this.btnSave.setVisible(false);
            }
            this.btnApply = new JButton(Messages.getString("TypesAdmin.Apply"));
            this.btnApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean validated = TypesAdmin.this.setProperties();
                    if (validated) {
                        TypesAdmin.this.isSaved = false;
                        TypesAdmin.this.btnSave.setEnabled(true);
                    } else {
                        TypesAdmin.this.isSaved = true;
                        TypesAdmin.this.btnSave.setEnabled(false);
                    }
                }
            });
            this.btnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnApply.setMnemonic(80);
            this.btnApply.setEnabled(false);
            this.btnSave.setPreferredSize(this.btnAdd.getPreferredSize());
            this.btnSave.setMnemonic(83);
            this.btnSave.setEnabled(false);
            this.btnClose = new JButton(Messages.getString("TypesAdmin.Close"));
            this.btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TypesAdmin.this.close(TypesAdmin.this.getDialog());
                }
            });
            this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnClose.setMnemonic(67);
            JButton btnHelp = new JButton(this.getHelpAction());
            btnHelp.setMnemonic(72);
            btnHelp.setPreferredSize(this.btnAdd.getPreferredSize());
            panel.add(this.btnSave);
            panel.add(this.btnClose);
            panel.add(btnHelp);
            this.buttonPanel.add((Component)panel, "East");
        }
        return this.buttonPanel;
    }

    private boolean apply() {
        boolean validated = this.setProperties();
        if (validated) {
            this.isSaved = false;
            this.btnSave.setEnabled(true);
        } else {
            this.isSaved = true;
            this.btnSave.setEnabled(false);
        }
        return validated;
    }

    @Override
    protected void close() {
        this.close(this.getDialog());
    }

    protected SpringLayout getPanelLayout(JPanel panel) {
        return (SpringLayout)panel.getLayout();
    }

    public void setBG(Component c) {
        c.setBackground(Color.WHITE);
        if (!c.getFont().isPlain()) {
            c.setFont(new Font(c.getFont().getName(), 0, c.getFont().getSize()));
        }
    }

    public void close(Window dialog) {
        if (!this.isSaved) {
            if (this.closeConfirmed(dialog)) {
                this.doClose();
            }
        } else {
            this.doClose();
        }
    }

    private void doClose() {
        if (this.design != null) {
            for (LogicalDatatype ldt : this.lsAdded) {
                this.design.getLogicalDatatypeSet().remove(ldt);
            }
            for (LogicalDatatype ldt : this.lsDeleted) {
                this.design.getLogicalDatatypeSet().add(ldt);
            }
        }
        this.design = null;
        this.dialog.dispose();
    }

    private boolean closeConfirmed(Window dialog) {
        if (this.isDBRepos) {
            return true;
        }
        String s1 = Messages.getString("TypesAdmin.Yes");
        String s2 = Messages.getString("TypesAdmin.No");
        Object[] options = new Object[]{s1, s2};
        int n = JOptionPane.showOptionDialog(dialog, Messages.getString("TypesAdmin.TypesNotSaved"), Messages.getString("TypesAdmin.QuitConfirmation"), 0, 3, null, options, s1);
        return n == 0;
    }

    private void clear() {
        this.tfName.setText(EMPTY_VALUE);
    }

    public void setTypesRDBMSSites(Object[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            this.typesRDBMSSites[i] = ((RDBMSType)objects[i]).getName();
            this.currentRDBMS = ((RDBMSType)objects[i]).getName();
        }
    }

    public void buildNativeToLogicalMappings() {
        for (int i = 0; i < this.dbtypes.length; ++i) {
            RDBMSType dbtype = (RDBMSType)this.dbtypes[i];
            String[] types = StandardDatatypeNames.getAllPossibleDatatypes((RDBMSType)this.dbtypes[i]);
            ArrayList<Holder> list = (ArrayList<Holder>)this.rdbmsMap.get(dbtype);
            if (list == null) {
                list = new ArrayList<Holder>();
                this.rdbmsMap.put(dbtype, list);
            }
            for (int j = 0; j < types.length; ++j) {
                String type = types[j];
                if (type.equals("UNKNOWN")) continue;
                String usedtype = StandardDatatypeNames.getUsedDatatypeName(type);
                if (!type.equals(usedtype = StandardDatatypeNames.getTransformedDatatypeName(usedtype, dbtype))) continue;
                LogicalDatatype ltype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(dbtype, usedtype);
                if (ltype == null) {
                    ltype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(dbtype, type);
                }
                Holder holder = new Holder(type);
                if (ltype != null) {
                    holder.setType(ltype);
                    holder.oldtype = ltype;
                    if (ltype == this.unknown) {
                        holder.setType(null);
                    }
                }
                list.add(holder);
            }
            ArrayList<NativeDBType> plist = (ArrayList<NativeDBType>)this.rdbmsNTMap.get(dbtype);
            if (plist == null) {
                plist = new ArrayList<NativeDBType>();
                this.rdbmsNTMap.put(dbtype, plist);
            }
            List nlist = StandardDatatypeNames.getUD_NativeTypesAsList(dbtype);
            for (NativeDBType nt : nlist) {
                String name = nt.getName();
                plist.add(nt);
                nt.setOldName(name);
            }
            Collections.sort(list);
            Collections.sort(plist);
        }
    }

    private void applyMappings() {
        for (int i = 0; i < this.dbtypes.length; ++i) {
            RDBMSType dbtype = (RDBMSType)this.dbtypes[i];
            List list = (List)this.rdbmsMap.get(dbtype);
            if (list == null) continue;
            for (int j = 0; j < list.size(); ++j) {
                Holder holder = (Holder)list.get(j);
                if (holder.type == null) {
                    holder.type = this.unknown;
                }
                if (holder.type == holder.oldtype) continue;
                if (holder.type == this.unknown) {
                    MappingDatatypeNameLogicalDataType.removeNativeToLogicalMapping(dbtype, holder.typeName);
                } else {
                    MappingDatatypeNameLogicalDataType.addNativeToLogicalMapping(dbtype, holder.typeName, holder.type);
                }
                holder.oldtype = holder.type;
            }
        }
    }

    private void applyUD_NativeTypes() {
        Map map = StandardDatatypeNames.getUd_nativeMap();
        for (Object key : this.rdbmsNTMap.keySet()) {
            List list;
            TreeMap<String, NativeDBType> tmap = (TreeMap<String, NativeDBType>)map.get(key);
            if (tmap == null) {
                tmap = new TreeMap<String, NativeDBType>();
                map.put(key, tmap);
            }
            if ((list = (List)this.rdbmsNTMap.get(key)) == null) continue;
            tmap.clear();
            for (NativeDBType nt : list) {
                tmap.put(nt.getName(), nt);
            }
        }
    }

    private void setUnknownToNull() {
        for (int i = 0; i < this.dbtypes.length; ++i) {
            RDBMSType dbtype = (RDBMSType)this.dbtypes[i];
            List list = (List)this.rdbmsMap.get(dbtype);
            if (list == null) continue;
            for (int j = 0; j < list.size(); ++j) {
                Holder holder = (Holder)list.get(j);
                if (holder.type != this.unknown) continue;
                holder.type = null;
            }
        }
    }

    public void checkOut() {
        LogicalDatatypeSet ldts = this.getDesign().getLogicalDatatypeSet();
        AbstractRepositoryManager rman = this.design.getAppView().getDBPersistenceManager().getDBRepositoryManager();
        boolean res = false;
        if (rman.isConnected()) {
            String ch_user = null;
            try {
                ch_user = rman.getCheckoutByUser(ldts);
            }
            catch (SQLException ex) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("TypesAdmin.ErrorInCheckout"), ex.getMessage()}, Messages.getString("TypesAdmin.CheckoutError"), 0);
            }
            if (ch_user != null) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TypesAdmin.CheckoutBy"), ldts.getName(), ch_user), Messages.getString("TypesAdmin.CheckoutError"), 0);
                ldts.setCheckedOut(true);
                ldts.setCheckedOutByMe(false);
            }
            if (res = rman.checkOutObject(ldts)) {
                ldts.setCheckedOutByMe(true);
            }
        }
    }

    public void checkIn() {
        LogicalDatatypeSet ldts = this.getDesign().getLogicalDatatypeSet();
        AbstractRepositoryManager rman = this.design.getAppView().getDBPersistenceManager().getDBRepositoryManager();
        boolean res = false;
        if (rman.isConnected()) {
            int rs;
            if (ldts.isDirty() && (rs = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TypesAdmin.NotSaved"), ldts.getName()), Messages.getString("TypesAdmin.ObjectNotSaved"), 1)) != 2 && rs == 0) {
                this.applyMappings();
                this.applyUD_NativeTypes();
                rman.writeObject(ldts);
                ldts.setDirty(false);
            }
            if (res = rman.checkInObject(ldts)) {
                ldts.setCheckedOut(false);
                ldts.setCheckedOutByMe(false);
            }
        }
    }

    private boolean canDoCheckOut() {
        boolean res = false;
        LogicalDatatypeSet ldts = this.getDesign().getLogicalDatatypeSet();
        AbstractRepositoryManager rman = this.design.getAppView().getDBPersistenceManager().getDBRepositoryManager();
        if (!ldts.isCheckedOut() && rman.isConnected()) {
            res = ldts.getRepositoryOID() != null;
        }
        return res;
    }

    private boolean canDoCheckIn() {
        boolean res = false;
        LogicalDatatypeSet ldts = this.getDesign().getLogicalDatatypeSet();
        AbstractRepositoryManager rman = this.design.getAppView().getDBPersistenceManager().getDBRepositoryManager();
        if (ldts.isCheckedOut() && rman.isConnected() && ldts.isCheckedOutByMe()) {
            res = ldts.getRepositoryOID() != null;
        }
        return res;
    }

    private boolean canApply(String rdbms) {
        Row row = (Row)this.elementProps.get(rdbms);
        if (!row.getSize().isSelected() && row.getTfSize().getText().trim().length() > 0) {
            MessageDialogs.showErrorMessage(this, MessageFormat.format(Messages.getString("TypesAdmin.SizeCheck"), rdbms));
            row.getTfSize().requestFocus();
            return false;
        }
        if (!row.getScale().isSelected() && row.getTfScale().getText().trim().length() > 0) {
            MessageDialogs.showErrorMessage(this, MessageFormat.format(Messages.getString("TypesAdmin.ScaleCheck"), rdbms));
            row.getTfScale().requestFocus();
            return false;
        }
        if (!row.getPrecision().isSelected() && row.getTfPrecision().getText().trim().length() > 0) {
            MessageDialogs.showErrorMessage(this, MessageFormat.format(Messages.getString("TypesAdmin.PrecisionCheck"), rdbms));
            row.getTfPrecision().requestFocus();
            return false;
        }
        return true;
    }

    void updateUD_NativeInAll() {
        for (int i = 0; i < this.typesRDBMSSites.length; ++i) {
            String rdbms = this.typesRDBMSSites[i];
            RDBMSType dbtype = (RDBMSType)this.dbtypes[i];
            Row row = (Row)this.elementProps.get(rdbms);
            JComboBox cb = row.getType();
            Object item = cb.getSelectedItem();
            boolean precisionEn = row.getPrecision().isEnabled();
            boolean scaleEn = row.getScale().isEnabled();
            boolean sizeEn = row.getSize().isEnabled();
            boolean precValue = row.getPrecision().isSelected();
            boolean scaleValue = row.getScale().isSelected();
            boolean sizeValue = row.getSize().isSelected();
            String tprecision = row.getTfPrecision().getText();
            String tscale = row.getTfScale().getText();
            String tsize = row.getTfSize().getText();
            cb.setModel(new DefaultComboBoxModel<String>(this.getNativeDataTypes(dbtype)));
            cb.setSelectedItem(item);
            Object selected = cb.getSelectedItem();
            if (item != selected) continue;
            row.getScale().setEnabled(scaleEn);
            row.getPrecision().setEnabled(precisionEn);
            row.getSize().setEnabled(sizeEn);
            row.getTfScale().setEnabled(scaleEn);
            row.getTfPrecision().setEnabled(precisionEn);
            row.getTfSize().setEnabled(sizeEn);
            row.getTfPrecision().setText(tprecision);
            row.getTfScale().setText(tscale);
            row.getTfSize().setText(tsize);
            row.getPrecision().setSelected(precValue);
            row.getScale().setSelected(scaleValue);
            row.getSize().setSelected(sizeValue);
            String name = (String)item;
            NativeDBType nt = StandardDatatypeNames.getNativeDBType(dbtype, name);
            if (nt == null) continue;
            if (!nt.isHasSize()) {
                row.getSize().setSelected(false);
                row.getSize().setEnabled(false);
                row.getTfSize().setText(EMPTY_VALUE);
                row.getTfSize().setEnabled(false);
            }
            if (!nt.isHasPrecision()) {
                row.getPrecision().setSelected(false);
                row.getScale().setSelected(false);
                row.getPrecision().setEnabled(false);
                row.getScale().setEnabled(false);
                row.getTfPrecision().setText(EMPTY_VALUE);
                row.getTfScale().setText(EMPTY_VALUE);
                row.getTfPrecision().setEnabled(false);
                row.getTfScale().setEnabled(false);
            }
            if (!this.applyMode) continue;
            if (nt.isHasSize()) {
                row.getSize().setEnabled(true);
                row.getTfSize().setEnabled(true);
            }
            if (!nt.isHasPrecision()) continue;
            row.getPrecision().setEnabled(true);
            row.getTfPrecision().setEnabled(true);
            row.getScale().setEnabled(true);
            row.getTfScale().setEnabled(true);
        }
    }

    class ComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        ComboBoxRenderer(Object[] elements) {
            super(new DefaultComboBoxModel<Object>(elements));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelectedItem(value);
            return this;
        }
    }

    class NativeTypesModel
    extends AbstractTableModel {
        String N_TYPE = Messages.getString("TypesAdmin.NativeType");
        String HAS_SIZE = Messages.getString("TypesAdmin.HasSize");
        String HAS_PRECISION = Messages.getString("TypesAdmin.HasPrecisionAndScale");
        String KIND = Messages.getString("TypesAdmin.Kind");
        String LOGICAL_TYPE = Messages.getString("TypesAdmin.LogicalType");
        String[] COL_NAMES = new String[]{this.N_TYPE, this.HAS_SIZE, this.HAS_PRECISION, this.KIND, this.LOGICAL_TYPE};

        NativeTypesModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            NativeDBType type = (NativeDBType)TypesAdmin.this.currentDBTList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return true;
                }
                case 1: {
                    return !type.isHasPrecision() && TypesAdmin.EMPTY_VALUE.equals(type.getTypeKind());
                }
                case 2: {
                    return !type.isHasSize() && TypesAdmin.EMPTY_VALUE.equals(type.getTypeKind());
                }
                case 3: {
                    return !type.isHasPrecision() && !type.isHasSize();
                }
            }
            return true;
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return TypesAdmin.this.currentDBTList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            NativeDBType type = (NativeDBType)TypesAdmin.this.currentDBTList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return type.getName();
                }
                case 1: {
                    return type.isHasSize();
                }
                case 2: {
                    return type.isHasPrecision();
                }
                case 3: {
                    return type.getTypeKind();
                }
                case 4: {
                    return type.getLogicalDatatype();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Object obj = this.getValueAt(rowIndex, columnIndex);
            NativeDBType type = (NativeDBType)TypesAdmin.this.currentDBTList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    type.setName((String)aValue);
                    break;
                }
                case 1: {
                    type.setHasSize((Boolean)aValue);
                    break;
                }
                case 2: {
                    type.setHasPrecision((Boolean)aValue);
                    break;
                }
                case 3: {
                    type.setTypeKind((String)aValue);
                    break;
                }
                case 4: {
                    type.setLogicalDatatype((LogicalDatatype)aValue);
                }
            }
            if (aValue != null && !aValue.equals(obj)) {
                TypesAdmin.this.isSaved = false;
                TypesAdmin.this.btnSave.setEnabled(true);
            }
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 1: 
                case 2: {
                    return Boolean.class;
                }
                case 4: {
                    return LogicalDatatype.class;
                }
            }
            return String.class;
        }
    }

    class NativeTableModel
    extends AbstractTableModel {
        NativeTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TypesAdmin.NativeType");
            }
            return Messages.getString("TypesAdmin.LogicalType");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TypesAdmin.this.currentMappings.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Holder holder = (Holder)TypesAdmin.this.currentMappings.get(rowIndex);
            if (columnIndex == 0) {
                return holder.getTypeName();
            }
            if (columnIndex == 1) {
                return holder.getType();
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Holder holder = (Holder)TypesAdmin.this.currentMappings.get(rowIndex);
            if (columnIndex == 1) {
                LogicalDatatype ltype = (LogicalDatatype)aValue;
                if (ltype != holder.getType()) {
                    TypesAdmin.this.isSaved = false;
                    TypesAdmin.this.btnSave.setEnabled(true);
                    if (TypesAdmin.this.isDBRepos) {
                        TypesAdmin.this.getDesign().getLogicalDatatypeSet().setDirty(true);
                    }
                }
                holder.setType((LogicalDatatype)aValue);
            }
        }
    }

    class Holder
    implements Comparable {
        String typeName;
        LogicalDatatype type;
        LogicalDatatype oldtype;

        Holder(String typeName) {
            this.typeName = typeName;
        }

        public int compareTo(Object o) {
            if (o instanceof Holder) {
                return this.typeName.compareTo(((Holder)o).getTypeName());
            }
            return 0;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public LogicalDatatype getType() {
            return this.type;
        }

        public void setType(LogicalDatatype type) {
            this.type = type;
        }
    }

    class NTRDBMSSelectionListener
    implements ListSelectionListener {
        NTRDBMSSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TypesAdmin.this.rdbmsDBTJlist.getSelectedValue() != null) {
                RDBMSType type = (RDBMSType)TypesAdmin.this.rdbmsDBTJlist.getSelectedValue();
                TypesAdmin.this.currentDBTList = (List)TypesAdmin.this.rdbmsNTMap.get(type);
                TypesAdmin.this.nativeTypes.updateUI();
            }
        }
    }

    class RDBMSSelectionListener
    implements ListSelectionListener {
        RDBMSSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TypesAdmin.this.rdbmsJlist.getSelectedValue() != null) {
                RDBMSType type = (RDBMSType)TypesAdmin.this.rdbmsJlist.getSelectedValue();
                TypesAdmin.this.currentMappings = (List)TypesAdmin.this.rdbmsMap.get(type);
                TypesAdmin.this.nativeLog.updateUI();
            }
        }
    }

    class RDBMSListModel
    extends AbstractListModel {
        RDBMSListModel() {
        }

        @Override
        public Object getElementAt(int index) {
            if (index < TypesAdmin.this.dbtypes.length) {
                return TypesAdmin.this.dbtypes[index];
            }
            return null;
        }

        @Override
        public int getSize() {
            return TypesAdmin.this.dbtypes.length;
        }
    }

    class AddTypesActionListener
    implements ActionListener {
        AddTypesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            for (int i = 0; i < TypesAdmin.this.typesRDBMSSites.length; ++i) {
                Row row = (Row)TypesAdmin.this.elementProps.get(TypesAdmin.this.typesRDBMSSites[i]);
                if (!cb.equals(row.getType())) continue;
                TypesAdmin.this.currentRDBMS = TypesAdmin.this.typesRDBMSSites[i];
                String dataTypeName = StandardDatatypeNames.getUsedDatatypeName((String)cb.getSelectedItem());
                MDDataTypeFactory factory = MDDataTypeFactory.getInstance(TypesAdmin.this.currentRDBMS, TypesAdmin.this.getApplicationView().getSettings());
                AbstractDataType type = (AbstractDataType)factory.createType(dataTypeName, 1, 1);
                row.getScale().setSelected(false);
                row.getPrecision().setSelected(false);
                row.getSize().setSelected(false);
                row.getTfScale().setText(TypesAdmin.EMPTY_VALUE);
                row.getTfPrecision().setText(TypesAdmin.EMPTY_VALUE);
                row.getTfSize().setText(TypesAdmin.EMPTY_VALUE);
                if (type != null) {
                    row.getScale().setEnabled(true);
                    row.getPrecision().setEnabled(true);
                    row.getSize().setEnabled(false);
                    row.getTfScale().setEnabled(true);
                    row.getTfPrecision().setEnabled(true);
                    row.getTfSize().setEnabled(false);
                } else {
                    type = (AbstractDataType)factory.createType(dataTypeName, "1");
                    if (type != null) {
                        row.getScale().setEnabled(false);
                        row.getPrecision().setEnabled(false);
                        row.getSize().setEnabled(true);
                        row.getTfScale().setEnabled(false);
                        row.getTfPrecision().setEnabled(false);
                        row.getTfSize().setEnabled(true);
                    } else {
                        type = (AbstractDataType)factory.createType(dataTypeName);
                        if (type != null) {
                            row.getScale().setEnabled(false);
                            row.getPrecision().setEnabled(false);
                            row.getSize().setEnabled(false);
                            row.getTfScale().setEnabled(false);
                            row.getTfPrecision().setEnabled(false);
                            row.getTfSize().setEnabled(true);
                        }
                    }
                }
                if (type == null) break;
                row.getScale().setEnabled(type.hasScale());
                row.getPrecision().setEnabled(type.hasPrecision());
                row.getSize().setEnabled(type.hasSize());
                row.getTfScale().setEnabled(type.hasScale());
                row.getTfPrecision().setEnabled(type.hasPrecision());
                row.getTfSize().setEnabled(type.hasSize());
                row.getScale().setToolTipText(type.getScaleText());
                row.getPrecision().setToolTipText(type.getPrecisionText());
                row.getSize().setToolTipText(type.getSizeText());
                break;
            }
        }
    }
}

