/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Iterator;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLLevel
extends AbstractWXMLDesignObject
implements MDConstants {
    private Level level = null;

    public WXMLLevel(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof Level;
        if (result) {
            this.level = (Level)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.level != null) {
            String designName = this.level.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.level.getDesignPart().getObjectID())).append('/');
        }
        buffer.append(this.getConfiguration().get("levelPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof Level) {
            Level level = (Level)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("description", String.valueOf(level.getDescription()));
            map.put("entity", String.valueOf(level.getLevelEntity() != null ? StringUtilities.encodeAttributeValue(level.getLevelEntity().getObjectID()) : NULL_STR));
            map.put("selectioncriteria", String.valueOf(level.getSelectionCriteria()));
            map.put("selectioncriteriades", String.valueOf(level.getSelectionCriteriaDescription()));
            map.put("valuebased", String.valueOf(level.isValueBasedHierarchy()));
            map.put("rootident", String.valueOf(level.getRootIdentification()));
            map.put("identvalue", String.valueOf(level.getIdentificationValue()));
            if (level.getDefaultAttribute() != null) {
                map.put("default_attribute", StringUtilities.encodeAttributeValue(level.getDefaultAttribute().getObjectID()));
            }
            Level.OraAWAttributes oa = level.getOraAWAttributes();
            if (oa.shortDesc != null) {
                map.put("aw_short_description", StringUtilities.encodeAttributeValue(oa.shortDesc.getObjectID()));
            }
            if (oa.longDesc != null) {
                map.put("aw_long_description", StringUtilities.encodeAttributeValue(oa.longDesc.getObjectID()));
            }
            if (oa.timeEnd != null) {
                map.put("aw_time_end", StringUtilities.encodeAttributeValue(oa.timeEnd.getObjectID()));
            }
            if (oa.timeSpan != null) {
                map.put("aw_time_span", StringUtilities.encodeAttributeValue(oa.timeSpan.getObjectID()));
            }
            map.put("name_column", String.valueOf(level.getNameColumn() != null ? StringUtilities.encodeAttributeValue(level.getNameColumn().getObjectID()) : NULL_STR));
            map.put("value_column", String.valueOf(level.getValueColumn() != null ? StringUtilities.encodeAttributeValue(level.getValueColumn().getObjectID()) : NULL_STR));
            this.appendProperties(objectInfoNode, "attributes", map);
            this.appendObjects(objectInfoNode, level.getLevelKey().toArray(), "levelkey");
            this.appendObjects(objectInfoNode, level.getParentKey().toArray(), "parentkey");
            this.appendCalculatedAttributes(objectInfoNode, level);
            Element contained = objectInfoNode.getOwnerDocument().createElement("contained");
            objectInfoNode.appendChild(contained);
            for (SlowChangingAttribute scha : level.getSlowChangingAttributes()) {
                this.appendSlowChangingAttributeInfo(contained, scha);
            }
        }
    }

    private void appendSlowChangingAttributeInfo(Element objectInfoNode, SlowChangingAttribute scha) {
        Element propertiesList = objectInfoNode.getOwnerDocument().createElement("slowchangingattribute");
        Element param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        this.appendProperty(param, "attributeid", StringUtilities.encodeAttributeValue(scha.getAttribute().getObjectID()));
        param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        this.appendProperty(param, "type", scha.getType());
        param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        this.appendProperty(param, "classification", scha.getClassification());
        param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        this.appendProperty(param, "name", scha.getName());
        param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        this.appendProperty(param, "indexed", String.valueOf(scha.isIndexed()));
        Iterator it = scha.getHistoryAttributes().iterator();
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            buffer.append(StringUtilities.encodeAttributeValue(((DesignObject)it.next()).getObjectID()));
        }
        param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        this.appendProperty(param, "historyattributes", buffer.toString());
        objectInfoNode.appendChild(propertiesList);
    }

    private void appendCalculatedAttributes(Element parentNode, Level level) {
        Document doc = parentNode.getOwnerDocument();
        Element list = doc.createElement("calculated_attributes");
        for (CalculatedAttribute ca : level.getCalculatedAttributes()) {
            Element attr = doc.createElement("contained");
            attr.setAttribute("oid", StringUtilities.encodeAttributeValue(ca.getObjectID()));
            if (ca.getName() != null && !"".equalsIgnoreCase(ca.getName())) {
                attr.setAttribute("name", StringUtilities.encodeAttributeValue(ca.getName()));
            }
            if (ca.getFunction() != null && !"".equalsIgnoreCase(ca.getFunction())) {
                attr.setAttribute("ca_expression", StringUtilities.encodeAttributeValue(ca.getFunction()));
            }
            list.appendChild(attr);
        }
        parentNode.appendChild(list);
    }
}

