/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLBusinessInfoDesign
extends AbstractXMLWriter {
    private BusinessInfoDesign design = null;

    public WXMLBusinessInfoDesign(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof BusinessInfoDesign;
    }

    @Override
    public Document writeDocument(Object object) {
        this.design = (BusinessInfoDesign)object;
        Document doc = this.createDocument("design");
        Element designElm = doc.getDocumentElement();
        designElm.setAttribute("id", StringUtilities.encodeAttributeValue(this.design.getObjectID()));
        Element referenced = doc.createElement("ref");
        designElm.appendChild(referenced);
        Collection all = this.design.getStorableDesignObjects();
        Iterator it = all.iterator();
        DesignObject designObject = null;
        while (it.hasNext()) {
            designObject = (DesignObject)it.next();
            this.handleDesignObject(referenced, designObject);
        }
        this.design.setDirty(false);
        return doc;
    }

    private void handleDesignObject(Element referenced, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            boolean check = this.getPersistenceManager().isCheckDirty() ? designObject.isDirty() : true;
            if (check) {
                this.getPersistenceManager().write(designObject);
            }
        }
        this.appendReferencedObjectElement(referenced, designObject);
    }

    private void appendReferencedObjectElement(Element parentNode, DesignObject designObject) {
        Document doc = parentNode.getOwnerDocument();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", designObject.belongsToDesign() ? OBJECT_CONTAINS : OBJECT_USES);
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        parentNode.appendChild(objInfo);
    }

    @Override
    public String getFilenameFor(Object object) {
        BusinessInfoDesign dsn = (BusinessInfoDesign)object;
        return dsn.getName();
    }

    @Override
    public String getRelativePath() {
        if (this.design != null && this.design.getAppView() != null) {
            String designName = this.design.getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(designName).append('/').append("businessinfo");
            return buffer.toString();
        }
        return "businessinfo";
    }
}

