/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLArc
extends AbstractRXMLDesignObject {
    public RXMLArc(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getLogicalDesign().getArcSet().createArc(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        Entity entity;
        Arc arc = (Arc)super.recreateObject(objInfo, design, tryReadWriteLocking);
        String entityID = objInfo.getAttribute("entity");
        if (entityID != null && !"".equalsIgnoreCase(entityID) && (entity = (Entity)design.getDesignObject(entityID)) != null) {
            entity.addArc(arc);
            Map map = this.getProperties(objInfo, "relations");
            Object[] keys = map.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                Object key = keys[i];
                String relationID = (String)map.get(key);
                Relation relation = (Relation)design.getDesignObject(relationID);
                if (relation == null) continue;
                arc.addRelation(relation);
            }
        }
        return arc;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append("logical").append('/');
        }
        buffer.append(this.getConfiguration().get("arcPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == Arc.class;
    }
}

