/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRRuleAssignedColumns
extends AbstractDRStorageDesign {
    private final String RULE_ID = "48A7197A-BF03-B651-01B3-ED5DC53C2D10";

    public DRRuleAssignedColumns(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRRuleAssignedColumns.CheckForAassignedColumns"));
        this.setDescription(Messages.getString("DRRuleAssignedColumns.TheRuleShouldHaveOneColumnAssigned"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        RuleSqlServer rule = (RuleSqlServer)object;
        if ("".equalsIgnoreCase(rule.getColumns())) {
            return CheckResult.createWarning(object, this, Messages.getString("DRRuleAssignedColumns.RuleDoesNotHaveColumnsAssigned"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRRuleAssignedColumns.TheRuleHasAssignedColumns"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "48A7197A-BF03-B651-01B3-ED5DC53C2D10";
    }
}

