/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2.v70;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRIndexPartitionEmptyPartConstants
extends AbstractDRStorageDesign {
    private final String RULE_ID = "F6DCCFB2-EF80-07C0-7CD4-D088C56AF996";

    public DRIndexPartitionEmptyPartConstants(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRIndexPartitionEmptyPartConstants.CheckPartConstantsOfIndexPartitions"));
        this.setDescription(Messages.getString("DRIndexPartitionEmptyPartConstants.PartConstantsOfIndexPartitions"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        IndexPartitionDB2 partition = (IndexPartitionDB2)object;
        if ("".equalsIgnoreCase(partition.getPartConstants())) {
            return CheckResult.createFailed(partition, this, Messages.getString("DRIndexPartitionEmptyPartConstants.PartConstantsOfIndexPartitionAreEmpty"));
        }
        return CheckResult.createOk(partition, this, Messages.getString("DRIndexPartitionEmptyPartConstants.PartConstantsOfIndexPartitionAreNotEmpty"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "F6DCCFB2-EF80-07C0-7CD4-D088C56AF996";
    }
}

