/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingConstants;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRTableNamingStandard
extends DesignRule
implements NamingConstants {
    private final String RULE_ID = "92E06D4A-0D91-B313-3652-8C983D517988";
    private NamingStandardRule namingRule;

    public DRTableNamingStandard() {
        this.setName(Messages.getString("DRTableNamingStandard.IdentifyTablesWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRTableNamingStandard.TablesWithWrongNamingStandardsAreNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        int ctype;
        Table table = (Table)object;
        this.namingRule = table.getDesign().getDesignLevelSettings().getNamingStandardRule();
        Iterator it = this.namingRule.getGlossaries().iterator();
        String errors = "";
        NamingOptionsHolder oph = table.getDesignPart().getNamingOptionsHolderFor(Table.class);
        if (oph == null) {
            oph = table.getDesignPart().getNamingOptionsHolderFor(Table.class);
        }
        boolean upperCaseOnly = false;
        if (oph != null && (ctype = oph.getCaseType()) == 0) {
            upperCaseOnly = true;
        }
        char relSep = this.namingRule.getRelationalSeparatorChar();
        boolean abbreviatedOnly = this.namingRule.isAbbreviatedOnly();
        while (it.hasNext()) {
            Glossary glossary = (Glossary)it.next();
            String error = glossary.checkValidName(table.getName(), this.namingRule.getTablesList(), relSep, false, upperCaseOnly, true, abbreviatedOnly);
            if (error == null) {
                return CheckResult.createOk(table, this, Messages.getString("DRTableNamingStandard.TableNameIsInValidFormat"));
            }
            if (errors.length() == 0) {
                errors = error;
                continue;
            }
            errors = errors + ". " + error;
        }
        if ("".equals(errors)) {
            return CheckResult.createOk(table, this, Messages.getString("DRTableNamingStandard.TableNameIsInValidFormat"));
        }
        return CheckResult.createWarning(table, this, errors);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "92E06D4A-0D91-B313-3652-8C983D517988";
    }
}

