/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.design.undo.RemoveDO_Edit;

public class IndexRemoveEdit
extends RemoveDO_Edit {
    private Index index;
    private Index backup;
    private List savedItems = new ArrayList();
    private Table table;
    private List mappings = new ArrayList();

    public IndexRemoveEdit(Index index) {
        super(index);
        this.index = index;
        this.table = (Table)index.getContainerWithKeyObject();
        this.backup = new Index(index.getDesignPart());
        this.backup.setBackup(true);
        this.backup.setContainerObject(this.table);
        this.backup.setObjectID(index.getObjectID());
        index.copy(this.backup);
        this.saveMappings(index, this.mappings);
        if (index.isPK() || index.isUnique()) {
            Collection fkeys = ((RelationalDesign)index.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(index);
            this.backupFKeys(fkeys, this.savedItems);
        }
    }

    @Override
    protected void removeObject() {
        this.index.remove();
    }

    @Override
    protected void restoreObject() {
        Index newIndex = (Index)this.table.getKeySet().getObjectByID(this.backup.getObjectID());
        if (newIndex == null) {
            newIndex = this.index;
            this.table.add(newIndex);
        } else {
            this.index = newIndex;
        }
        this.backup.copy(newIndex);
        for (DesignObjectEdit.MappingWr wr : this.mappings) {
            Index index = (Index)this.table.getLocalObject(wr.object.getObjectID());
            if (index == null) continue;
            wr.object = index;
        }
        this.restoreMappings(this.mappings);
        this.restoreFKeys(this.savedItems);
    }

    private void backupFKeys(Collection fkeys, List savedItems) {
        for (FKIndexAssociation fk : fkeys) {
            savedItems.add(this.backupFK(fk, true));
        }
    }

    private void restoreFKeys(List savedItems) {
        for (DesignObjectEdit.FKProperties props : savedItems) {
            this.restoreFK(props);
        }
    }
}

