/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.string.Crypt;

public abstract class UserOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener {
    private static final String[] AUTH_TYPES = new String[]{"BY_PASSWORD", "EXTERNALLY", "GLOBALLY"};
    private static List authTypesList = Arrays.asList(AUTH_TYPES);
    private static Set authTypeSet = null;
    private String authType = AUTH_TYPES[0];
    private String identifier = "";
    private TableSpaceOracle defTableSpace = null;
    private TemporaryTablespaceOracle tempTableSpace = null;
    private String profile = "";
    private String passwordExpire = "NO";
    private String accountLock = "NO";
    private StorageObjectCollection quotaitems;
    private String externalName = "";
    private static Crypt crypt = new Crypt();
    protected InlineList roleSet = null;
    protected InlineList rolesWithAdminOptionSet = null;
    protected InlineList systemPrivilegesSet = null;
    protected InlineList privilegesWithAdminOptionSet = null;
    protected String roles = "";
    protected String rolesWithAdminOption = "";
    protected String systemPrivileges = "";
    protected String privilegesWithAdminOption = "";
    protected String adminOption = "NO";
    public static final String NAME_SUBSTITUTION_TYPE = "User";
    public static final String TYPE_NAME = "User";

    public UserOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.quotaitems = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getQuotaItemSet());
        this.quotaitems.setParent(this);
        this.quotaitems.setName(Messages.getString("UserOracle.Quotas"));
        this.quotaitems.setClassForParent(UserOracle.class);
        this.quotaitems.setSetMethod("setUser");
        this.quotaitems.setIcon(GUIConfiguration.getInstance().getIcon("QUOTA_ITEM_ICON", 16));
        ((StorageDesignOracle)storageDesign).getQuotaItemSet().addSetListener(this);
    }

    @Override
    public String getIDPrefix() {
        return "User";
    }

    @Override
    public String getObjectTypeName() {
        return "User";
    }

    public static String[] getAuthTypes() {
        return AUTH_TYPES;
    }

    protected boolean checkAuthType(String value) {
        if (authTypeSet == null) {
            authTypeSet = new HashSet();
            authTypeSet.addAll(Arrays.asList(UserOracle.getAuthTypes()));
        }
        return authTypeSet.contains(value);
    }

    public void setAuthType(String value) {
        if (this.checkAuthType(value)) {
            this.authType = value;
            this.fireDataFieldChange();
        }
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String decodeIdentifier() {
        String result = this.getDesign().getLoadedVersion() < 3.3f ? this.identifier : crypt.decrypt(this.identifier);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void encodeIdentifier(String identifier) {
        this.identifier = crypt.encrypt(identifier);
    }

    public TableSpaceOracle getDefTableSpace() {
        return this.defTableSpace;
    }

    public void setDefTableSpace(TableSpaceOracle defTableSpace) {
        this.defTableSpace = defTableSpace;
        this.fireDataFieldChange();
    }

    public TemporaryTablespaceOracle getTempTableSpace() {
        return this.tempTableSpace;
    }

    public void setTempTableSpace(TemporaryTablespaceOracle tempTableSpace) {
        this.tempTableSpace = tempTableSpace;
        this.fireDataFieldChange();
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setPasswordExpire(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.passwordExpire = value;
            this.fireDataFieldChange();
        }
    }

    public String getPasswordExpire() {
        return this.passwordExpire;
    }

    public void setAccountLock(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.accountLock = value;
            this.fireDataFieldChange();
        }
    }

    public String getAccountLock() {
        return this.accountLock;
    }

    public static List getAuthTypesValues() {
        return authTypesList;
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof QuotaItemOracle) {
                QuotaItemOracle qi = (QuotaItemOracle)event.getAffected();
                qi.addObjectListener(this);
                if (qi.getUser() != null && qi.getUser() == this) {
                    qi.setParent(this.quotaitems);
                    this.quotaitems.add(qi);
                } else {
                    this.quotaitems.remove(qi);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof HashPartitionLobItemOracle) {
            QuotaItemOracle qi = (QuotaItemOracle)event.getAffected();
            this.quotaitems.remove(qi);
            qi.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof QuotaItemOracle) {
            QuotaItemOracle qi = (QuotaItemOracle)event.getAffected();
            if (qi.getUser() != null && qi.getUser() == this) {
                qi.setParent(this.quotaitems);
                this.quotaitems.add(qi);
            } else {
                this.quotaitems.remove(qi);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.quotaitems;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.quotaitems) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.quotaitems) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public void setAdminOption(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.adminOption = value;
            this.fireDataFieldChange();
        }
    }

    public String getAdminOption() {
        return this.adminOption;
    }

    public void setRoles(String role) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateRoleSet(role);
        } else {
            this.addRole(role);
        }
        this.roles = this.getRolesSet().toString();
        this.fireDataFieldChange();
    }

    public String getRoles() {
        return this.roles;
    }

    public void addRole(String role) {
        if (!this.getRolesSet().contains(role)) {
            this.getRolesSet().add(role);
        }
    }

    public void recreateRoleSet(String rls) {
        this.getRolesSet().clear();
        StringTokenizer st = new StringTokenizer(rls, ",");
        while (st.hasMoreTokens()) {
            this.getRolesSet().add(st.nextToken().trim());
        }
    }

    public InlineList getRolesSet() {
        if (this.roleSet == null) {
            this.roleSet = new InlineList();
        }
        return this.roleSet;
    }

    public void setRolesWithAdminOption(String role) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateRolesWithAdminOptionSet(role);
        } else {
            this.addRoleWithAdminOption(role);
        }
        this.rolesWithAdminOption = this.getRolesWithAdminOptionSet().toString();
        this.roles = this.getRolesSet().toString();
        this.fireDataFieldChange();
    }

    public InlineList getRolesWithAdminOptionSet() {
        if (this.rolesWithAdminOptionSet == null) {
            this.rolesWithAdminOptionSet = new InlineList();
        }
        return this.rolesWithAdminOptionSet;
    }

    public String getRolesWithAdminOptionNames() {
        StorageDesignOracle sd = (StorageDesignOracle)this.getStorageDesign();
        RoleSetOracle rs = sd.getRoleSet();
        String result = "";
        boolean first = true;
        Object[] roles = this.getRolesWithAdminOptionSet().toArray();
        for (int i = 0; i < roles.length; ++i) {
            String id = (String)roles[i];
            RoleOracle role = (RoleOracle)rs.getById(id);
            if (role == null) continue;
            if (!first) {
                result = result + "," + role.getName();
                continue;
            }
            result = role.getName();
            first = false;
        }
        return result;
    }

    public String getRolesNames() {
        StorageDesignOracle sd = (StorageDesignOracle)this.getStorageDesign();
        RoleSetOracle rs = sd.getRoleSet();
        String result = "";
        boolean first = true;
        Object[] roles = this.getRolesSet().toArray();
        for (int i = 0; i < roles.length; ++i) {
            String id = (String)roles[i];
            RoleOracle role = (RoleOracle)rs.getById(id);
            if (role == null) continue;
            if (!first) {
                result = result + "," + role.getName();
                continue;
            }
            result = role.getName();
            first = false;
        }
        return result;
    }

    protected void recreateRolesWithAdminOptionSet(String roles) {
        this.getRolesWithAdminOptionSet().clear();
        StringTokenizer st = new StringTokenizer(roles, ",");
        while (st.hasMoreTokens()) {
            this.getRolesWithAdminOptionSet().add(st.nextToken().trim());
        }
    }

    protected void addRoleWithAdminOption(String role) {
        if (!this.getRolesWithAdminOptionSet().contains(role)) {
            this.getRolesWithAdminOptionSet().add(role);
        }
    }

    public String getRolesWithAdminOption() {
        return this.rolesWithAdminOption;
    }

    public void setPrivileges(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSystemPrivilegesSet(privilege);
        } else {
            this.addPrivilege(privilege);
        }
        this.systemPrivileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public InlineList getPrivilegesSet() {
        if (this.systemPrivilegesSet == null) {
            this.systemPrivilegesSet = new InlineList();
        }
        return this.systemPrivilegesSet;
    }

    public String getPrivileges() {
        return this.systemPrivileges;
    }

    public void recreateSystemPrivilegesSet(String privileges) {
        this.getPrivilegesSet().clear();
        StringTokenizer st = new StringTokenizer(privileges, ",");
        while (st.hasMoreTokens()) {
            this.getPrivilegesSet().add(st.nextToken().trim());
        }
    }

    protected void addPrivilege(String systemPrivilege) {
        if (!this.getPrivilegesSet().contains(systemPrivilege)) {
            this.getPrivilegesSet().add(systemPrivilege);
        }
    }

    public void setPrivilegesWithAdminOption(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesWithAdminOptionSet(privilege);
        } else {
            this.addPrivilegeWithAdminOption(privilege);
        }
        this.privilegesWithAdminOption = this.getPrivilegesWithAdminOptionSet().toString();
        this.systemPrivileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public InlineList getPrivilegesWithAdminOptionSet() {
        if (this.privilegesWithAdminOptionSet == null) {
            this.privilegesWithAdminOptionSet = new InlineList();
        }
        return this.privilegesWithAdminOptionSet;
    }

    public String getPrivilegesWithAdminOption() {
        return this.privilegesWithAdminOption;
    }

    protected void recreatePrivilegesWithAdminOptionSet(String priv) {
        this.getPrivilegesWithAdminOptionSet().clear();
        StringTokenizer st = new StringTokenizer(priv, ",");
        while (st.hasMoreTokens()) {
            this.getPrivilegesWithAdminOptionSet().add(st.nextToken().trim());
        }
    }

    protected void addPrivilegeWithAdminOption(String privilege) {
        if (!this.getPrivilegesWithAdminOptionSet().contains(privilege)) {
            this.getPrivilegesWithAdminOptionSet().add(privilege);
        }
    }

    public void clear() {
        this.getPrivilegesSet().removeAllElements();
        this.getPrivilegesWithAdminOptionSet().removeAllElements();
        this.getRolesSet().removeAllElements();
        this.getRolesWithAdminOptionSet().removeAllElements();
        this.roles = "";
        this.rolesWithAdminOption = "";
        this.systemPrivileges = "";
        this.privilegesWithAdminOption = "";
    }

    public String getExternalName() {
        return this.externalName;
    }

    public void setExternalName(String externalName) {
        this.externalName = externalName;
    }

    @Override
    public String getNameSubstitutionType() {
        return "User";
    }

    public List getQuotaItems() {
        ArrayList list = new ArrayList();
        this.quotaitems.addAllElementsTo(list);
        return list;
    }

    public StorageObjectCollection getQuotaItemsCollection() {
        return this.quotaitems;
    }

    public QuotaItemOracle createQuotaItem() {
        if (this.quotaitems.getStorageObjectSet() != null) {
            return (QuotaItemOracle)this.quotaitems.createElement(null);
        }
        return null;
    }

    public List getPermissions() {
        ArrayList<PermissionsOracle> perms = new ArrayList<PermissionsOracle>();
        for (PermissionsOracle permission : ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet()) {
            if (permission.getUser() != this) continue;
            perms.add(permission);
        }
        return perms;
    }

    public PermissionsOracle createPermission() {
        PermissionsOracle permission = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().createPermissions();
        permission.setUser(this);
        return permission;
    }

    public void applyPermissionsList(List newPermissions) {
        List allPermissions;
        if (newPermissions.size() > 0 && (allPermissions = this.getPermissions()).size() > newPermissions.size()) {
            for (PermissionsOracle permission : allPermissions) {
                if (newPermissions.contains(permission)) continue;
                for (PermissionsOracle newPermission : newPermissions) {
                    if (!(permission.getTable() != null && permission.getTable() == newPermission.getTable() || permission.getView() != null && permission.getView() == newPermission.getView() || permission.getSequence() != null && permission.getSequence() == newPermission.getSequence() || permission.getSnapshot() != null && permission.getSnapshot() == newPermission.getSnapshot() || permission.getProc() != null && permission.getProc() == newPermission.getProc() || permission.getPackage() != null && permission.getPackage() == newPermission.getPackage() || permission.getFunctionOracle() != null && permission.getFunctionOracle() == newPermission.getFunctionOracle() || permission.getDirectoryOracle() != null && permission.getDirectoryOracle() == newPermission.getDirectoryOracle() || permission.getStructuredTypeOracle() != null && permission.getStructuredTypeOracle() == newPermission.getStructuredTypeOracle() || permission.getCollectionTypeOracle() != null && permission.getCollectionTypeOracle() == newPermission.getCollectionTypeOracle()) && (permission.getExternalTableOracle() == null || permission.getExternalTableOracle() != newPermission.getExternalTableOracle())) continue;
                    permission.remove();
                }
            }
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("USER_ICON", 16);
    }

    @Override
    public void clearNoneMergableStructure() {
        this.quotaitems.removeAll();
    }

    @Override
    public void setSchemaObject(SchemaObject schemaObject) {
        if (schemaObject != null && this.schemaObject != schemaObject) {
            ((StorageDesignOracle)this.getStorageDesign()).getUserSet().clearSchemaObjectForOthers(schemaObject, this);
        }
        this.schemaObject = schemaObject;
    }

    public String getDDLName() {
        if (this.isNameChanged() || this.getSchemaObject() == null) {
            return this.getName();
        }
        return this.getSchemaObject().getName();
    }

    @Override
    public void remove() {
        this.removePermissions();
        super.remove();
    }

    @Override
    public void remove(boolean force) {
        this.removePermissions();
        super.remove(force);
    }

    private void removePermissions() {
        for (PermissionsOracle perm : this.getPermissions()) {
            perm.clear();
            perm.remove();
        }
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }

    public static class StringComparator
    implements Comparator {
        public int compare(Object one, Object two) {
            return String.valueOf(one).compareTo(String.valueOf(two));
        }
    }
}

